package com.jshx.epQysq.service;

import java.util.List;
import java.util.Map;

import com.jshx.core.base.vo.Pagination;

public interface ActivitiController {

	/**
	 * 开启工作流
	 * 
	 * @paramkey:为工作流名称
	 * @paramvariables：里面存入message信息与user列表信息
	 */
	public String startProcessInstance(String key, String rowId, String userId, Map<String, Object> variables);

	// 过程流转与结束流程
	public void passProcess(String taskId, String remark, Map<String, Object> variables);

	// 终止流程
	public void endProcess(String processId);

	// 待办任务、已办任务使用sql语句查询
	public Pagination findBySqlId(Pagination pagination, Map<String, Object> paraMap);

	/**
	 * 转派人员
	 * 
	 * @param paraMap
	 *            taskId userId
	 */
	public void delegate(Map<String, Object> paraMap);

	/**
	 * 挂起流程
	 * 
	 * @param paraMap
	 *            processDefinitionId flag 0挂起 1解挂
	 */
	public void suspendOrActivateProcessDefinition(Map<String, Object> paraMap);

	// 流程节点变按钮
	public List<Map<String, Object>> buttonList(String taskId);

	// 显示工作流每一步的状态
	public List<Map<String, Object>> instanceDiagram(String processDefinitionId);
	// 下一步流程选人

	public void createAttachment(String string, String taskId, String processInstanceId, String string2,
			String string3);
	
}
