package com.jshx.epQysq.dao.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.Query;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.exception.BasalException;
import com.jshx.epQysq.dao.ActivitiControllerDao;

@Component("activitiControllerDao")
public class ActivitiControllerDaoImpl extends BaseDaoImpl implements ActivitiControllerDao {

	@Override
	public Pagination findBySqlId(Pagination pagination, Map paraMap) {
		// TODO Auto-generated method stub
		String hsql = this.getSqlStatementById(paraMap.get("SqlId").toString(), paraMap);
		String countSql = convertToCountSqlStatement(hsql);
		try {
			int count = 0;
			if (countSql != null) {
				Query countQuery = getSession().createSQLQuery(countSql);
				setQueryParameters(countQuery, paraMap);

				count = Integer.parseInt(countQuery.uniqueResult().toString());

				pagination.setTotalCount(count);
			}
			if ((hsql != null) && (count != 0)) {
				StringBuffer buffHSQL = new StringBuffer(hsql);

				Query query = getSession().createSQLQuery(buffHSQL.toString())
						.setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
				setQueryParameters(query, paraMap);
				query.setFirstResult(pagination.getFirstResult());
				query.setMaxResults(pagination.getPageSize());

				List restList = query.list();

				pagination.setList(restList);
			} else {
				if (hsql == null)
					throw new BasalException(BasalException.ERROR,
							"未在 SqlMap配置文件中配置, ID为" + paraMap.get("SqlId").toString() + "的hql 语句");
				if (count == 0)
					pagination.setList(new ArrayList());
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new BasalException(BasalException.ERROR, e.getCause().getMessage());
		}

		return pagination;
	}

	@Override
	public void updateBySql(Map paraMap) {
		// TODO Auto-generated method stub
		String hsql = this.getSqlStatementById(paraMap.get("SqlId").toString(), paraMap);
		Query countQuery = getSession().createSQLQuery(hsql);
		setQueryParameters(countQuery, paraMap);
		countQuery.executeUpdate();
	}
	
	

}
