package com.jshx.elicense.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.elicense.dao.ELicenseDao;
import com.jshx.elicense.dao.ELicenseFileDao;
import com.jshx.elicense.entity.ELicense;
import com.jshx.elicense.entity.ELicenseFile;
import com.jshx.elicense.service.ELicenseFileService;
import com.jshx.elicense.service.ELicenseService;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("eLicenseFileService")
public class ELicenseFileServiceImpl extends BaseServiceImpl implements ELicenseFileService {

    @Autowired
    @Qualifier("eLicenseFileDao")
    private ELicenseFileDao eLicenseFileDao;

    @Override
    public Pagination findByPage(Pagination page, Map<String, Object> paraMap) {
        return eLicenseFileDao.findByPage(page, paraMap);
    }

    @Override
    public List<ELicenseFile> findELicenseFileList(Map<String, Object> paraMap) {
        return eLicenseFileDao.findELicenseFileList(paraMap);
    }

    @Override
    public ELicenseFile getById(String id) {
        return eLicenseFileDao.getById(id);
    }

    @Transactional
    @Override
    public void save(ELicenseFile model) {
        eLicenseFileDao.save(model);
    }

    @Transactional
    @Override
    public void update(ELicenseFile model) {
        eLicenseFileDao.update(model);
    }

    @Transactional
    @Override
    public void delete(String[] ids) {
        List list= Arrays.asList(ids);

        Map<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("ids", list);
        List objects=eLicenseFileDao.findELicenseFileList(paraMap);

        eLicenseFileDao.removeAll(objects);
    }

    @Transactional
    @Override
    public void deleteWithFlag(String ids) {
        String[] idArray = ids.split("\\|");
        if(null != idArray)
        {
            for(String id : idArray)
            {
                if(id!=null && !id.trim().equals(""))
                    eLicenseFileDao.deleteWithFlag(id);
            }
        }
    }
}
