package com.jshx.dxpz.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.dxpz.entity.Dxpz;
import com.jshx.dxpz.dao.DxpzDao;

@Component("dxpzDao")
public class DxpzDaoImpl extends BaseDaoImpl implements DxpzDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findDxpzByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findDxpz(Map<String, Object> paraMap){
		return this.findListByHqlId("findDxpzByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Dxpz getById(String id)
	{
		return (Dxpz)this.getObjectById(Dxpz.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Dxpz dxpz)
	{
		dxpz.setId(null);
		this.saveOrUpdateObject(dxpz);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Dxpz dxpz)
	{
		this.saveOrUpdateObject(dxpz);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Dxpz.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Dxpz dxpz = (Dxpz)this.getObjectById(Dxpz.class, id);
		dxpz.setDelFlag(1);
		this.saveObject(dxpz);
	}
}
