package com.jshx.billPayment.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.HibernateUtil;
import com.jshx.billPayment.entity.Bill;
import com.jshx.billPayment.entity.Billpayment;
import com.jshx.billManager.entity.Indeticur;
import com.jshx.billPayment.dao.BillpaymentDao;

@Component("billpaymentDao")
public class BillpaymentDaoImpl extends BaseDaoImpl implements BillpaymentDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findBillpaymentByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findBillpayment(Map<String, Object> paraMap){
		return this.findListByHqlId("findBillpaymentByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Billpayment getById(String id)
	{
		return (Billpayment)this.getObjectById(Billpayment.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Billpayment billpayment)
	{
		billpayment.setId(null);
		this.saveOrUpdateObject(billpayment);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Billpayment billpayment)
	{
		this.saveOrUpdateObject(billpayment);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Billpayment.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Billpayment billpayment = (Billpayment)this.getObjectById(Billpayment.class, id);
		billpayment.setDelFlag(1);
		this.saveObject(billpayment);
	}

	@Override
	public void save(Bill model) {
		model.setId(null);
		this.saveOrUpdateObject(model);
		
	}

	@Override
	public void update(Bill model) {
		this.saveOrUpdateObject(model);
		
	}

	@Override
	public void batchupdate(List<Bill> list) {
	    Session session = null;  
        if (list != null && list.size() > 0) {  
            try {  
                session = HibernateUtil.getSession();   
                session.beginTransaction(); 
                Bill Indeticur = null; 
               
                for (int i = 0; i < list.size(); i++) {  
                	Indeticur = list.get(i); 
                    session.saveOrUpdate(Indeticur); 
                    if (i % 100 == 0) {  
                        session.flush();  
                        session.clear();  
                    }  
                }  
                session.getTransaction().commit(); // 提交事物  
            } catch (Exception e) {  
                e.printStackTrace(); // 打印错误信息  
                session.getTransaction().rollback(); // 出错将回滚事物  
            } 
        } 
	}

	@Override
	public int findcountByMap(Map<String, Object> paraMap) {
		List list = this.findListByHqlId("findBillByMap", paraMap);
		return list.size();
	}


}
