package com.jshx.account.paymentVoucher.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.account.paymentVoucher.entity.PaymentVoucher;
import com.jshx.account.paymentVoucher.dao.PaymentVoucherDao;

@Component("paymentVoucherDao")
public class PaymentVoucherDaoImpl extends BaseDaoImpl implements PaymentVoucherDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findPaymentVoucherByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findPaymentVoucher(Map<String, Object> paraMap){
		return this.findListByHqlId("findPaymentVoucherByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public PaymentVoucher getById(String id)
	{
		return (PaymentVoucher)this.getObjectById(PaymentVoucher.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(PaymentVoucher paymentVoucher)
	{
		paymentVoucher.setId(null);
		this.saveOrUpdateObject(paymentVoucher);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(PaymentVoucher paymentVoucher)
	{
		this.saveOrUpdateObject(paymentVoucher);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(PaymentVoucher.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		PaymentVoucher paymentVoucher = (PaymentVoucher)this.getObjectById(PaymentVoucher.class, id);
		paymentVoucher.setDelFlag(1);
		this.saveObject(paymentVoucher);
	}
}
