package com.jshx.account.accountBank.entity;

import java.sql.Blob;
import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.jshx.core.base.entity.BaseModel;
import com.jshx.module.admin.entity.User;


/**
 * 实体类模板（目前仅适配MS-SQLServer数据库）
 * @author
 *
 */
@SuppressWarnings("serial")
@Entity
@Table(name="ACCOUNT_BANK")
public class AccountBank extends BaseModel
{
	/**
	 * 部门代码
	 */
	private String deptId;

	/**
	 * 删除标记
	 */
	private Integer delFlag;

	
	/**
	 * 受理编号
	 */
	private String orderId; 
	
	/**
	 * 建设单位
	 */
	private String developUnit;

	/**
	 * 金额
	 */
	private Double amount;

	/**
	 * 到账时间
	 */
	private Date arrivalTime;

	/**
	 * 备注
	 */
	private String remark;

	/**
	 * 有无凭证
	 */
	private String hasInvoice;
	
	/**
	 * 处理状态
	 * 0:待审核 1：已审核
	 */
	private String status;
	
	/**
	 * 附件内容
	 */
	private List<AccountBankAttach> attach;
	
	/**
	 * 银行经办人
	 */
	private User bankUser;

	/**
	 * 子系统类型
	 */
	private String sysType;
	
	public AccountBank(){
	}
	
	public AccountBank(String id, String orderId, String developUnit, Double amount, Date arrivalTime, String hasInvoice){
		
		this.id = id;
		
		this.orderId = orderId;
		
		this.developUnit = developUnit;
		
		this.amount = amount;
		
		this.arrivalTime = arrivalTime;
		
		this.hasInvoice = hasInvoice;
	}


	@Column
	public String getDeptId()
	{
		return deptId;
	}

	public void setDeptId(String deptId)
	{
		this.deptId = deptId;
	}

	@Column
	public Integer getDelFlag()
	{
		return delFlag;
	}

	public void setDelFlag(Integer delFlag)
	{
		this.delFlag = delFlag;
	}

	
	@Column(name="ORDER_ID")
	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	@Column(name="DEVELOP_UNIT")
	public String getDevelopUnit()
	{
		return this.developUnit;
	}

	public void setDevelopUnit(String developUnit)
	{
		this.developUnit = developUnit;
	}

	@Column(name="AMOUNT")
	public Double getAmount()
	{
		return this.amount;
	}

	public void setAmount(Double amount)
	{
		this.amount = amount;
	}

	@Column(name="ARRIVAL_TIME")
	public Date getArrivalTime()
	{
		return this.arrivalTime;
	}

	public void setArrivalTime(Date arrivalTime)
	{
		this.arrivalTime = arrivalTime;
	}

	@Column(name="REMARK")
	public String getRemark()
	{
		return this.remark;
	}

	public void setRemark(String remark)
	{
		this.remark = remark;
	}

	@Column(name="HAS_INVOICE")
	public String getHasInvoice()
	{
		return this.hasInvoice;
	}

	public void setHasInvoice(String hasInvoice)
	{
		this.hasInvoice = hasInvoice;
	}
	
	@Column(name="STATUS")
	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	@OneToMany(mappedBy = "id", cascade = {CascadeType.ALL}, fetch = FetchType.LAZY)
	public List<AccountBankAttach> getAttach() {
		return attach;
	}

	public void setAttach(List<AccountBankAttach> attach) {
		this.attach = attach;
	}
	
	@ManyToOne(fetch = FetchType.EAGER, targetEntity=User.class)
	@JoinColumn(name = "CREATEUSERID",updatable=false,insertable=false)
	public User getBankUser() {
		return bankUser;
	}

	public void setBankUser(User bankUser) {
		this.bankUser = bankUser;
	}

	@Column(name="SYS_TYPE")
	public String getSysType() {
		return sysType;
	}

	public void setSysType(String sysType) {
		this.sysType = sysType;
	}
}
