package com.jshx.account.accountBank.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.fawen.entity.FawenAttach;
import com.jshx.account.accountBank.entity.AccountBankAttach;
import com.jshx.account.accountBank.dao.AccountBankAttachDao;

@Component("accountBankAttachDao")
public class AccountBankAttachDaoImpl extends BaseDaoImpl implements AccountBankAttachDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findAccountBankAttachByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findAccountBankAttach(Map<String, Object> paraMap){
		return this.findListByHqlId("findAccountBankAttachByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public AccountBankAttach getById(String id)
	{
		return (AccountBankAttach)this.getObjectById(AccountBankAttach.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(AccountBankAttach accountBankAttach)
	{
		accountBankAttach.setId(null);
		this.saveOrUpdateObject(accountBankAttach);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(AccountBankAttach accountBankAttach)
	{
		this.saveOrUpdateObject(accountBankAttach);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(AccountBankAttach.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		AccountBankAttach accountBankAttach = (AccountBankAttach)this.getObjectById(AccountBankAttach.class, id);
		accountBankAttach.setDelFlag(1);
		this.saveObject(accountBankAttach);
	}
	
	/**
	 * 根据模板ID取相应的附件
	 * @param paramsMap
	 * @return
	 */
	@Override
	public List<AccountBankAttach> queryAttachListByTempleId(
			Map<String, String> paramsMap) {
		// TODO Auto-generated method stub
		return this.findListByHqlId("findAccountBankAttachByMap", paramsMap);
	}
}
