/*    */ package cn.com.jshx.smgp.message;
/*    */ 
/*    */ import cn.com.jshx.smgp.protocol.RequestId;
/*    */ import cn.com.jshx.util.Key;
/*    */ import cn.com.jshx.util.TypeConvert;
/*    */ import java.security.NoSuchAlgorithmException;
/*    */ 
/*    */ public class LoginRespMessage extends Message
/*    */ {
/* 10 */   private int Status = 0;
/* 11 */   private byte[] AuthenticatorServer = null;
/* 12 */   private String Version = "";
/*    */ 
/*    */   public LoginRespMessage(int sequence_Id, int status, byte[] authenticatorsclient, String sharekey, String serverversion)
/*    */   {
/*    */     try
/*    */     {
/* 18 */       int len = 33;
/* 19 */       this.buf = new byte[len];
/* 20 */       TypeConvert.int2byte(len, this.buf, 0);
/* 21 */       TypeConvert.int2byte(RequestId.Login_Resp, this.buf, 4);
/* 22 */       TypeConvert.int2byte(sequence_Id, this.buf, 8);
/* 23 */       TypeConvert.int2byte(status, this.buf, 12);
/*    */ 
/* 25 */       byte[] authorityserver = Key.GenerateAuthenticatorServer(status, 
/* 26 */         authenticatorsclient, sharekey);
/* 27 */       System.arraycopy(authorityserver, 0, this.buf, 16, authorityserver.length);
/*    */ 
/* 30 */       TypeConvert.int2byte3(getVersion(serverversion), this.buf, 16 + authorityserver.length);
/*    */     }
/*    */     catch (NoSuchAlgorithmException e) {
/* 33 */       e.printStackTrace();
/*    */     }
/*    */   }
/*    */ 
/*    */   private int getVersion(String version) {
/* 38 */     return Integer.parseInt(version.substring(0, version.indexOf("."))) * 16 + Integer.parseInt(version.substring(version.indexOf(".") + 1));
/*    */   }
/*    */   public LoginRespMessage(byte[] buffer) {
/* 41 */     if (buffer.length != 25) {
/* 42 */       throw new IllegalArgumentException("LoginResp Package resolv Error");
/*    */     }
/*    */ 
/* 46 */     this.sequence_Id = TypeConvert.byte2int(buffer, 0);
/* 47 */     this.Status = TypeConvert.byte2int(buffer, 4);
/* 48 */     this.AuthenticatorServer = new byte[16];
/* 49 */     System.arraycopy(buffer, 8, this.AuthenticatorServer, 0, 
/* 50 */       this.AuthenticatorServer.length);
/*    */ 
/* 52 */     this.Version = 
/* 53 */       (buffer[24] / 16 + "." + 
/* 53 */       buffer[24] % 16);
/*    */   }
/*    */ 
/*    */   public String getServerVersion()
/*    */   {
/* 58 */     return this.Version;
/*    */   }
/*    */ 
/*    */   public int getSequenceId() {
/* 62 */     return this.sequence_Id;
/*    */   }
/*    */ 
/*    */   public int getStatus() {
/* 66 */     return this.Status;
/*    */   }
/*    */ 
/*    */   public byte[] getAuthenticatorServer() {
/* 70 */     return this.AuthenticatorServer;
/*    */   }
/*    */ }

/* Location:           C:\Users\Administrator\Desktop\message-1.0.1.jar
 * Qualified Name:     cn.com.jshx.smgp.message.LoginRespMessage
 * JD-Core Version:    0.6.2
 */