/*     */ package cn.com.jshx.smgp.message;
/*     */ 
/*     */ import cn.com.jshx.smgp.protocol.RequestId;
/*     */ import cn.com.jshx.util.DateUtil;
/*     */ import cn.com.jshx.util.Key;
/*     */ import cn.com.jshx.util.TypeConvert;
/*     */ import java.security.NoSuchAlgorithmException;
/*     */ 
/*     */ public class LoginMessage extends Message
/*     */ {
/*     */   private String clientID;
/*     */   private byte[] authenticatorClient;
/*     */   private String sharedKey;
/*     */   private int loginMode;
/*     */   private String clientVersion;
/*     */   private int timeStamp;
/*     */ 
/*     */   public LoginMessage(byte[] buffer)
/*     */   {
/*  20 */     int len = buffer.length;
/*     */ 
/*  23 */     this.buf = new byte[len + 4];
/*  24 */     TypeConvert.int2byte(len, this.buf, 0);
/*  25 */     System.arraycopy(buffer, 0, this.buf, 4, len);
/*     */ 
/*  27 */     this.sequence_Id = TypeConvert.byte2int(buffer, 4);
/*  28 */     this.clientID = TypeConvert.getString(buffer, 8, 0, 8);
/*  29 */     this.authenticatorClient = new byte[16];
/*  30 */     System.arraycopy(buffer, 16, this.authenticatorClient, 0, 16);
/*  31 */     this.loginMode = buffer[32];
/*  32 */     this.clientVersion = getVersion(buffer[37]);
/*  33 */     setTimeStamp(TypeConvert.byte2int(buffer, 33));
/*     */   }
/*     */ 
/*     */   private static String getVersion(int version)
/*     */   {
/*  38 */     return version / 16 + "." + (version - version / 16 * 16);
/*     */   }
/*     */ 
/*     */   public LoginMessage(String ClientID, String shared_Secret, int LoginMode) throws IllegalArgumentException, NoSuchAlgorithmException
/*     */   {
/*  43 */     this.clientID = ClientID;
/*  44 */     this.loginMode = LoginMode;
/*  45 */     this.sharedKey = shared_Secret;
/*     */ 
/*  47 */     if (ClientID == null)
/*  48 */       throw new IllegalArgumentException("ClientID isNull");
/*  49 */     if (ClientID.length() > 8)
/*  50 */       throw new IllegalArgumentException(
/*  51 */         "ClientID is length is great then 8");
/*  52 */     if (ClientID.length() > 8)
/*  53 */       throw new IllegalArgumentException(
/*  54 */         "ClientID is length is great then 8");
/*  55 */     int len = 42;
/*  56 */     this.buf = new byte[len];
/*  57 */     TypeConvert.int2byte(len, this.buf, 0);
/*  58 */     TypeConvert.int2byte(RequestId.Login, this.buf, 4);
/*  59 */     System.arraycopy(ClientID.getBytes(), 0, this.buf, 12, ClientID.length());
/*     */ 
/*  62 */     String timeStamp = DateUtil.GetTimeString();
/*  63 */     byte[] sharekey = Key.GenerateAuthenticatorClient(ClientID, shared_Secret, 
/*  64 */       timeStamp);
/*  65 */     System.arraycopy(sharekey, 0, this.buf, 20, sharekey.length);
/*     */ 
/*  67 */     this.buf[36] = ((byte)LoginMode);
/*     */ 
/*  71 */     TypeConvert.int2byte(Integer.parseInt(timeStamp), this.buf, 37);
/*     */ 
/*  73 */     this.buf[41] = 48;
/*     */   }
/*     */ 
/*     */   public String getClientID() {
/*  77 */     return this.clientID;
/*     */   }
/*     */ 
/*     */   public byte[] getAuthenticatorClient() {
/*  81 */     return this.authenticatorClient;
/*     */   }
/*     */ 
/*     */   public String getSharedKey() {
/*  85 */     return this.sharedKey;
/*     */   }
/*     */ 
/*     */   public int getLoginMode() {
/*  89 */     return this.loginMode;
/*     */   }
/*     */   public String getClientVersion() {
/*  92 */     return this.clientVersion;
/*     */   }
/*     */ 
/*     */   public void setTimeStamp(int timeStamp) {
/*  96 */     this.timeStamp = timeStamp;
/*     */   }
/*     */ 
/*     */   public int getTimeStamp() {
/* 100 */     return this.timeStamp;
/*     */   }
/*     */ }

/* Location:           C:\Users\Administrator\Desktop\message-1.0.1.jar
 * Qualified Name:     cn.com.jshx.smgp.message.LoginMessage
 * JD-Core Version:    0.6.2
 */