/*     */ package cn.com.jshx.smgp.message;
/*     */ 
/*     */ import cn.com.jshx.smgp.bean.Deliver;
/*     */ import cn.com.jshx.smgp.protocol.RequestId;
/*     */ import cn.com.jshx.smgp.protocol.Tlv;
/*     */ import cn.com.jshx.smgp.protocol.TlvId;
/*     */ import cn.com.jshx.smgp.protocol.TlvUtil;
/*     */ import cn.com.jshx.util.Hex;
/*     */ import cn.com.jshx.util.TypeConvert;
/*     */ import java.util.Vector;
/*     */ 
/*     */ public class DeliverMessage extends Message
/*     */ {
/*     */   public byte[] MsgID_BCD;
/*     */   public String MsgID;
/*     */   public int IsReport;
/*     */   public int MsgFormat;
/*     */   public String RecvTime;
/*     */   public String SrcTermID;
/*     */   public String DestTermID;
/*     */   public int MsgLength;
/*     */   public byte[] MsgContent;
/*     */   public byte[] Reserve;
/*     */   public String LinkID;
/*     */   public int TP_udhi;
/*     */   public String ReportMsgID;
/*     */   public Tlv[] OtherTlv;
/*     */ 
/*     */   public DeliverMessage(Deliver deliver)
/*     */   {
/*  31 */     this.MsgID = deliver.MsgID;
/*  32 */     this.IsReport = deliver.IsReport;
/*  33 */     this.MsgFormat = deliver.MsgFormat;
/*  34 */     this.RecvTime = deliver.RecvTime;
/*  35 */     this.SrcTermID = deliver.SrcTermID;
/*  36 */     this.DestTermID = deliver.DestTermID;
/*  37 */     this.MsgLength = deliver.MsgLength;
/*  38 */     this.MsgContent = deliver.MsgContent;
/*  39 */     this.Reserve = deliver.Reserve;
/*  40 */     this.LinkID = deliver.LinkID;
/*  41 */     this.TP_udhi = deliver.TP_udhi;
/*  42 */     this.OtherTlv = deliver.OtherTlv;
/*     */ 
/*  45 */     int len = 89 + deliver.MsgLength;
/*     */ 
/*  49 */     int tlvlength = 0;
/*  50 */     Vector tlvV = new Vector();
/*  51 */     if (this.LinkID != null)
/*  52 */       tlvV.add(new Tlv(TlvId.LinkID, this.LinkID));
/*  53 */     if (this.TP_udhi != 0)
/*  54 */       tlvV.add(new Tlv(TlvId.TP_udhi, String.valueOf(this.TP_udhi)));
/*  55 */     if (this.OtherTlv != null) {
/*  56 */       for (int i = 0; i < this.OtherTlv.length; i++) {
/*  57 */         tlvV.add(this.OtherTlv[i]);
/*     */       }
/*     */     }
/*  60 */     Tlv[] tlvarray = new Tlv[tlvV.size()];
/*  61 */     for (int i = 0; i < tlvV.size(); i++) {
/*  62 */       tlvarray[i] = ((Tlv)tlvV.get(i));
/*  63 */       tlvlength += tlvarray[i].TlvBuf.length;
/*     */     }
/*     */ 
/*  66 */     len += tlvlength;
/*  67 */     this.buf = new byte[len];
/*  68 */     TypeConvert.int2byte(len, this.buf, 0);
/*  69 */     TypeConvert.int2byte(RequestId.Deliver, this.buf, 4);
/*  70 */     TypeConvert.int2byte(this.sequence_Id, this.buf, 8);
/*     */ 
/*  72 */     System.arraycopy(Hex.rstr(this.MsgID), 0, this.buf, 12, 10);
/*  73 */     this.buf[22] = ((byte)this.IsReport);
/*  74 */     this.buf[23] = ((byte)this.MsgFormat);
/*  75 */     System.arraycopy(this.RecvTime.getBytes(), 0, this.buf, 24, 
/*  76 */       this.RecvTime.length());
/*  77 */     System.arraycopy(this.SrcTermID.getBytes(), 0, this.buf, 38, 
/*  78 */       this.SrcTermID.length());
/*  79 */     System.arraycopy(this.DestTermID.getBytes(), 0, this.buf, 59, 
/*  80 */       this.DestTermID.length());
/*  81 */     this.buf[80] = ((byte)this.MsgLength);
/*  82 */     System.arraycopy(this.MsgContent, 0, this.buf, 81, this.MsgLength);
/*  83 */     if (this.Reserve != null) {
/*  84 */       System.arraycopy(this.Reserve, 0, this.buf, 81 + this.MsgLength, 
/*  85 */         this.Reserve.length);
/*     */     }
/*  87 */     int cur = 81 + this.MsgLength + 8;
/*  88 */     for (int i = 0; i < tlvarray.length; i++) {
/*  89 */       System.arraycopy(tlvarray[i].TlvBuf, 0, this.buf, cur, 
/*  90 */         tlvarray[i].TlvBuf.length);
/*  91 */       cur += tlvarray[i].TlvBuf.length;
/*     */     }
/*     */   }
/*     */ 
/*     */   public DeliverMessage(byte[] buffer)
/*     */   {
/*  98 */     this.sequence_Id = TypeConvert.byte2int(buffer, 0);
/*  99 */     this.MsgID_BCD = new byte[10];
/* 100 */     System.arraycopy(buffer, 4, this.MsgID_BCD, 0, this.MsgID_BCD.length);
/* 101 */     this.MsgID = TypeConvert.getHexString(buffer, 4, 0, 10);
/* 102 */     this.IsReport = buffer[14];
/* 103 */     this.MsgFormat = buffer[15];
/* 104 */     this.RecvTime = TypeConvert.getString(buffer, 16, 0, 14);
/* 105 */     this.SrcTermID = TypeConvert.getString(buffer, 30, 0, 21);
/* 106 */     this.DestTermID = TypeConvert.getString(buffer, 51, 0, 21);
/* 107 */     this.MsgLength = (buffer[72] & 0xFF);
/*     */ 
/* 109 */     this.MsgContent = new byte[this.MsgLength];
/* 110 */     System.arraycopy(buffer, 73, this.MsgContent, 0, this.MsgLength);
/*     */ 
/* 112 */     if (this.IsReport == 1) {
/* 113 */       byte[] tmpmsgid = new byte[10];
/* 114 */       System.arraycopy(this.MsgContent, 3, tmpmsgid, 0, 10);
/* 115 */       this.ReportMsgID = Hex.rhex(tmpmsgid);
/*     */     }
/*     */ 
/* 119 */     this.Reserve = new byte[8];
/* 120 */     System.arraycopy(buffer, 73 + this.MsgLength, this.Reserve, 0, 
/* 121 */       this.Reserve.length);
/*     */ 
/* 123 */     byte[] tlv = new byte[buffer.length - 73 - this.MsgLength - 8];
/* 124 */     System.arraycopy(buffer, this.MsgLength + 73 + 8, tlv, 0, tlv.length);
/*     */ 
/* 126 */     Tlv[] otherTlv = TlvUtil.TlvAnalysis(tlv);
/* 127 */     this.OtherTlv = otherTlv;
/*     */ 
/* 129 */     for (int i = 0; i < otherTlv.length; i++)
/* 130 */       if (otherTlv[i].Tag == TlvId.LinkID)
/* 131 */         this.LinkID = otherTlv[i].Value;
/* 132 */       else if (otherTlv[i].Tag == TlvId.TP_udhi)
/* 133 */         this.TP_udhi = Integer.parseInt(otherTlv[i].Value);
/*     */   }
/*     */ }

/* Location:           C:\Users\Administrator\Desktop\message-1.0.1.jar
 * Qualified Name:     cn.com.jshx.smgp.message.DeliverMessage
 * JD-Core Version:    0.6.2
 */