package com.jshx.sensitive;

import com.jshx.core.exception.BasalException;
import com.jshx.core.security.XSSSecurityCon;
import com.jshx.core.utils.Constants;
import org.apache.log4j.Logger;
import org.apache.struts2.dispatcher.multipart.MultiPartRequest;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

public class SensitivewordFilter implements Filter{

	private final static Logger logger = Logger.getLogger(SensitivewordFilter.class);

	public static int minMatchTYpe = 1;
	public static int maxMatchType = 2;

	@Override
	public void init(FilterConfig filterConfig) throws ServletException {

	}

	@Override
	public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
		Map<String, String> urlMap = Constants.CODE_MAP.get(SensitiveWordUtil.SENSITIVE_FILTER_URL_CODE);
		HttpServletRequest request = (HttpServletRequest)servletRequest;
		HttpServletResponse response = (HttpServletResponse)servletResponse;
		String requestUri = request.getRequestURI();
		if(urlMap.containsValue(requestUri)){
			Enumeration<String> params = request.getParameterNames();
			while(params.hasMoreElements()){
				String param = params.nextElement();
				String[] values = request.getParameterValues(param);
				for(String value: values){
					if(SensitiveWordUtil.isContaintSensitiveWord(value, 1)){
						logger.warn(value + "含有敏感词");
						Throwable t = new Throwable(request.getRequestURI()+" - "+request.getQueryString());
						BasalException e = new BasalException(2, "请求中包含敏感词", t);
						request.getSession().setAttribute("exceptionObject", e);
						response.setStatus(403);;
						request.getRequestDispatcher(XSSSecurityCon.FILTER_ERROR_PAGE).forward(request, response);
						return;
					}
				}
			}
		}
		filterChain.doFilter(servletRequest, servletResponse);
	}

	@Override
	public void destroy() {

	}
}
