package com.jshx.module.infomation.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import org.hibernate.Hibernate;
import org.springframework.beans.factory.annotation.Autowired;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.base.vo.UploadFile;
import com.jshx.core.exception.BasalException;
import com.jshx.core.utils.Constants;
import com.jshx.core.utils.DateUtil;
import com.jshx.core.utils.Struts2Util;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.module.admin.entity.User;
import com.jshx.module.infomation.entity.ContentAttachs;
import com.jshx.module.infomation.entity.ContentInformations;
import com.jshx.module.infomation.service.ContentAttachsService;
import com.jshx.module.infomation.service.ContentInformationsService;

public class ContentInformationsAction extends BaseAction
{
	private static final long serialVersionUID = 3967636502860318998L;

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private ContentInformations contentInformations = new ContentInformations();

	/**
	 * 业务类
	 */
	@Autowired
	private ContentInformationsService contentInformationsService;
	
	@Autowired
	private ContentAttachsService contentAttachsService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	private Date queryPublicDateStart;

	private Date queryPublicDateEnd;
	
	
	/** 文件 */
	private List<File> Filedata;

	/** 文件名 */
	private List<String> FiledataFileName;

	/** 文件内容类型 */
	private List<String> FiledataContentType;
	
	/**
	 * 从页面传递的信息内容
	 */
	private String infoContent;
	
	private User user;
	
	/*查询条件中的是否显示禁用信息*/
	private String isDelshow;
	
	/*查询条件中的是否显示过期信息*/
	private String isExpireshow;
	
	/*查询条件中的发布人*/
	private String username;
	

	/**
	 * 附件信息
	 * */
	private List<File> upload;
	
	private List<String> uploadFileName;

	private List<String> uploadContentType;
	
	/**附件类型*/
	private List<String> attachType;
	
	/**查看详情和修改中的附件列表*/
	private List<ContentAttachs> attachList;
	
	/**查看详情中的附件个数*/
	private int attachCount;
	
	/**用来删除和下载附件*/
	private String attachId;
	
	public List<ContentAttachs> getAttachList() {
		return attachList;
	}

	public void setAttachList(List<ContentAttachs> attachList) {
		this.attachList = attachList;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getInfoContent() {
		return infoContent;
	}

	public void setInfoContent(String infoContent) {
		this.infoContent = infoContent;
	}

	public String initList(){
	    return SUCCESS;
	}
	
	/**
	 * 执行查询的方法，返回json数据<br>
	 * json包含的属性："infoTitle|infoType|topFlag|expireFlag|delFlag|user|user.displayName|dept|dept.deptName|publicDate|time|id|"
	 */
	public String list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != contentInformations){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != contentInformations.getInfoTitle()) && (0 < contentInformations.getInfoTitle().trim().length())){
				paraMap.put("infoTitle", "%" + contentInformations.getInfoTitle().trim() + "%");
			}

			if ((null != contentInformations.getInfoType()) && (0 < contentInformations.getInfoType().trim().length())){
				paraMap.put("infoType", contentInformations.getInfoType().trim());
			}
            
			if((null == this.getIsDelshow())||(this.getIsDelshow().trim().equalsIgnoreCase("0"))){
				paraMap.put("delFlag", "0");
			}
			
			if((null == this.getIsExpireshow())||(this.getIsExpireshow().trim().equalsIgnoreCase("0"))){
				paraMap.put("expireFlag", "0");
			}

			if ((null != this.getUsername()) && (0 < this.getUsername().trim().length())){
				paraMap.put("username", "%" + this.getUsername().trim() + "%");
			}

			if (null != queryPublicDateStart){
				paraMap.put("startPublicDate", queryPublicDateStart);
			}

			if (null != queryPublicDateEnd){
				paraMap.put("endPublicDate", queryPublicDateEnd);
			}
		}
		
		pagination = contentInformationsService.findByPage(pagination, paraMap);
		
		//将查询结果转为json数据给datagrid展现
		StringBuffer data = new StringBuffer("{\n");
		data.append("  \"total\":").append(pagination.getTotalCount()).append(",\n");
		data.append("  \"rows\":\n");
		
		final String colNames = new String(
				"infoTitle|infoType|topFlag|expireFlag|delFlag|user|user.displayName|dept|dept.deptName|publicDate|time|id|");
		JsonConfig config = new JsonConfig();
		config.setJsonPropertyFilter(new PropertyFilter() {
			public boolean apply(Object source, String name, Object value) {
				if (colNames.indexOf(name + "|") != -1)
					return false;
				else
					return true;
			}
		});
		JSONArray json = JSONArray.fromObject(pagination.getListOfObject(),
				config);
		data.append(json.toString());
		data.append("  \n").append("}");
		
		try {
			this.getResponse().getWriter().println(data);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return null;
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != contentInformations)&&(null != contentInformations.getId())){
			contentInformations = contentInformationsService.getById(contentInformations.getId());
			//infoContent="";
			infoContent = contentInformations.getInfoContent();
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("infoId", contentInformations.getId());
			attachList = contentAttachsService.findContentAttachs(paraMap);
			attachCount = attachList.size();
		}
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		user=this.getLoginUser();
		view();
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		//获取上传的所有附件的大小
		double uploadSize=0.0;
		if (upload != null && upload.isEmpty() == false) {
			for (int i = 0; i < upload.size(); i++) {
				File file = upload.get(i);
				FileInputStream fis = null;
				try{
                    fis = new FileInputStream(file); 
                    uploadSize+=fis.available()/1024;
                    //System.out.println("######################文件size:"+String.valueOf(fis.available()/1000)+"k");
                }catch(IOException e1){   
                    System.out.println("IO出错！");
                }
			}
		}
		//如果附件大小小于10M就上传
		if(uploadSize<10240){
			if ("add".equalsIgnoreCase(this.flag)){
				contentInformations.setUserId(this.getLoginUserId());
				contentInformations.setDeptId(this.getLoginUserDepartmentId());
				contentInformations.setDelFlag("0");
				contentInformations.setExpireFlag("0");
				contentInformations.setInfoContent(null);
				contentInformationsService.save(contentInformations);
				contentInformations.setInfoContent(infoContent);
				contentInformationsService.update(contentInformations);
			}else{
				contentInformations.setInfoContent(infoContent);
				contentInformationsService.update(contentInformations);
			}
			uploadAttach();
			return RELOAD;
		}//附件大小大于10M
		else{
			BasalException ex = new BasalException(BasalException.NO, Constants.UPLOAD_FILE_SIZE_OVERFLOW);
			view();
			throw ex;
		}
	}
	
	/**
	 * 更新附件
	 */
	private boolean uploadAttach() {

		try {
			if (upload != null && upload.isEmpty() == false) {
				for (int i = 0; i < upload.size(); i++) {
					ContentAttachs contentAttaFile = new ContentAttachs();
					File file = upload.get(i);
					UploadFile uploadFile = new UploadFile();
					uploadFile.setFileName(uploadFileName.get(i));
					uploadFile.setFileType(uploadContentType.get(i));
					uploadFile.setUploadFile(file);
					String rename = UUID.randomUUID().toString() + "."
							+ getFileSuffix(uploadFileName.get(i));
					String path = Struts2Util.getServletContext().getRealPath(
							"/");
					uploadFile.setId(rename);
					uploadFile.setFilePath(path
							+ SysPropertiesUtil.getProperty("uploadFile")
							+ "\\"
							+ DateUtil.convertDateToString(
									DateUtil.DATE_FORMAT_YYYYMMDD, new Date())
							+ "\\");
					uploadFile.uploadToServer();
					uploadFile.setFilePath(SysPropertiesUtil
							.getProperty("uploadFile")
							+ "\\"
							+ DateUtil.convertDateToString(
									DateUtil.DATE_FORMAT_YYYYMMDD, new Date())
							+ "\\");
					/** **将附件存入数据库**** */
					//contentAttaFile.setDeptId(this.getLoginUserDepartmentId());
					contentAttaFile.setDelFlag(0);
					contentAttaFile.setInfoId(contentInformations.getId());
					contentAttaFile.setAttachName(rename);
					contentAttaFile.setDocName(uploadFile.getFileName());
					contentAttaFile.setDocType(this.getAttachType().get(i));
					contentAttaFile.setDocUrl(uploadFile.getFilePath());
					contentAttachsService.save(contentAttaFile);	

				}

			}
			return true;
			
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}

	}
	
	/**
	 * 删除信息附件信息
	 */
	public void deleteInfoAttach() throws Exception {
		contentAttachsService.deleteAttachById(attachId);
	}
    
	/**
	 * 下载附件
	 */
	public void download() {
		try {
			String filePath = new String();
			ContentAttachs contentAttach = contentAttachsService.getById(attachId);
			filePath = contentAttach.getDocUrl();
			String path = Struts2Util.getServletContext().getRealPath("/");
			File fis = new File(path + filePath + contentAttach.getAttachName());
			if (fis.exists()) {
				InputStream in = new FileInputStream(fis);
				/*****处理花字符*************************/
				String browName=new String();
				String clientInfo = this.getRequest().getHeader("User-agent");
			    if(clientInfo != null && clientInfo.indexOf("MSIE") > 0 ){//IE采用URLEncoder方式处理
			    if(clientInfo.indexOf("MSIE 6") > 0 || clientInfo.indexOf("MSIE 5") > 0){//IE6，用GBK，此处实现由局限性
			      browName = new String(contentAttach.getDocName().getBytes("GBK"),"ISO-8859-1");
			       }else{//ie7+用URLEncoder方式
			     browName = java.net.URLEncoder.encode(contentAttach.getDocName(), "UTF-8");
			     }
			    }
               /*************************************/
				Struts2Util.getResponse()
						.addHeader(
								"Content-Disposition",
								"attachment;filename="
										+ browName);
				OutputStream out = Struts2Util.getResponse().getOutputStream();
				try {
					byte[] buf = new byte[1024];
					int len;
					while ((len = in.read(buf)) != -1) {
						out.write(buf, 0, len);
					}
				} catch (Exception e) {
					e.printStackTrace();
				} finally {
					in.close();
					out.close();
				}
			}

		} catch (Exception e) {
			e.printStackTrace();

		}

	}

	/**
	 * 删除信息,返回json{result:true/false}
	 */
	public String delete() throws Exception{
	    try{
			contentInformationsService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":\"true\"}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":\"false\"}");
		}
		return null;
	}
	/**
	 * 获取文件后缀字符串
	 */
	public String getFileSuffix(String fileName) {
		String filesuffix = null;
		StringTokenizer fx = new StringTokenizer(fileName, ". ");
		while (fx.hasMoreTokens()) {
			filesuffix = fx.nextToken();
		}
		return filesuffix;
	}
	/**
	 * 上传附件
	 */
	public List<UploadFile> uploadFile() {
		try {
			List<UploadFile> uploadFiles = new ArrayList<UploadFile>();
			if (Filedata != null && Filedata.isEmpty() == false) {
				for (int i = 0; i < Filedata.size(); i++) {
					File file = Filedata.get(i);
					UploadFile uploadFile = new UploadFile();
					uploadFile.setFileName(FiledataFileName.get(i));
					uploadFile.setFileType(FiledataContentType.get(i));
					uploadFile.setUploadFile(file);
					String rename = UUID.randomUUID().toString() + "."
							+ getFileSuffix(FiledataFileName.get(i));
					String path = Struts2Util.getServletContext().getRealPath(
							"/");
					uploadFile.setId(rename);
					uploadFile.setFilePath(path
							+ "upload\\"
							+ DateUtil.convertDateToString(
									DateUtil.DATE_FORMAT_YYYYMMDD, new Date())
							+ "\\");
					uploadFile.uploadToServer();
					uploadFiles.add(uploadFile);
				}
			}
			return uploadFiles;
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	/**
	 * 激活被禁用的信息,返回json{result:true/false}
	 * @return
	 */
	public String activeInfo(){
		if(contentInformations!=null && contentInformations.getId()!=null){
			contentInformationsService.activeInfo(contentInformations.getId());
			try{
				getResponse().getWriter().println("{\"result\":\"true\"}");
			}catch(Exception e){
			}
		}else{
			BasalException ex = new BasalException(BasalException.NO, Constants.INFORMATION_NULL_EXCEPIION);
			try{
				getResponse().getWriter().println("{\"result\":\"false\"}");
			}catch(Exception e){
			}
			throw ex;
		}
		return null;
	}
	
	/**
	 * 禁用信息,返回json{result:true/false}
	 * @return
	 */
	public String inactiveInfo(){
		if(contentInformations!=null && contentInformations.getId()!=null){
			contentInformationsService.inactiveInfo(contentInformations.getId());
			try{
				getResponse().getWriter().println("{\"result\":\"true\"}");
			}catch(Exception e){
			}
		}else{
			BasalException ex = new BasalException(BasalException.NO, Constants.INFORMATION_NULL_EXCEPIION);
			try{
				getResponse().getWriter().println("{\"result\":\"false\"}");
			}catch(Exception e){
			}
			throw ex;
		}
		return null;
	}
	
	/**
	 * 设置信息过期,返回json{result:true/false}
	 * @return
	 */
	public String expireInfo(){
		if(contentInformations!=null && contentInformations.getId()!=null){
			contentInformationsService.expireInfo(contentInformations.getId());
			try{
				getResponse().getWriter().println("{\"result\":\"true\"}");
			}catch(Exception e){
			}
		}else{
			BasalException ex = new BasalException(BasalException.NO, Constants.INFORMATION_NULL_EXCEPIION);
			try{
				getResponse().getWriter().println("{\"result\":\"false\"}");
			}catch(Exception e){
			}
			throw ex;
		}
		return null;
	}
	
	/**
	 * 设置信息使用,返回json{result:true/false}
	 * @return
	 */
	public String inexpireInfo(){
		if(contentInformations!=null && contentInformations.getId()!=null){
			contentInformationsService.inexpireInfo(contentInformations.getId());
			try{
				getResponse().getWriter().println("{\"result\":\"true\"}");
			}catch(Exception e){
			}
		}else{
			BasalException ex = new BasalException(BasalException.NO, Constants.INFORMATION_NULL_EXCEPIION);
			try{
				getResponse().getWriter().println("{\"result\":\"false\"}");
			}catch(Exception e){
			}
			throw ex;
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public ContentInformations getContentInformations(){
		return this.contentInformations;
	}

	public void setContentInformations(ContentInformations contentInformations){
		this.contentInformations = contentInformations;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }
       
    
	public Date getQueryPublicDateStart(){
		return this.queryPublicDateStart;
	}

	public void setQueryPublicDateStart(Date queryPublicDateStart){
		this.queryPublicDateStart = queryPublicDateStart;
	}

	public Date getQueryPublicDateEnd(){
		return this.queryPublicDateEnd;
	}

	public void setQueryPublicDateEnd(Date queryPublicDateEnd){
		this.queryPublicDateEnd = queryPublicDateEnd;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public String getIsDelshow() {
		return isDelshow;
	}

	public void setIsDelshow(String isDelshow) {
		this.isDelshow = isDelshow;
	}

	public String getIsExpireshow() {
		return isExpireshow;
	}

	public void setIsExpireshow(String isExpireshow) {
		this.isExpireshow = isExpireshow;
	}

	public List<File> getUpload() {
		return upload;
	}

	public void setUpload(List<File> upload) {
		this.upload = upload;
	}

	public List<String> getUploadFileName() {
		return uploadFileName;
	}

	public void setUploadFileName(List<String> uploadFileName) {
		this.uploadFileName = uploadFileName;
	}

	public List<String> getUploadContentType() {
		return uploadContentType;
	}

	public void setUploadContentType(List<String> uploadContentType) {
		this.uploadContentType = uploadContentType;
	}

	public List<String> getAttachType() {
		return attachType;
	}

	public void setAttachType(List<String> attachType) {
		this.attachType = attachType;
	}

	public String getAttachId() {
		return attachId;
	}

	public void setAttachId(String attachId) {
		this.attachId = attachId;
	}

	public int getAttachCount() {
		return attachCount;
	}

	public void setAttachCount(int attachCount) {
		this.attachCount = attachCount;
	}

}
