package com.jshx.extend.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import com.jshx.core.base.entity.BaseModel;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.extend.IUserExtendInfo;
/**
 * 用户扩展信息测试
 * 
 * @author Chenjian
 *
 */
@Entity
@Table(name = "USER_EXTEND")
public class UserExtend extends BaseModel implements IUserExtendInfo {
	
	private static final long serialVersionUID = 5737231920164524410L;

	private User user;
	
	private String userId;
	
	private String info;

	@Override
	@OneToOne(targetEntity = User.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "USER_ID", insertable = false, updatable = false)
	public User getUser() {
		return user;
	}

	@Override
	public void setUserId(String userId) {
		this.userId = userId;
	}

	@Column(name = "USER_ID", length = 40)
	public String getUserId() {
		return userId;
	}

	public void setUser(User user) {
		this.user = user;
	}

	@Column(name = "INFO", length = 200)
	public String getInfo() {
		return info;
	}

	public void setInfo(String info) {
		this.info = info;
	}

}
