package com.jshx.extend.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.jshx.core.base.entity.BaseModel;
import com.jshx.module.admin.entity.Module;
import com.jshx.module.admin.extend.IModuleExtendInfo;
/**
 * 模块扩展信息
 * 
 * @author Chenjian
 *
 */
@Entity
@Table(name = "MODULE_EXTEND")
public class ModuleExtend extends BaseModel implements IModuleExtendInfo {
	
	private static final long serialVersionUID = 5824722175074746214L;
	
	private String moduleId;
	
	private Module module;
	
	private String info;

	@Override
	public void setModule(Module module) {
		this.module = module;
	}

	@Override
	public void setModuleId(String moduleId) {
		this.moduleId = moduleId;
	}

	@Column(name = "INFO", length = 100)
	public String getInfo() {
		return info;
	}

	public void setInfo(String info) {
		this.info = info;
	}

	@Column(name = "MODULE_ID", length = 40)
	public String getModuleId() {
		return moduleId;
	}

	@ManyToOne(targetEntity = Module.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "MODULE_ID", insertable = false, updatable = false)
	public Module getModule() {
		return module;
	}

}
