package com.jshx.extend.dao.impl;

import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.extend.entity.CodeValueExtend;
import com.jshx.module.admin.extend.ICodeValueExtendInfo;
import com.jshx.module.admin.extend.ICodeValueExtendInfoDao;

/**
 * 一维代码扩展信息DAO
 * 
 * @author Chenjian
 *
 */
@Component("codeValueExtendDao")
public class CodeValueExtendDao extends BaseDaoImpl implements ICodeValueExtendInfoDao {

	@Override
	public ICodeValueExtendInfo getByCodeValueId(String codeValueId) {
		return (ICodeValueExtendInfo)this.getObjectByProperty(CodeValueExtend.class, "codeValueId", codeValueId);
	}

	@Override
	public ICodeValueExtendInfo saveCodeValueExtendInfo(
			ICodeValueExtendInfo codeValueExtendInfo) {
		this.saveObject(codeValueExtendInfo);
		return codeValueExtendInfo;
	}

	@Override
	public ICodeValueExtendInfo updateCodeValueExtendInfo(
			ICodeValueExtendInfo codeValueExtendInfo) {
		this.updateObject(codeValueExtendInfo);
		return codeValueExtendInfo;
	}


}
