/**
 * 
 */
package com.jshx.activiti.web;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Autowired;

import com.jshx.activiti.entity.ProcessInstanceStat;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.utils.JsonMapper;

/**
 * @author ian
 *
 * @date 2016年6月23日
 */
public class ProcessStatAction extends BaseAction {
	
	private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

	@Autowired
	protected RepositoryService repositoryService;

	@Autowired
	protected RuntimeService runtimeService;

	@Autowired
	protected TaskService taskService;

	@Autowired
	protected FormService formService;

	@Autowired
	protected IdentityService identityService;

	@Autowired
	private HistoryService historyService;

	private List<ProcessDefinition> piDefList;

	private JsonMapper jsonMapper = new JsonMapper();

	private String processDefinitionId;

	private Date startDate;

	private Date endDate;

	public String piStatIndex() {
		piDefList = repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionKey().asc().list();
		return SUCCESS;
	}

	/**
	 * 统计流程实例运行情况
	 * 
	 * @throws IOException
	 */
	@SuppressWarnings("deprecation")
	public void queryPiStatus() throws IOException {

		int daysBetween = (int) ((endDate.getTime() / 86400000L) - (startDate.getTime() / 86400000L));

		List<ProcessInstanceStat> piStatList = new ArrayList<ProcessInstanceStat>();
		
		ProcessDefinition pd = repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId)
				.singleResult();
		
		HistoricProcessInstanceQuery query = historyService.createHistoricProcessInstanceQuery()
				.processDefinitionId(processDefinitionId);

		Date date = (Date) startDate.clone();
		for (int i=0; i<=daysBetween; i++){
			ProcessInstanceStat piStat = new ProcessInstanceStat();
			Date sDate = (Date) date.clone();

			
			Date eDate = (Date) date.clone();;
			eDate.setHours(23);
			eDate.setMinutes(59);
			eDate.setSeconds(59);
			
			piStat.setStatDate(sdf.format(date));
			piStat.setProcessName(pd.getName());
			
			
			int completeCount = query.finished().finishedBefore(eDate).finishedAfter(sDate).list().size();
			
			piStat.setCompleteCount(completeCount);
			piStatList.add(piStat);
			date.setDate(date.getDate()+1);
		}
	

		String json = jsonMapper.toJson(piStatList);

		this.getResponse().getWriter().print(json);
	}

	/**
	 * @return the piDefList
	 */
	public List<ProcessDefinition> getPiDefList() {
		return piDefList;
	}

	/**
	 * @param piDefList the piDefList to set
	 */
	public void setPiDefList(List<ProcessDefinition> piDefList) {
		this.piDefList = piDefList;
	}

	/**
	 * @return the processDefinitionId
	 */
	public String getProcessDefinitionId() {
		return processDefinitionId;
	}

	/**
	 * @param processDefinitionId the processDefinitionId to set
	 */
	public void setProcessDefinitionId(String processDefinitionId) {
		this.processDefinitionId = processDefinitionId;
	}

	/**
	 * @return the startDate
	 */
	public Date getStartDate() {
		return startDate;
	}

	/**
	 * @param startDate the startDate to set
	 */
	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	/**
	 * @return the endDate
	 */
	public Date getEndDate() {
		return endDate;
	}

	/**
	 * @param endDate the endDate to set
	 */
	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}
	
	

}
