/**
 * Copyright 2013 hongxin
 * Change Revision
 * ---------------------------------------------------------------
 * Date               Author            Remarks
 * 2013-5-10          YuWeitao          create
 * ---------------------------------------------------------------
 */
package com.jshx.activiti.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jshx.activiti.service.ActivitiOperLogService;
import com.jshx.activiti.service.ActivitiService;
import com.jshx.activiti.service.CompensationService;
import com.jshx.activiti.util.ActivitiVarConstants;
import com.jshx.cktzs.entity.Cktzs;
import com.jshx.cktzs.service.CktzsService;
import com.jshx.common.utils.Constant;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.exception.BasalException;
import com.jshx.core.utils.SpringContextHolder;
import com.jshx.core.utils.StringUtil;
import com.jshx.dxpz.entity.Dxpz;
import com.jshx.dxpz.service.DxpzService;
import com.jshx.jkmx.entity.Jkmx;
import com.jshx.jkmx.service.JkmxService;
import com.jshx.jktzs.entity.Jktzs;
import com.jshx.jktzs.service.JktzsService;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.entity.UserLinkedDept;
import com.jshx.module.admin.entity.UserRight;
import com.jshx.module.admin.service.DeptService;
import com.jshx.module.admin.service.UserLinkedDeptService;
import com.jshx.module.admin.service.UserService;
import com.jshx.module.admin.web.action.CommonAction;
import com.jshx.paymentItemPending.entity.PaymentItemPending;
import com.jshx.paymentItemPending.service.PaymentItemPendingService;
import com.jshx.qtfymx.entity.Qtfymx;
import com.jshx.qtfymx.service.QtfymxService;
import com.jshx.returnItem.entity.ReturnItem;
import com.jshx.returnItem.service.ReturnItemService;
import com.jshx.spjlb.entity.Spjlb;
import com.jshx.spjlb.service.SpjlbService;
import com.jshx.wwjdclinfo.entity.Wwjdclinfo;
import com.jshx.xmdrb.service.GenericManager;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.service.ZsdwService;
import com.opensymphony.xwork2.ActionContext;

import net.sf.json.JSON;
import net.sf.json.JSONArray;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.UserTask;
import org.activiti.editor.constants.ModelDataJsonConstants;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.activiti.engine.*;
import org.activiti.engine.form.FormProperty;
import org.activiti.engine.form.StartFormData;
import org.activiti.engine.form.TaskFormData;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.repository.*;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.persistence.Column;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import java.io.*;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.zip.ZipInputStream;
import java.util.Comparator;  


/**
 * Activiti工作流控制流转通用类
 *
 * @author YuWeitao
 * @version 创建时间：2013-5-10 上午11:21:00
 */
public class ActivitiControllerAction extends BaseAction {
    private static final long serialVersionUID = -7400720794719784874L;

    protected static final String ERROR_RESULT = "{\"result\":false}";

    protected static final String SUCCESS_RESULT = "{\"result\":true}";

    protected static final String BPMN_SUFFIX = ".bpmn20.xml";

    protected static final String ID = "id";

    protected static final String NAME = "name";

    protected static final String VALUE = "value";

    protected static final String CANDIDATE_USERS = "candidateUsers";

    protected static final String CANDIDATE_GROUPS = "candidateGroups";

    protected static final String CREATED_TIME = "createTime";

    protected static final String EMPTY_RESULT = "{\"rows\":[], \"total\":0}";

    protected static final String DESC = "description";

    private static final Logger activitiLogger = LoggerFactory.getLogger(ActivitiControllerAction.class);

    private SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm");

    private SimpleDateFormat outSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    
	@Autowired
	private DxpzService dxpzService;
    @Autowired
    protected RepositoryService repositoryService;

    @Autowired
    protected RuntimeService runtimeService;

    @Autowired
    protected TaskService taskService;

    @Autowired
    protected FormService formService;

    @Autowired
    protected IdentityService identityService;

    @Autowired
    private HistoryService historyService;

    private String tuijianren;
    private String tuijianyuanyin;

    @Autowired
    private ActivitiService activitiService;
    @Autowired
	private SpjlbService spjlbService;
    @Autowired
	private QtfymxService qtfymxService;
    @Autowired
		private PaymentItemPendingService paymentItemPendingService;
	    @Autowired
		private CktzsService cktzsService;
	    @Autowired
		private JktzsService jktzsService;
	    @Autowired
		private ZsdwService zsdwService;
	    @Autowired
		private JkmxService jkmxService;

    //**********@yangshunqing**********//
    @Autowired()
    @Qualifier("deptService")
    private DeptService deptService;

    @Autowired()
    @Qualifier("userLinkedDeptService")
    private UserLinkedDeptService userLinkedDeptService;
    
    @Autowired()
    private XmxxbService xmxxbService;
    
    @Autowired()
    private ReturnItemService returnItemService;
    

    private String selDept;

    private Department dept;

    private List<Department> deptList;
    
    private Xmxxb xmxxb = new Xmxxb();
    
    private ReturnItem returnItem = new ReturnItem();

    @Autowired()
    @Qualifier("userService")
    private UserService userService;

    @Autowired()
    private ActivitiOperLogService activitiOperLogService;
    
    @Autowired()
    private GenericManager genericManager;

    private String Assignee;

    private String taskName;
    //**********@yangshunqing**********//

    private String asignee;

    private Pagination pagination;

    private File file;

    private String fileFileName;

    private String taskId;
    
    private String taskIds;

	private String processDefinitionId;

    private String modelName;

    private String modelKey;

    private String modelDesc;

    private String processDefKey;

    private String processDefName;

    private String[] ids;

    private String modelId;

    private String businessEntityClassName;

    private String businessEntityPrefix;

    private Map<String, String> formMap;

    private String userId;

    private Boolean isSaved;

    private String processInstanceId;

    private String taskDefKey;

    private List<String> keyList = new ArrayList<String>();

    //批注
    private String comment;
    private Date  startDate;

    private Date endDate;

    private String xmbzj;

	private String outcome;
	
	/**
	 * 退件类型
	 */
	private String type;
	
	/**
	 * 退件原因
	 */
	private String reason;
	
	/**
	 * 申请人
	 */
	private String applyUserName;
	
	/**
     * Activiti流程定义列表
     *
     * @return
     * @author YuWeitao
     */
    public void findProcessDefList() throws IOException {
        try {
            pagination = new Pagination(super.getRequest());
            ProcessDefinitionQuery processDefinitionQuery = repositoryService.createProcessDefinitionQuery().orderByDeploymentId().desc();
            if (null != this.processDefKey && !"".equalsIgnoreCase(this.processDefKey) && !"---ALL---".equalsIgnoreCase(this.processDefKey)) {
                processDefinitionQuery = processDefinitionQuery.processDefinitionKeyLike("%" + this.processDefKey + "%");
            }
            if (null != this.processDefName && !"".equalsIgnoreCase(this.processDefName)) {
                processDefinitionQuery = processDefinitionQuery.processDefinitionNameLike("%" + this.processDefName + "%");
            }
            List<ProcessDefinition> processDefList = processDefinitionQuery.listPage(pagination.getFirstResult(), pagination.getPageSize());

            List<HashMap<String, Object>> mapList = new ArrayList<>();
            for (ProcessDefinition processDefinition : processDefList) {
                HashMap<String, Object> map = new HashMap<>();
                //根据部署编号倒序排列
                Deployment deployment = repositoryService.createDeploymentQuery().deploymentId(processDefinition.getDeploymentId()).singleResult();
                map.put(ID, processDefinition.getId());
                map.put("deploymentId", processDefinition.getDeploymentId());
                map.put("deploymentTime", deployment.getDeploymentTime());
                map.put("key", processDefinition.getKey());
                map.put(NAME, processDefinition.getName());
                map.put("category", processDefinition.getCategory());
                map.put("resourceName", processDefinition.getResourceName());
                map.put("version", processDefinition.getVersion());
                map.put(DESC, processDefinition.getDescription());
                map.put("hasStartFormKey", processDefinition.hasStartFormKey());
                map.put("isSuspended", processDefinition.isSuspended());
                map.put("diagramResourceName", processDefinition.getDiagramResourceName());

                mapList.add(map);
            }

            StringBuilder data = new StringBuilder("{");
            data.append(TOTAL).append(processDefinitionQuery.count()).append(",");
            data.append(ROWS);

            JSONArray json = JSONArray.fromObject(mapList);
            data.append(json.toString());
            data.append("}");

            this.getResponse().getWriter().println(data);
        } catch (Exception e) {
            activitiLogger.error("查询流程定义列表错误", e);

            this.getResponse().getWriter().println(EMPTY_RESULT);
        }
    }

    /**
     * Activiti流程定义部署
     *
     * @return
     * @author YuWeitao
     */
    public String deploy() throws IOException {
        FileInputStream fileInputStream = new FileInputStream(this.file);
        String extension = FilenameUtils.getExtension(this.fileFileName);
        if ("zip".equals(extension) || "bar".equals(extension)) {
            ZipInputStream zip = new ZipInputStream(fileInputStream);
            repositoryService.createDeployment().addZipInputStream(zip).deploy();
        } else {
            try {
                repositoryService.createDeployment().addInputStream(this.fileFileName, fileInputStream).deploy();
            } catch (Exception PackageTooBigException) {
                this.getRequest().setAttribute("message", "文件太大，请核实部署文件的有效性！");
            }
        }

        return RELOAD;
    }

    /**
     * 删除已部署的流程，级联删除流程实例
     *
     * @author YuWeitao
     */
    public void deleteProcessDef() throws IOException {
        if (null != ids) {
            for (String deploymentId : ids)
                //Deletes the given deployment and cascade deletion to process instances, history process instances and jobs.
                repositoryService.deleteDeployment(deploymentId, true);
            getResponse().getWriter().println(SUCCESS_RESULT);
        } else {
            getResponse().getWriter().println(ERROR_RESULT);
        }
    }

    /**
     * 挂起流程；被挂起的流程不能再创建流程实例
     *
     * @throws IOException
     * @author YuWeitao
     */
    public void suspendProcessDefinition() throws IOException {
        try {
            repositoryService.suspendProcessDefinitionById(this.processDefinitionId, false, null);
            this.getResponse().getWriter().println(SUCCESS_RESULT);
        } catch (Exception e) {
            activitiLogger.error("Suspend Process Error", e);
            this.getResponse().getWriter().println(ERROR_RESULT);
        }
    }

    /**
     * 激活流程
     *
     * @throws IOException
     * @author YuWeitao
     */
    public void activateProcessDefinition() throws IOException {
        try {
            repositoryService.activateProcessDefinitionById(this.processDefinitionId, false, null);
            this.getResponse().getWriter().println(SUCCESS_RESULT);
        } catch (Exception e) {
            this.getResponse().getWriter().println(ERROR_RESULT);
            activitiLogger.error("activate process error", e);
        }
    }

    /**
     * 待签收任务列表
     *
     * @return
     * @author YuWeitao
     */
    public void findToClaimTaskList() throws IOException {
        try {
            // 综合用户ID\角色\角色部门组合等
            List<String> groups = new ArrayList<>();
            User loginUser = this.getLoginUser();
            List<UserRight> roles = (List<UserRight>) loginUser.getUserRoles();
            if (roles != null) {
                for (UserRight role : roles) {
                    groups.add(role.getRole().getRoleName());
                    groups.add(loginUser.getDeptCode() + "|" + role.getRole().getRoleName());
                }
            }
            pagination = new Pagination(super.getRequest());
            TaskQuery taskToClaimQuery = taskService.createTaskQuery().taskCandidateUser(getLoginUser().getLoginId());
            if (!groups.isEmpty())
                taskToClaimQuery.taskCandidateGroupIn(groups);

            taskToClaimQuery.active().orderByTaskId().desc();
            List<Task> taskListToClaim = taskToClaimQuery.listPage(pagination.getFirstResult(), pagination.getPageSize());

            List<HashMap<String, Object>> mapList = new ArrayList<>();
            for (Task task : taskListToClaim) {
                HashMap<String, Object> map = new HashMap<>();
                map.put(ID, task.getId());
                map.put(NAME, task.getName());
                map.put(CREATED_TIME, task.getCreateTime());
                map.put(DESC, task.getDescription());
                map.put("dueDate", task.getDueDate());
                map.put("owner", task.getOwner());

                mapList.add(map);
            }

            StringBuilder data = new StringBuilder("{");
            data.append(TOTAL).append(taskToClaimQuery.count()).append(",");
            data.append(ROWS);

            JSONArray json = JSONArray.fromObject(mapList);
            data.append(json.toString());
            data.append("}");

            this.getResponse().getWriter().println(data);
        } catch (Exception e) {
            activitiLogger.error("get todo task error", e);

            this.getResponse().getWriter().println(EMPTY_RESULT);
        }
    }

    /**
     * 签收任务
     *
     * @throws IOException
     * @author YuWeitao
     */
    public void claimTask() throws IOException {
        Task task = taskService.createTaskQuery().taskId(this.taskId).singleResult();
        if (null != task) {
            if (StringUtils.isEmpty(task.getAssignee()))
                taskService.claim(task.getId(), this.getLoginUser().getLoginId());
            TaskFormData tfd = formService.getTaskFormData(taskId);
            Map<String, Object> map = new HashMap<>();
            if (tfd != null) {
                List<FormProperty> formProperties = tfd.getFormProperties();
                List<Map<String, Object>> properties = new ArrayList<>();

                activitiService.getFormProperties(formProperties, properties);
                map.put("tfd", properties);
            }
            map.put("taskName", task.getName());
            map.put("taskId", taskId);
            map.put("processInstanceId", task.getProcessInstanceId());
            ProcessInstance pi = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            String businessKey = pi.getBusinessKey();
            map.put("businessKey", businessKey);

            UserTask userTask = (UserTask) repositoryService.getBpmnModel(task.getProcessDefinitionId()).getFlowElement(task.getTaskDefinitionKey());
            String taskDealUrl = userTask.getTargetUrl();
            if (StringUtils.isNotEmpty(taskDealUrl))
                map.put(ActivitiVarConstants.TASK_HANDLER_URL, taskDealUrl);

            Boolean allowedBack = userTask.getAllowedBack();
            if (allowedBack == null)
                allowedBack = false;
            Boolean allowedWithdrawal = userTask.getAllowedWithdrawal();
            if (allowedWithdrawal == null)
                allowedWithdrawal = false;

            map.put(ActivitiVarConstants.TASK_ALLOWED_BACK, allowedBack);
            map.put(ActivitiVarConstants.TASK_ALLOWED_WITHDRAWAL, allowedWithdrawal);

            // 获取下一步任务信息
            Map<String, FlowNode> nextNodeMap = activitiService.findNextTask(taskId);
            if (nextNodeMap != null && !nextNodeMap.isEmpty()) {
                List<Map<String, Object>> nextSteps = new ArrayList<>();

                activitiService.findNextStep(task, nextNodeMap, nextSteps);
                map.put("nextSteps", nextSteps);
            }
            map.put("result", true);
            
            //签收后重新计算dueDate
            String dueDateString = activitiService.findDueDateExpression(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
		    if(null != dueDateString && !dueDateString.isEmpty() && dueDateString.startsWith("P")){
		    	try {
		    		DateTime claimDate = new DateTime();
					taskService.setDueDate(taskId, claimDate.plus(Period.parse(dueDateString)).toDate());
				} catch (Exception e) {
					// TODO: handle exception
				}
		    }
		    
            this.outputJson(null, map);
        } else {
            this.getResponse().getWriter().println(ERROR_RESULT);
        }
    }
    
    /**
     * 批量签收
     * @throws IOException
     */
    public void claimTaskBat() throws IOException {
    	
    	
	    try{
	      	String[] idArray = taskIds.split("\\|");
			if(null != idArray)
			{
				for(String taskId : idArray)
				{
				    if(taskId!=null && !taskId.trim().equals(""))
				    {
				    	Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
				        if (null != task) {
				            if (StringUtils.isEmpty(task.getAssignee()))
				                taskService.claim(task.getId(), this.getLoginUser().getLoginId());
				        }
				    }
				}
			}
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
    	
  
		
    }


    /**
     * 办理任务
     */
    public void doTask() throws IOException {
        try {
            if (formMap != null)
                formService.saveFormData(taskId, formMap);

            Task task = taskService.createTaskQuery().taskId(this.taskId).singleResult();
            if (StringUtils.isNotEmpty(asignee))
                activitiService.changeAssignee(task, asignee);
            if (!isSaved) {

                //完成任务的同时，设置流程变量，让流程变量判断排他网关该如何执行
                Map<String, Object> variables = new HashMap<>();

                if (formMap != null) {
                    Iterator<String> keys = formMap.keySet().iterator();
                    while (keys.hasNext()) {
                        String key = keys.next();
                        variables.put(key, formMap.get(key));
                    }
                }

                taskService.complete(taskId, variables);

                //插入操作日志
                activitiOperLogService.saveLog(this.getLoginUser().getLoginId(), "办理",taskId,
                         task.getName(),task.getProcessInstanceId(),"");



            }
            this.getResponse().getWriter().println(SUCCESS_RESULT);
        } catch (Exception e) {
            activitiLogger.error("finish task error", e);
            this.getResponse().getWriter().println(ERROR_RESULT);
        }
    }

    /**
     * 移交任务
     *
     * @throws IOException
     */
    public void delegate() throws IOException {
        try {
        	Task task = taskService.createTaskQuery().taskId(this.taskId).singleResult();
            taskService.setAssignee(taskId, userId);
            //当改签时，重新计算duedate
            String dueDateString = activitiService.findDueDateExpression(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
		    if(null != dueDateString && !dueDateString.isEmpty() && dueDateString.startsWith("P")){
		    	try {
		    		DateTime delegateDate = new DateTime();
					taskService.setDueDate(taskId, delegateDate.plus(Period.parse(dueDateString)).toDate());
				} catch (Exception e) {
					// TODO: handle exception
				}
		    }
		    activitiOperLogService.saveLog(userId, "TASK_REASSIGNED", taskId, taskName, task.getProcessInstanceId(), "");                      
            
            this.getResponse().getWriter().println(SUCCESS_RESULT);
        } catch (Exception e) {
            activitiLogger.error("finish task error", e);
            this.getResponse().getWriter().println(ERROR_RESULT);
        }
    }

    /**
     * 办理中任务列表
     *
     * @return
     * @author YuWeitao
     */
    public void findClaimedTaskList() throws IOException {
        try {

            // 综合用户ID\角色\角色部门组合等
            List<String> groups = new ArrayList<>();
            User loginUser = this.getLoginUser();
            List<UserRight> roles = (List<UserRight>) loginUser.getUserRoles();
            if (roles != null) {
                for (UserRight role : roles) {
                    groups.add(role.getRole().getRoleName());
                    groups.add(loginUser.getDeptCode() + "|" + role.getRole().getRoleName());
                }
            }

            pagination = new Pagination(super.getRequest());
            TaskQuery claimedTaskQuery = taskService.createTaskQuery().taskCandidateOrAssigned(getLoginUser().getLoginId());
            if(null != processDefName && !"".equals(processDefName.trim())){
            	claimedTaskQuery = claimedTaskQuery.processDefinitionNameLike("%"+this.processDefName+"%");
            }
            
            if (!groups.isEmpty())
                claimedTaskQuery.taskCandidateGroupIn(groups);

            claimedTaskQuery.active().orderByTaskId().desc();
            List<Task> claimedTaskList = claimedTaskQuery.listPage(pagination.getFirstResult(), pagination.getPageSize());
                    
            for(Task task:claimedTaskList){
            	//未签收的任务
            	if(null==task.getAssignee()){
            		//所有任务候选人
            		List<User> userList = activitiService.getCandidate(task.getId());
            		//自动签收
            		//activitiService.autoClaim(userList,task);
            	}
            }
            //刷新任务列表
            claimedTaskList = claimedTaskQuery.listPage(pagination.getFirstResult(), pagination.getPageSize());
            
            List<HashMap<String, Object>> mapList = new ArrayList<>();
            List<HashMap<String, Object>> mapListyr = new ArrayList<>();
            List<HashMap<String, Object>> mapListwr = new ArrayList<>();
            for (Task task : claimedTaskList) {
                HashMap<String, Object> map = new HashMap<>();
                //划分部门区别
                //HistoricTaskInstance historicTaskInstance = historyService.createHistoricTaskInstanceQuery().taskId("step1").singleResult();
                Date claimTime = historyService.createHistoricTaskInstanceQuery().taskId(task.getId()).singleResult().getClaimTime();
                String businesskey = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult().getBusinessKey();
                if(null!=businesskey){
                	Xmxxb xmxxb = xmxxbService.getById(businesskey);
                	 if(null!=xmxxb){
                     	 map.put("projectName", xmxxb.getXmmc());
                     	 map.put("slbh", xmxxb.getSlbh());
                     	 map.put("jsdwmc", xmxxb.getJsdw());
//                     	 map.put("gcxmmc",xmxxb.getXmmc());
                     	 
                     }else{
                     	 map.put("projectName", "");
                     	 map.put("slbh", "");
                     	map.put("jsdwmc", "");
//                    	 map.put("gcxmmc","");
                     }
                	 ReturnItem returnItem = returnItemService.getByXmbzjAndProcessInsId(businesskey, task.getProcessInstanceId());
                     if(null != returnItem){
                    	map.put("returnStatus", returnItem.getReturnStatus());
                     }
                }else{
                 	map.put("projectName", "");
                 	map.put("slbh", "");
                }
                map.put("processInstanceId", task.getProcessInstanceId());
                map.put(ID, task.getId());
                map.put("executionId", task.getExecutionId());
                map.put(NAME, task.getName());
                map.put("procDefName", repositoryService.createProcessDefinitionQuery().processDefinitionId(task.getProcessDefinitionId()).singleResult().getName());
                map.put("businessKey", businesskey);
//                map.put("businessKey", null);
//                map.put(CREATED_TIME, task.getCreateTime());
                map.put(CREATED_TIME, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(task.getCreateTime()));
                List<Comment> commentList = taskService.getProcessInstanceComments(task.getProcessInstanceId());
                String syjfqr="";
                if(null!=commentList&&commentList.size()>0){
                	User uu=userService.findUserByLoginId(commentList.get(0).getUserId());
                	   if(null!=uu){
                		   syjfqr=uu.getDisplayName() ;
                       }else{
                    	   syjfqr= commentList.get(0).getUserId();
                       }
                }
                map.put("syjfqr", syjfqr);
//                map.put("claimTime", claimTime);
                if(null!=claimTime){
                	map.put("claimTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(claimTime));
                }else{
                	map.put("claimTime", "");
                }
                map.put("description", task.getDescription());
                map.put("dueDate", task.getDueDate());
                map.put("owner", task.getOwner());
                map.put("assignee", task.getAssignee());
                if(null!=task.getAssignee()&&!"".equals(task.getAssignee())){
                	mapListyr.add(map);
                }else{
                	mapListwr.add(map);
                }
            }
            if(mapListyr.size()>0){
//            	for (int i = mapListyr.size()-1; i >=0; i--) {
//            		mapList.add(mapListyr.get(i));
//				}
            	Collections.sort(mapListyr, new Comparator<Map<String, Object>>(){ 
            		public int compare(Map<String, Object> o1, Map<String, Object> o2) {
            			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");  
            			   Date date1;
            			   Date date2;
            			   int flag=0;
						try {
							date1 = sdf.parse((String)o1.get("claimTime"));
							date2= sdf.parse((String)o2.get("claimTime"));  
							flag=  date1.compareTo(date2);
						} catch (ParseException e) {
							e.printStackTrace();
						}  
            			return flag;
            		}  
            	});
            	for (HashMap<String, Object> hashMapyr : mapListyr) {
            		mapList.add(hashMapyr);
            	}
            }
            if(mapListwr.size()>0){
            	for (HashMap<String, Object> hashMapwr : mapListwr) {
            		mapList.add(hashMapwr);
            	}
            }

            StringBuilder data = new StringBuilder("{");
            data.append(TOTAL).append(claimedTaskQuery.count()).append(",");
            data.append(ROWS);

            JSONArray json = JSONArray.fromObject(mapList);
            data.append(json.toString());
            data.append("}");

            this.getResponse().getWriter().println(data);
        } catch (Exception e) {
            activitiLogger.error("get doing tasks error", e);
            this.getResponse().getWriter().println(EMPTY_RESULT);
        }
    }
    
    /**
     * 查询未办结流程
     *
     * @throws IOException
     * @author ian
     */
    public void findRunningProcessInstances() throws IOException {
        pagination = new Pagination(super.getRequest());

        HistoricProcessInstanceQuery query = historyService.createHistoricProcessInstanceQuery();

        List<UserRight> userRights = (List<UserRight>) this.getLoginUser().getUserRoles();


        Boolean flag = false;
        for (UserRight ur : userRights) {
            if (ur.getRole().getRoleName().equals("系统管理员")) {
                flag = true;
                break;
            }
        }

        if (!flag)
            query.startedBy(this.getLoginUser().getLoginId());

        query.orderByProcessInstanceStartTime().desc();
        
        List<HistoricProcessInstance> historicProcessInstances = new ArrayList<HistoricProcessInstance>();
        if(null!=processInstanceId && !"".equals(processInstanceId.trim())){
        	historicProcessInstances = query.startedAfter(startDate).startedBefore(endDate).processInstanceId(processInstanceId)
                    .listPage(pagination.getFirstResult(), pagination.getPageSize());
        }else{
        	historicProcessInstances = query.startedAfter(startDate).startedBefore(endDate)
                    .listPage(pagination.getFirstResult(), pagination.getPageSize());
        }
        

        List<HashMap<String, Object>> mapList = new ArrayList<>();
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {

            String processDefinitionId = historicProcessInstance.getProcessDefinitionId();

            ProcessDefinition procDefinition = repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();

            HashMap<String, Object> map = new HashMap<>();
            map.put("id", historicProcessInstance.getId());
            map.put("name", procDefinition.getName());
            map.put("businessKey", historicProcessInstance.getBusinessKey());
            map.put("proDefId", historicProcessInstance.getProcessDefinitionId());
            map.put("createTime", historicProcessInstance.getStartTime());
            map.put("status", null == historicProcessInstance.getEndTime() ? "运行中" : "已结束");
            mapList.add(map);
        }

        StringBuilder data = new StringBuilder("{");
        data.append(TOTAL).append(query.count()).append(",");
        data.append(ROWS);

        JSONArray json = JSONArray.fromObject(mapList);
        data.append(json.toString());
        data.append("}");

        this.getResponse().getWriter().println(data);
    }
    
    /**
     * 查询未办结的征收流程
     * @throws IOException
     */
    public void findRunningProcessForZslc() throws IOException {
        pagination = new Pagination(super.getRequest());

        HistoricProcessInstanceQuery query = historyService.createHistoricProcessInstanceQuery();

        query.orderByProcessInstanceStartTime().desc();
        //征收流程
        query.processDefinitionKey(Constant.PROCESS_ZSLC);
        query.unfinished();
        List<HistoricProcessInstance> historicProcessInstances = new ArrayList<HistoricProcessInstance>();
        if(null!=processInstanceId && !"".equals(processInstanceId.trim())){
        	historicProcessInstances = query.startedAfter(startDate).startedBefore(endDate).processInstanceId(processInstanceId)
                    .listPage(pagination.getFirstResult(), 300);
        }else{
        	historicProcessInstances = query.startedAfter(startDate).startedBefore(endDate)
                    .listPage(pagination.getFirstResult(), 300);
        }
//        if(null!=processInstanceId && !"".equals(processInstanceId.trim())){
//        	historicProcessInstances = query.startedAfter(startDate).startedBefore(endDate).processInstanceId(processInstanceId)
//        			.listPage(pagination.getFirstResult(), pagination.getPageSize());
//        }else{
//        	historicProcessInstances = query.startedAfter(startDate).startedBefore(endDate)
//        			.listPage(pagination.getFirstResult(), pagination.getPageSize());
//        }
        

        List<HashMap<String, Object>> mapList = new ArrayList<>();
        String dwdm="";
        if(!this.getLoginUser().getIsSuperAdmin()){
        	dwdm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
        }
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {

            String processDefinitionId = historicProcessInstance.getProcessDefinitionId();
            
            ProcessDefinition procDefinition = repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
            
            
            HashMap<String, Object> map = new HashMap<>();
            map.put("id", historicProcessInstance.getId());
            map.put("name", procDefinition.getName());
            String businesskey = historicProcessInstance.getBusinessKey();
            
            if(null!=businesskey){
            	Xmxxb xmxxb = xmxxbService.getById(businesskey);
            	 if(null!=xmxxb){
                 	map.put("projectName", xmxxb.getXmmc());
                 	map.put("jsdw", xmxxb.getJsdw());
                 	map.put("slbh", xmxxb.getSlbh());
                 	map.put("xxylb", xmxxb.getXxylb());
                 }else{
                 	map.put("projectName", "");
                 	map.put("jsdw", "");
                 	map.put("slbh", "");
                 	map.put("xxylb", "");
                 }
            	 ReturnItem returnItem = returnItemService.getByXmbzjAndProcessInsId(businesskey,historicProcessInstance.getId());
                 if(null != returnItem){
                 	map.put("returnStatus", returnItem.getReturnStatus());
                 }
            }else{
             	map.put("projectName", "");
             	map.put("jsdw", "");
             	map.put("slbh", "");
             	map.put("xxylb", "");
             }
            map.put("businessKey", businesskey);
            map.put("proDefId", historicProcessInstance.getProcessDefinitionId());
            map.put("createTime", historicProcessInstance.getStartTime());
            map.put("status", null == historicProcessInstance.getEndTime() ? "运行中" : "已结束");
            mapList.add(map);
        }
        List<HashMap<String, Object>> mapList1 = new ArrayList<>();
        for (HashMap<String, Object> hashaasdfMap : mapList) {
        	String id=(String)hashaasdfMap.get("businessKey");
        	Xmxxb model = xmxxbService.getById(id);
        	if(model.getDwdm().equals(dwdm) && model.getSlbh().indexOf(xmxxb.getSlbh().trim())>=0 
        			&& model.getXxylb().indexOf(xmxxb.getXxylb().trim())>=0
        			&& model.getJsdw().indexOf(xmxxb.getJsdw().trim())>=0
        			&& model.getXmmc().indexOf(xmxxb.getXmmc().trim())>=0){
        		mapList1.add(hashaasdfMap);
        	}
		}
        long acd=0;
        if(mapList1.size()!=0){
        	acd=mapList1.size();
        }
        StringBuilder data = new StringBuilder("{");
        data.append(TOTAL).append(acd).append(",");
        data.append(ROWS);

        JSONArray json = JSONArray.fromObject(mapList1);
        data.append(json.toString());
        data.append("}");

        this.getResponse().getWriter().println(data);
    }
    
    /**
     * 终止流程申请（退件）
     * @throws IOException
     */
    public void terminateProcessApply() throws IOException {
    	try {
    		Xmxxb xmxxb = xmxxbService.getById(xmbzj);
    		ReturnItem returnItem = new ReturnItem();
            returnItem.setXmbzj(xmbzj);
            returnItem.setProcessInsId(processInstanceId);
            if("1".equals(type)){
             	returnItem.setReturnStatus(Constant.STATUS_RETURN_0);//挂起审核中
            }else if("2".equals(type)){
             	returnItem.setReturnStatus(Constant.STATUS_RETURN_1);//作废审核中
            }
            returnItem.setDelFlag(0);
            returnItem.setDeptId(this.getLoginUserDepartmentId());
            returnItem.setJsdw(xmxxb.getJsdw());
            returnItem.setDwdm(xmxxb.getDwdm());
            returnItem.setXmmc(xmxxb.getXmmc());
            returnItem.setXmdd(xmxxb.getJsdd());
            returnItem.setCkbh(xmxxb.getCkbh());
            returnItem.setSlbh(xmxxb.getSlbh());
            returnItem.setXxylb(xmxxb.getXxylb());
            returnItem.setZjzmj(xmxxb.getZjsmj());
            returnItem.setLxr(xmxxb.getLianxiren());
            returnItem.setLxdh(xmxxb.getPhone());
            returnItem.setBllb(xmxxb.getBllb());
            returnItem.setPrintFlag(Constant.PRINT_FLAG_1);
            returnItem.setTjyy(comment);
            returnItemService.save(returnItem);
    		identityService.setAuthenticatedUserId(this.getLoginUser().getLoginId());
    		ProcessInstance processInstance =runtimeService.startProcessInstanceByKey(Constant.PROCESS_RETURN,xmbzj);
    		String aaa=processInstance.getProcessInstanceId();
    		
    		Spjlb s=spjlbService.getByslbh(xmxxb.getSlbh());
    		if(null!=s){
    			if("1".equals(type)){
    				//挂起审核中
    				s.setGqgzl(aaa);
    				s.setGqr(this.getLoginUser().getDisplayName());
    				s.setGqsj(new Date());
    			}else if("2".equals(type)){
    				//作废审核中
    				s.setZfr(this.getLoginUser().getDisplayName());
    				s.setZfsj(new Date());
    				s.setZfgzl(aaa);
    			}
    	    	spjlbService.update(s);
    		}
    		
    		if("1".equals(type)){
    			String neirong=xmxxb.getSlbh()+"-"+xmxxb.getXmmc()+"申请退件，请予办理";
    			String phones=dxpzService.findbyywbm("006",xmxxb.getDwdm());
    		     if(!"".equals(phones)){
    		      CommonAction.sendNewMessage(neirong, phones, this.getLoginUserDepartmentId(),this.getLoginUser().getDisplayName());
//    		      CommonAction.send(neirong, phones, this.getLoginUserDepartmentId(),this.getLoginUser().getDisplayName());
    		     }
    			
    		}
    		
    		getResponse().getWriter().println("{\"result\":true}");
    	} catch (Exception e) {
            getResponse().getWriter().println("{\"result\":false}");
            e.printStackTrace();
        }
    }
    
    /**
     * 项目退件复核界面
     * @return
     */
    public String toTerminateProcessCheck() {
         Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
         ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
         String businessKey =  processInstance.getBusinessKey();
         xmxxb = xmxxbService.getById(businessKey);
         returnItem = returnItemService.getByXmbzj(businessKey);
         type = Constant.STATUS_RETURN_0.equals(returnItem.getReturnStatus())?"挂起":"作废";
         User applyUser = userService.findUserById(returnItem.getCreateUserID());
         if(null!=applyUser){
        	 applyUserName = applyUser.getDisplayName();
         }else{
        	 applyUserName = "用户不存在，请管理员核实";
         }
         List<String> outcomeList = activitiService.findOutComeListByTaskId(taskId);
         ActionContext.getContext().put("outcomeList", outcomeList);
         return SUCCESS;
     }
    
    /**
     * 终止流程复核（退件）
     * @throws IOException
     */
    public void terminateProcessCheck() throws IOException {
    	try {
            Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
            ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            String businessKey =  processInstance.getBusinessKey();
            activitiService.addComment(task, this.getLoginUser().getLoginId(), comment);
            if (Constant.OUTCOME_FAIL.equals(outcome)){
           	 	ReturnItem returnItem = returnItemService.getByXmbzj(businessKey);
           	 	xmxxb.setIstj(null);
            	xmxxbService.update(xmxxb);
            	returnItemService.delete(returnItem.getId());
            }
            Map<String, Object> variables = new HashMap<String, Object>();
            variables.put("outcome", outcome);
            taskService.complete(taskId, variables);
            this.getResponse().getWriter().println("{\"result\":true}");
        }catch (Exception e) {
            this.getResponse().getWriter().println("{\"result\":false}");
        }
    }
    
    /**
     * 项目退件复核界面
     * @return
     */
    public String toTerminateProcessAudit() {
         Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
         ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
         String businessKey =  processInstance.getBusinessKey();
         xmxxb = xmxxbService.getById(businessKey);
         returnItem = returnItemService.getByXmbzj(businessKey);
         type = Constant.STATUS_RETURN_0.equals(returnItem.getReturnStatus())?"挂起":"作废";
         User applyUser = userService.findUserById(returnItem.getCreateUserID());
         if(null!=applyUser){
        	 applyUserName = applyUser.getDisplayName();
         }else{
        	 applyUserName = "用户不存在，请管理员核实";
         }
         List<String> outcomeList = activitiService.findOutComeListByTaskId(taskId);
         ActionContext.getContext().put("outcomeList", outcomeList);
         return SUCCESS;
     }
    
    /**
     * 终止流程审核（退件）
     * @throws Exception
     */
    public void terminateProcessAudit() throws Exception{
        try {
            Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
            activitiService.addComment(task, this.getLoginUser().getLoginId(), comment);
            ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            String businessKey = processInstance.getBusinessKey();
            ReturnItem returnItem = returnItemService.getByXmbzj(businessKey);
            
            Xmxxb xmxxb = xmxxbService.getById(businessKey);
            if (Constant.OUTCOME_PASS.equals(outcome)){
	            //审核通过后终止相关流程
	            runtimeService.deleteProcessInstance(returnItem.getProcessInsId(), "人工终止");
	            if(Constant.STATUS_RETURN_0.equals(returnItem.getReturnStatus())){//退件挂起审核中
	            	//挂起相关逻辑代码
	            	xmxxb.setZclb("");
	            	xmxxb.setBllb("");
	            	xmxxb.setJzdwdz("");
	            	xmxxb.setBxzd2("");
	            	xmxxb.setIsdikou("");
//	            	if("6".equals(xmxxb.getHfsz())){
//	            		xmxxb.setZsdw("");
//	            		xmxxb.setDwdm("");
//	            	}
	            	
	            	xmxxb.setDkslbh("");
	            	xmxxb.setDkmj("");
	            	xmxxb.setLcjk("0");
	            	xmxxb.setZjsmj(xmxxb.getYsdmj());
	                xmxxb.setSjcsje("");
	            	returnItem.setReturnStatus(Constant.STATUS_RETURN_2);
	            	returnItem.setPrintFlag(Constant.PRINT_FLAG_0);
	            	// TODO
	            	String No = "TJ" + xmxxb.getBllb() + xmxxb.getDwdm().toUpperCase() + genericManager.getSN("dztj");
	            	returnItem.setTjdbh(No);
	            	xmxxb.setIstj("1");
	            	xmxxb.setYjje("");
	            	xmxxb.setYjmj("");
	            	//挂起删除,作废不删除
	                Map<String, Object> parap = new HashMap<String, Object>();
		            parap.put("slbh", xmxxb.getSlbh());
		            List<Spjlb> listspjlb=spjlbService.findSpjlball(parap);
		            List<Jkmx> jkmxs=jkmxService.findall(parap);
		            List<Qtfymx> qt=qtfymxService.findall(parap);
		            if(null!=listspjlb&&listspjlb.size()>0){
		            	for (Spjlb spjlb : listspjlb) {
		            		spjlbService.deleteWithFlag(spjlb.getId());
						}
		            }
		            if(null!=jkmxs&&jkmxs.size()>0){
		            	for (Jkmx jkbean : jkmxs) {
		            		jkmxService.deleteWithFlag(jkbean.getId());
		            	}
		            }
		        	if(null!=qt&&qt.size()>0){
	         			for (Qtfymx qtfymx : qt) {
	         				qtfymxService.deleteWithFlag(qtfymx.getId());
	         			}
	         		}
	            	
	            }else if(Constant.STATUS_RETURN_1.equals(returnItem.getReturnStatus())){//退件作废审核中
	            	//作废相关逻辑代码
                    //等于9
                    if("9".equals(xmxxb.getHfsz()))
                    {
                        //外网项目作废，调用审批不通过
                        sync(tuijianren,tuijianyuanyin,xmxxb.getXxylb());
                    }


	            	returnItem.setReturnStatus(Constant.STATUS_RETURN_3);
	            	returnItem.setPrintFlag(Constant.PRINT_FLAG_0);
	            	String xmbbh=xmxxb.getXxylb()+"(作废)";
	            	xmxxb.setXxylb(xmbbh);
	            	xmxxb.setIstj("2");
	            	 Map<String, Object> parap = new HashMap<String, Object>();
			            parap.put("slbh", xmxxb.getSlbh());
			            List<Spjlb> listspjlb=spjlbService.findSpjlball(parap);
			            if(null!=listspjlb&&listspjlb.size()>0){
			            	for (Spjlb spjlb : listspjlb) {
			            		spjlb.setXxbbh(xmbbh);
			            		spjlbService.update(spjlb);
							}
			            }
			            
			            
	            }
	            
	 
	            //直接缴费项目
	            if("0".equals(xmxxb.getZjdyjks())){
	            	xmxxb.setZjdyjks("");
	            	Map<String, Object> vad = new HashMap<String, Object>();
	         		vad.put("slbh", xmxxb.getSlbh());
	         		List<PaymentItemPending> lis=paymentItemPendingService.findPaymentItemPending(vad);
	         		List<Jktzs> jktzs=jktzsService.findByAll(vad);
	         		List<Cktzs> lck=cktzsService.findByall(vad);
	         		if(null!=lis&&lis.size()>0){
	         			for (PaymentItemPending asd : lis) {
	         				paymentItemPendingService.delete(asd.getId());
						}
	         		 }
	         		if(null!=jktzs&&jktzs.size()>0){
	         			for (Jktzs jktbean : jktzs) {
	         				jktzsService.deleteWithFlag(jktbean.getId());
						}
	         			
	         		}
	         		if(null!=lck&&lck.size()>0){
	         			for (Cktzs cktzs : lck) {
	         				cktzsService.deleteWithFlag(cktzs.getId());
						}
	         		}
	         	
	            }
	            
	            
	            xmxxbService.update(xmxxb);
	            returnItemService.update(returnItem);
            }
            Map<String, Object> variables = new HashMap<String, Object>();
            variables.put("outcome", outcome);
            taskService.complete(taskId, variables);
            
            this.getResponse().getWriter().println("{\"result\":true}");
        }catch (Exception e) {
            this.getResponse().getWriter().println("{\"result\":false}");
        }
    }

    public void terminateProcessInstance() throws IOException {
        try {
            runtimeService.deleteProcessInstance(processInstanceId, "人工终止");
            getResponse().getWriter().println("{\"result\":true}");
        } catch (Exception e) {
            getResponse().getWriter().println("{\"result\":false}");
            e.printStackTrace();
        }
    }

    /**
     * 部门树的节点查询，封装成树的节点信息返回：<br>
     *
     * @throws Exception
     * @author yangshunqing
     */
    public void findChildDept() throws IOException {
        User user = getLoginUser();
        if (null == selDept) {
            // 初始化部门树
            List<Map<String, Object>> items = new ArrayList<>();
            Map<String, Object> root = new HashMap<>();

            if (user.getIsSuperAdmin()) {
                root.put("id", "");
                root.put("text", "组织机构");
                root.put("state", "opened");
                List<Department> deptList = deptService.findDeptByParentDeptCode("");
                List<Map<String, Object>> elements = new ArrayList<>();
                for (Department d : deptList) {
                    Map<String, Object> item = new HashMap<>();
                    item.put("id", d.getDeptCode());
                    item.put("text", d.getDeptName());
                    item.put("state", "closed");
                    List<Map<String, Object>> leafs = new ArrayList<>();
                    List<User> allpeople = userService.findAllUsersByDept(d.getDeptCode());
                    for (User p : allpeople) {
                        Map<String, Object> lastl = new HashMap<>();
                        lastl.put("id", p.getLoginId());
                        lastl.put("text", p.getDisplayName());
                        lastl.put("attributes", "last");
                        lastl.put("phoneNum", p.getMobile());
                        leafs.add(lastl);
                    }
                    item.put("children", leafs);

                    elements.add(item);
                }
                root.put("children", elements);
                items.add(root);
            } else {
                root.put("id", "");
                root.put("text", "组织机构");
                root.put("state", "opened");
                List<Map<String, Object>> elements = new ArrayList<>();

                Department independenceDept = deptService.findDeptByDeptCode(user.getDeptCode());
                Map<String, Object> item = new HashMap<>();
                item.put("id", independenceDept.getDeptCode());
                item.put("text", independenceDept.getDeptName());
                item.put("state", "closed");
                List<Map<String, Object>> leafs = new ArrayList<>();
                List<User> allpeople = userService.findAllUsersByDept(independenceDept.getDeptCode());
                for (User p : allpeople) {
                    Map<String, Object> lastl = new HashMap<>();
                    lastl.put("id", p.getLoginId());
                    lastl.put("text", p.getDisplayName());
                    lastl.put("attributes", "last");
                    lastl.put("phoneNum", p.getMobile());
                    leafs.add(lastl);
                }
                item.put("children", leafs);

                elements.add(item);

                List<UserLinkedDept> linkedDeptList = userLinkedDeptService.getLinkedDeptByUser(user.getId(), "%");
                if (linkedDeptList != null && !linkedDeptList.isEmpty()) {
                    for (UserLinkedDept linkedDept : linkedDeptList) {
                        item = new HashMap<>();
                        item.put("id", linkedDept.getLinkedDept().getDeptCode());
                        item.put("text", linkedDept.getLinkedDept().getDeptName());
                        item.put("state", "closed");

                        for (User p : allpeople) {
                            Map<String, Object> lastl = new HashMap<>();
                            lastl.put("id", p.getLoginId());
                            lastl.put("text", p.getDisplayName());
                            lastl.put("attributes", "last");
                            lastl.put("phoneNum", p.getMobile());
                            leafs.add(lastl);
                        }
                        item.put("children", leafs);
                        elements.add(item);
                    }
                }
                root.put("children", elements);
                items.add(root);
            }
            JSONArray json = JSONArray.fromObject(items);
            HttpServletResponse response = ServletActionContext
                    .getResponse();
            response.setContentType("application/json;charset=UTF-8");
            response.setCharacterEncoding("utf-8");
            response.setHeader("Charset", "utf-8");
            response.setHeader("Cache-Control", "no-cache");
            response.getWriter().print(json.toString());
        } else {
            deptList = deptService.findDeptByParentDeptCode(selDept);
            List<Map<String, Object>> items = new ArrayList<>();
            for (Department d : deptList) {
                Map<String, Object> item = new HashMap<>();
                item.put("id", d.getDeptCode());
                item.put("text", d.getDeptName());
                item.put("state", "closed");
                List<Map<String, Object>> leafs = new ArrayList<>();
                List<User> allpeople = userService.findAllUsersByDept(d.getDeptCode());
                for (User p : allpeople) {
                    Map<String, Object> lastl = new HashMap<>();
                    lastl.put("id", p.getLoginId());
                    lastl.put("text", p.getDisplayName());
                    lastl.put("attributes", "last");
                    lastl.put("phoneNum", p.getMobile());
                    leafs.add(lastl);
                }
                item.put("children", leafs);

                items.add(item);
            }
            dept = deptService.findDeptByDeptCode(selDept);
            deptList = deptService.findLinkedDpet(dept);
            for (Department d : deptList) {
                Map<String, Object> item = new HashMap<>();
                item.put("id", d.getDeptCode());
                StringBuilder name = new StringBuilder("<font color='red'>");
                if (d.getParentDept() != null) {
                    name.append(d.getParentDept().getDeptName()).append("-");
                }
                name.append(d.getDeptName()).append("</font>");
                item.put("text", name.toString());
                item.put("state", "closed");
                List<Map<String, Object>> leafs = new ArrayList<>();
                List<User> allpeople = userService.findAllUsersByDept(d.getDeptCode());
                for (User p : allpeople) {
                    Map<String, Object> lastl = new HashMap<>();
                    lastl.put("id", p.getLoginId());
                    lastl.put("text", p.getDisplayName());
                    lastl.put("attributes", "last");
                    lastl.put("phoneNum", p.getMobile());
                    leafs.add(lastl);
                }
                item.put("children", leafs);
                items.add(item);
            }
            JSONArray json = JSONArray.fromObject(items);
            HttpServletResponse response = ServletActionContext
                    .getResponse();
            response.setContentType("application/json;charset=UTF-8");
            response.setCharacterEncoding("utf-8");
            response.setHeader("Charset", "utf-8");
            response.setHeader("Cache-Control", "no-cache");
            response.getWriter().print(json.toString());
        }
    }

    /**
     * 已办任务列表
     *
     * @return
     * @author yangshunqing
     */
    public void findDoneTaskList() {
        try {
            pagination = new Pagination(super.getRequest());
            // 获取历史流程实例的查询对象
            String people = getLoginUser().getLoginId();
            HistoricTaskInstanceQuery doneTaskQuery;
            if ("admin".equals(people)) {
                doneTaskQuery = historyService.createHistoricTaskInstanceQuery().finished().taskCompletedAfter(startDate).taskCompletedBefore(endDate).orderByHistoricTaskInstanceEndTime().desc();
            } else {
                doneTaskQuery = historyService.createHistoricTaskInstanceQuery().finished().taskInvolvedUser(people).taskCompletedAfter(startDate).taskCompletedBefore(endDate).orderByHistoricTaskInstanceEndTime().desc();
            }

            if (null != this.Assignee && !"".equalsIgnoreCase(this.Assignee)) {
                doneTaskQuery = doneTaskQuery.taskAssigneeLike("%" + this.Assignee + "%");
            }
            if (null != this.taskName && !"".equalsIgnoreCase(this.taskName)) {
                doneTaskQuery = doneTaskQuery.taskNameLike("%" + this.taskName + "%");
            }

            List<HistoricTaskInstance> doneTaskList = doneTaskQuery.listPage(pagination.getFirstResult(), pagination.getPageSize());

            List<HashMap<String, Object>> mapList = new ArrayList<>();
            for (HistoricTaskInstance task : doneTaskList) {
                HashMap<String, Object> map = new HashMap<>();

                map.put("id", task.getId());
                map.put("procDefName", repositoryService.createProcessDefinitionQuery().processDefinitionId(task.getProcessDefinitionId()).singleResult().getName());
                String businessKey = historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult().getBusinessKey();
                if(null!=businessKey){
                	Xmxxb xmxxb = xmxxbService.getById(businessKey);
                	 if(null!=xmxxb){
                     	 map.put("projectName", xmxxb.getXmmc());
                     	 map.put("slbh", xmxxb.getSlbh());
                     }else{
                     	 map.put("projectName", "");
                     	 map.put("slbh", "");
                     }
                }else{
                 	map.put("projectName", "");
                 	map.put("slbh", "");
                }
                map.put("businessKey", businessKey);
                map.put("taskDefinitionKey", task.getTaskDefinitionKey());
                map.put("processInstanceId", task.getProcessInstanceId());
                map.put("processDefinitionId", task.getProcessDefinitionId());
                map.put("name", task.getName());
                map.put("startTime", outSdf.format(task.getStartTime()));
                map.put("claimTime", task.getClaimTime());
                map.put("description", task.getDescription());
                map.put("deleteReason", task.getDeleteReason());
                map.put("endTime", outSdf.format(task.getEndTime()));
                map.put("owner", task.getOwner());

                mapList.add(map);
            }

            StringBuilder data = new StringBuilder("{\n");
            data.append("  \"total\":").append(doneTaskQuery.count()).append(",\n");
            data.append("  \"rows\":\n");

            JSONArray json = JSONArray.fromObject(mapList);
            data.append(json.toString());
            data.append("  \n").append("}");

            this.getResponse().getWriter().println(data);
        } catch (Exception e) {
            logger.error("get doing tasks error", e);
            throw new BasalException(BasalException.ERROR, e);

        }
    }

    /**
     * 查询某个已办任务详情
     *
     * @author yangshunqing
     * <p>
     * 其他信息根据需要再次添加
     */
    public void lookupDoneTask() {
        try {
            pagination = new Pagination(super.getRequest());
            // 获取历史流程实例的查询对象
            HistoricTaskInstance task = historyService.createHistoricTaskInstanceQuery().finished().taskId(this.taskId).singleResult();

            HashMap<String, Object> map = new HashMap<>();
            ProcessDefinitionEntity pde = (ProcessDefinitionEntity) ((RepositoryServiceImpl) repositoryService)
                    .getDeployedProcessDefinition(task.getProcessDefinitionId());

            map.put("procName", pde.getName());
            map.put("id", task.getId());
            map.put("taskName", task.getName());
            map.put("startTime", outSdf.format(task.getStartTime()));
            map.put("claimTime", outSdf.format(task.getClaimTime()));
            if(null==task.getDescription() || "".equals(task.getDescription().trim())){
            	map.put("description", "无");
            }else{
            	map.put("description", task.getDescription());
            }
            map.put("endTime", outSdf.format(task.getEndTime()));
            map.put("owner", task.getOwner());
            map.put("assignee", task.getAssignee());
            map.put("deleteReason", task.getDeleteReason());
            Long minutes = task.getDurationInMillis();
            minutes = minutes / 60000;
            map.put("duration", minutes);


            StringBuilder data = new StringBuilder();
            JSONArray json = JSONArray.fromObject(map);
            data.append(json.toString());
            data.deleteCharAt(0);
            data.deleteCharAt(data.length() - 1);
            this.getResponse().getWriter().println(data);
        } catch (Exception e) {
            logger.error("get doing tasks error", e);
            throw new BasalException(BasalException.ERROR, e);
        }
    }

    /**
     * Model列表
     *
     * @throws IOException
     * @author YuWeitao
     */
    public void findModelList() throws IOException {
        pagination = new Pagination(super.getRequest());
        ModelQuery modelQuery = repositoryService.createModelQuery().orderByCreateTime().desc();
        if (null != this.modelKey && !"".equalsIgnoreCase(this.modelKey)) {
            modelQuery = modelQuery.modelKey(this.modelKey);
        }
        if (null != this.modelName && !"".equalsIgnoreCase(this.modelName)) {
            modelQuery = modelQuery.modelNameLike("%" + this.modelName + "%");
        }
        List<Model> modelList = modelQuery.listPage(pagination.getFirstResult(), pagination.getPageSize());

        List<HashMap<String, Object>> mapList = new ArrayList<>();
        for (Model model : modelList) {
            HashMap<String, Object> map = new HashMap<>();
            map.put("isFormkey", false);
            //解析Model里的formkey属性值
            JsonNode modelNode = new ObjectMapper().readTree(repositoryService.getModelEditorSource(model.getId()));
            List<JsonNode> formkeyList = modelNode.findValues("formkeydefinition");
            String formkeyArrayStr = "";
            for (JsonNode node : formkeyList) {
                if (null != node.asText() && !"".equalsIgnoreCase(node.asText())) {
                    formkeyArrayStr += node.asText() + "|";

                    map.put("isFormkey", true);
                }
            }
            map.put("formkeyArrayStr", formkeyArrayStr);

            map.put(ID, model.getId());
            map.put("key", model.getKey());
            map.put("category", model.getCategory());
            map.put(CREATED_TIME, model.getCreateTime());
            map.put("deploymentId", model.getDeploymentId());
            map.put("lastUpdateTime", model.getLastUpdateTime());
            map.put("metaInfo", model.getMetaInfo());
            map.put(NAME, model.getName());
            map.put("version", model.getVersion());

            mapList.add(map);
        }

        StringBuilder data = new StringBuilder("{");
        data.append(TOTAL).append(modelQuery.count()).append(",");
        data.append(ROWS);

        JSONArray json = JSONArray.fromObject(mapList);
        data.append(json.toString());
        data.append("}");

        this.getResponse().getWriter().println(data);
    }

    /**
     * 创建Model
     *
     * @author YuWeitao
     */
    public void addModel() throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode editorNode = objectMapper.createObjectNode();
        editorNode.put(ID, "canvas");
        editorNode.put("resourceId", "canvas");
        ObjectNode stencilSetNode = objectMapper.createObjectNode();
        stencilSetNode.put("namespace", "http://b3mn.org/stencilset/bpmn2.0#");
        editorNode.put("stencilset", stencilSetNode);
        Model modelData = repositoryService.newModel();

        ObjectNode modelObjectNode = objectMapper.createObjectNode();
        modelObjectNode.put(ModelDataJsonConstants.MODEL_NAME, this.modelName);
        modelObjectNode.put(ModelDataJsonConstants.MODEL_REVISION, 1);
        modelObjectNode.put(ModelDataJsonConstants.MODEL_DESCRIPTION, this.modelDesc);
        modelData.setMetaInfo(modelObjectNode.toString());
        modelData.setName(this.modelName);
        modelData.setKey(this.modelKey);

        repositoryService.saveModel(modelData);
        repositoryService.addModelEditorSource(modelData.getId(), editorNode.toString().getBytes("utf-8"));

        this.getResponse().sendRedirect(this.getRequest().getContextPath() + "/modeler.html?modelId=" + modelData.getId());
    }


    /**
     * 部署Model
     *
     * @throws IOException
     * @author YuWeitao
     */
    public void deployModel() throws IOException {
        try {
            Model modelData = repositoryService.getModel(modelId);
            JsonNode modelNode = new ObjectMapper().readTree(repositoryService.getModelEditorSource(modelData.getId()));
            BpmnModel bpmnModel = new BpmnJsonConverter().convertToBpmnModel(modelNode);

            String processName = modelData.getName() + BPMN_SUFFIX;
            DeploymentBuilder deploymentBuilder = repositoryService.createDeployment().name(modelData.getName()).addBpmnModel(processName, bpmnModel);

            List<JsonNode> list = modelNode.findValues("formkeydefinition");
            for (JsonNode node : list) {
                if (null != node.asText() && !"".equalsIgnoreCase(node.asText())) {
                    deploymentBuilder.addClasspathResource(node.asText());
                }
            }
            deploymentBuilder.deploy();

            this.getResponse().getWriter().println(SUCCESS_RESULT);
        } catch (Exception e) {
            activitiLogger.error("部署模型失败", e);
            this.getResponse().getWriter().println(ERROR_RESULT);
        }
    }

    /**
     * 删除Model
     *
     * @throws IOException
     * @author YuWeitao
     */
    public void deleteModel() throws IOException {
        if (null != ids) {
            for (String modelid : ids)
                repositoryService.deleteModel(modelid);
            getResponse().getWriter().println(SUCCESS_RESULT);
        } else {
            getResponse().getWriter().println(ERROR_RESULT);
        }
    }

    /**
     * 导出模型XML文件
     *
     * @author YuWeitao
     */
    public void exportModelXml() throws IOException {
        try {
            Model modelData = repositoryService.getModel(modelId);
            BpmnJsonConverter jsonConverter = new BpmnJsonConverter();
            JsonNode editorNode = new ObjectMapper().readTree(repositoryService.getModelEditorSource(modelData.getId()));
            BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editorNode);
            List<Process> proc = bpmnModel.getProcesses();
            BpmnXMLConverter xmlConverter = new BpmnXMLConverter();
            byte[] bpmnBytes;
            String filename;
            if (proc.isEmpty()) {
                bpmnBytes = new byte[1];
                filename = "emptyModel" + BPMN_SUFFIX;
            } else {
                bpmnBytes = xmlConverter.convertToXML(bpmnModel);
                filename = bpmnModel.getMainProcess().getId() + BPMN_SUFFIX;
            }

            ByteArrayInputStream in = new ByteArrayInputStream(bpmnBytes);
            this.getResponse().setBufferSize(1024 * 32);//设置缓冲区大小，解决大字节流XML头丢失的问题  add by YuWeitao 2013-06-25
            IOUtils.copy(in, this.getResponse().getOutputStream());
            this.getResponse().setHeader("Content-Disposition", "attachment; filename=" + filename);
            this.getResponse().flushBuffer();
        } catch (Exception e) {
            activitiLogger.error("导出model的xml文件失败：modelId={}", modelId, e);
            throw e;
        }
    }

    /**
     * 启动流程
     */
    public void startWorkflow() {
        Map<String, Object> result = new HashMap<>();
        try {
            identityService.setAuthenticatedUserId(getLoginUser().getLoginId());
            runtimeService.startProcessInstanceById(processDefinitionId);
            StartFormData sfd = formService.getStartFormData(processDefinitionId);
            result.put("success", true);
            if (sfd != null) {
                result.put("form", sfd.getFormProperties());
            }
        } catch (Exception e) {

            activitiLogger.error("start process error", e);
            result.put("success", false);
            result.put("error", e.getMessage());
        }
        this.outputJson(null, result);
    }

    /**
     * 查找业务补偿Bean
     */
    public void findCompensationService() throws IOException {
        Map<String, Object> allBean = SpringContextHolder.getAllBeans();
        List<String> list = new ArrayList<>();
        for (Map.Entry<String, Object> entry : allBean.entrySet()) {
            Object bean = entry.getValue();
            String beanName = entry.getKey();
            if (bean instanceof CompensationService && beanName.contains(userId)) {
                list.add(beanName);
            }
        }
        JSONArray json = JSONArray.fromObject(list);
        getResponse().getWriter().print(json.toString());
    }

    //获取所有的流程定义Key
    public String initProcessDefList() {
        ModelQuery modelQuery = repositoryService.createModelQuery().orderByModelKey().desc();
        keyList.add("---ALL---");
        List<Model> modelList = modelQuery.list();
        modelList.forEach(model -> keyList.add(model.getKey()));
        return SUCCESS;
    }


    public void convertToModel() throws IOException {
        try {
            ProcessDefinition processDefinition = repositoryService.createProcessDefinitionQuery()
                    .processDefinitionId(processDefinitionId).singleResult();
            InputStream bpmnStream = repositoryService.getResourceAsStream(processDefinition.getDeploymentId(),
                    processDefinition.getResourceName());

            XMLInputFactory xif = XMLInputFactory.newInstance();
            InputStreamReader in = new InputStreamReader(bpmnStream, "UTF-8");
            XMLStreamReader xtr = xif.createXMLStreamReader(in);
            BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);

            BpmnJsonConverter converter = new BpmnJsonConverter();
            com.fasterxml.jackson.databind.node.ObjectNode modelNode = converter.convertToJson(bpmnModel);
            Model modelData = repositoryService.newModel();
            modelData.setKey(processDefinition.getKey());
            modelData.setName(processDefinition.getName());
            modelData.setCategory(processDefinition.getDeploymentId());

            ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
            modelObjectNode.put(ModelDataJsonConstants.MODEL_NAME, processDefinition.getName());
            modelObjectNode.put(ModelDataJsonConstants.MODEL_REVISION, 1);
            modelObjectNode.put(ModelDataJsonConstants.MODEL_DESCRIPTION, processDefinition.getDescription());
            modelData.setMetaInfo(modelObjectNode.toString());

            repositoryService.saveModel(modelData);

            repositoryService.addModelEditorSource(modelData.getId(), modelNode.toString().getBytes("utf-8"));

            this.getResponse().getWriter().print(this.SUCCESS_RESULT);
        } catch (Exception e) {
            activitiLogger.error("模型转换失败", e);
            this.getResponse().getWriter().print(this.ERROR_RESULT);
        }
    }

    public String initViewHistory() {return SUCCESS;}


    public void viewHistory() throws IOException {
        pagination = new Pagination(super.getRequest());
        HistoricTaskInstanceQuery query = historyService.createHistoricTaskInstanceQuery();
       List<HistoricTaskInstance> historicTaskInstancesList = query.processInstanceId(processInstanceId).listPage(pagination.getFirstResult(),pagination.getPageSize());

        List<HashMap<String, Object>> mapList = new ArrayList<>();
        for (HistoricTaskInstance taskInstance : historicTaskInstancesList) {
            HashMap<String, Object> map = new HashMap<>();

            map.put("name", taskInstance.getName());
            map.put("startTime", taskInstance.getStartTime());
            map.put("endTime", taskInstance.getEndTime());
            User uu=userService.findUserByLoginId(taskInstance.getAssignee());
            if(null!=uu){
            	map.put("assignee", uu.getDisplayName());
            }else{
            	map.put("assignee", "");
            }
            map.put("duration", taskInstance.getDurationInMillis() == null ? "" : new DecimalFormat("######0.00").format((double) taskInstance.getDurationInMillis()/1000/60));


            mapList.add(map);
        }

        StringBuilder data = new StringBuilder("{");
        data.append(TOTAL).append(query.count()).append(",");
        data.append(ROWS);

        JSONArray json = JSONArray.fromObject(mapList);
        data.append(json.toString());
        data.append("}");

        this.getResponse().getWriter().println(data);
    }

    /**
     * 同步
     */
    private Boolean sync(String tuijianren,String tuijianyuanyin,String xxylb) throws Exception
    {
        Map<String ,String> map = new HashMap<>();
        map.put("method","syncfj");
        map.put("issptg","B");
        map.put("sbzt", "4");//作废
        String yjfy="0";//应缴金额

        map.put("csr", tuijianren);
        map.put("csyj", tuijianyuanyin);
        map.put("fhr", "");
        map.put("fhyj", "");
        map.put("yjfy", yjfy);
        map.put("xxylb", xxylb);

        String result = com.jshx.module.admin.web.action.CommonAction.send2ww(map,null);
        if(StringUtil.isNotEmpty(result) && result.contains("\"message\":") && result.contains("\"code\":"))
        {
            String result1 = com.jshx.module.admin.web.action.CommonAction.getValueFromJsonstr(result,"message");
            if("查询失败".equals(result1))
            {
                return false ;
            }
        }
        else
        {

            return false ;
        }
        return true;
    }



    public void testAction() {
        activitiService.getJumpToTasks(processInstanceId, taskDefKey);
    }

    public String showDiagram() {
        return SUCCESS;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setRuntimeService(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public Pagination getPagination() {
        return pagination;
    }

    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getFileFileName() {
        return fileFileName;
    }

    public void setFileFileName(String fileFileName) {
        this.fileFileName = fileFileName;
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }
    
	public String getTaskIds() {
		return taskIds;
	}

	public void setTaskIds(String taskIds) {
		this.taskIds = taskIds;
	}

    public String getProcessDefinitionId() {
        return processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public String getModelName() {
        return modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelKey() {
        return modelKey;
    }

    public void setModelKey(String modelKey) {
        this.modelKey = modelKey;
    }

    public String getModelDesc() {
        return modelDesc;
    }

    public void setModelDesc(String modelDesc) {
        this.modelDesc = modelDesc;
    }

    public String getProcessDefKey() {
        return processDefKey;
    }

    public void setProcessDefKey(String processDefKey) {
        this.processDefKey = processDefKey;
    }

    public String getProcessDefName() {
        return processDefName;
    }

    public void setProcessDefName(String processDefName) {
        this.processDefName = processDefName;
    }

    public String[] getIds() {
        return ids;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

    public String getModelId() {
        return modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getBusinessEntityClassName() {
        return businessEntityClassName;
    }

    public void setBusinessEntityClassName(String businessEntityClassName) {
        this.businessEntityClassName = businessEntityClassName;
    }

    public String getBusinessEntityPrefix() {
        return businessEntityPrefix;
    }

    public void setBusinessEntityPrefix(String businessEntityPrefix) {
        this.businessEntityPrefix = businessEntityPrefix;
    }

    public Map<String, String> getFormMap() {
        return formMap;
    }

    public void setFormMap(Map<String, String> formMap) {
        this.formMap = formMap;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Boolean getIsSaved() {
        return isSaved;
    }

    public void setIsSaved(Boolean saved) {
        isSaved = saved;
    }

    public String getAsignee() {
        return asignee;
    }

    public void setAsignee(String asignee) {
        this.asignee = asignee;
    }

    //**********@yangshunqing**********//
    public String getSelDept() {
        return selDept;
    }

    public void setSelDept(String selDept) {
        this.selDept = selDept;
    }

    public Department getDept() {
        return dept;
    }

    public void setDept(Department dept) {
        this.dept = dept;
    }

    public List<Department> getDeptList() {
        return deptList;
    }

    public void setDeptList(List<Department> deptList) {
        this.deptList = deptList;
    }

    public String getAssignee() {
        return Assignee;
    }

    public void setAssignee(String assignee) {
        Assignee = assignee;
    }

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }


    public String getProcessInstanceId() {
        return processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    /**
     * @return the taskDefKey
     */
    public String getTaskDefKey() {
        return taskDefKey;
    }

    /**
     * @param taskDefKey the taskDefKey to set
     */
    public void setTaskDefKey(String taskDefKey) {
        this.taskDefKey = taskDefKey;
    }

    public List<String> getKeyList() {
        return keyList;
    }

    public void setKeyList(List<String> keyList) {
        this.keyList = keyList;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public static String getErrorResult() {
        return ERROR_RESULT;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

	public String getOutcome() {
		return outcome;
	}

	public void setOutcome(String outcome) {
		this.outcome = outcome;
	}

	public String getXmbzj() {
		return xmbzj;
	}

	public void setXmbzj(String xmbzj) {
		this.xmbzj = xmbzj;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getReason() {
		return reason;
	}

	public void setReason(String reason) {
		this.reason = reason;
	}

	public Xmxxb getXmxxb() {
		return xmxxb;
	}

	public void setXmxxb(Xmxxb xmxxb) {
		this.xmxxb = xmxxb;
	}

	public JkmxService getJkmxService() {
		return jkmxService;
	}

	public void setJkmxService(JkmxService jkmxService) {
		this.jkmxService = jkmxService;
	}

	public ReturnItem getReturnItem() {
		return returnItem;
	}

	public void setReturnItem(ReturnItem returnItem) {
		this.returnItem = returnItem;
	}

	public String getApplyUserName() {
		return applyUserName;
	}

	public void setApplyUserName(String applyUserName) {
		this.applyUserName = applyUserName;
	}

    public String getTuijianren() {
        return tuijianren;
    }

    public void setTuijianren(String tuijianren) {
        this.tuijianren = tuijianren;
    }

    public String getTuijianyuanyin() {
        return tuijianyuanyin;
    }

    public void setTuijianyuanyin(String tuijianyuanyin) {
        this.tuijianyuanyin = tuijianyuanyin;
    }
}