package com.jshx.activiti.tag;

import org.activiti.engine.HistoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.jshx.core.utils.SpringContextHolder;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.service.UserService;
import com.jshx.module.admin.service.impl.UserServiceImpl;

import javax.servlet.ServletContext;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;

/**
 * Created by ian on 2016/8/3.
 */
public class ShowCommentList extends SimpleTagSupport {
    private String taskId;

    private static TaskService taskService;

    private static HistoryService historyService;
    
    private  UserService userService = SpringContextHolder.getBean("userService");

    private int rows;

    public void doTag() throws IOException {

        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        StringBuffer sb = new StringBuffer();

        if (null == taskService) {
            ServletContext servletContext = ((PageContext) this.getJspContext()).getServletContext();
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext(servletContext);
            taskService = (TaskService) wac.getBean("taskService");
            historyService = (HistoryService) wac.getBean("historyService");
        }

        String procInstanceId = taskService.createTaskQuery().taskId(taskId).singleResult().getProcessInstanceId();

        List<Comment> commentList = taskService.getProcessInstanceComments(procInstanceId);

        if (null != commentList && rows != 0 && commentList.size()>rows)
            commentList = commentList.subList(0,rows);

        sb.append("<div  style=\"padding-top: 1%\">");
        sb.append("<table width=\"100%\" border=\"1\" cellpadding=\"0\" cellspacing=\"0\">\r\n");
        sb.append("<tr class=\"HeaderStyle\" height=\"22px\">");
        sb.append("<th class=\"tb_01\" style=\"text-align:center\" width=\"15%\">任务名称</th>");
        sb.append("<th class=\"tb_01\" style=\"text-align:center\" width=\"15%\">处理人</th>");
        sb.append("<th class=\"tb_01\" style=\"text-align:center\" width=\"55%\">审批意见</th>");
        sb.append("<th class=\"tb_01\" style=\"text-align:center\" width=\"15%\">处理时间</th>");
        sb.append("</tr>");

        if(commentList!=null&&commentList.size()>0){
            for(Comment comment : commentList){
               HistoricTaskInstance historicTaskInstance = historyService.createHistoricTaskInstanceQuery().taskId(comment.getTaskId()).singleResult();
                sb.append("<tr height=\"20px\" class=\"listRow\">");
                sb.append("<td class=\"tb_02\" style=\"text-align:center\">"+ historicTaskInstance.getName()+"</td>");
                User uu=userService.findUserByLoginId(comment.getUserId());
                if(null!=uu){
                	sb.append("<td class=\"tb_02\" style=\"text-align:center\">"+ uu.getDisplayName() +"</td>");
                }else{
                	sb.append("<td class=\"tb_02\" style=\"text-align:center\">"+ comment.getUserId() +"</td>");
                	
                }
                if(null==comment.getFullMessage()){
                    sb.append("<td class=\"tb_02\" style=\"text-align:center\">"+ "无" +"</td>");
                }else{
                    sb.append("<td class=\"tb_02\" style=\"text-align:center\">"+ comment.getFullMessage() +"</td>");
                }
                sb.append("<td class=\"tb_02\" style=\"text-align:center\">"+ sf.format(comment.getTime()) +"</td>");
                sb.append("</tr>");
            }
        }else
        {
            sb.append("<tr height=\"20px\">");
            sb.append("<td class=\"tb_02\" width=\"100%\" colspan=\"6\" style=\"text-align:center\">没有审批意见</td>");
            sb.append("</tr>");
        }
        sb.append("</table></div>");

        this.getJspContext().getOut().print(sb.toString());

    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public int getRows() {
        return rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }
}
