package com.jshx.activiti.service.impl;

import com.jshx.activiti.dao.ActivitiMessageDao;
import com.jshx.activiti.entity.ActivitiMessage;
import com.jshx.activiti.service.ActivitiMessageService;
import com.linkage.netmsg.NetMsgclient;
import com.linkage.netmsg.server.AnswerBean;
import com.linkage.netmsg.server.ReceiveMsg;
import com.linkage.netmsg.server.ReturnMsgBean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by chenjian on 16/6/17.
 */
public class ActivitiMessageServiceImpl implements ActivitiMessageService {

    private static final Logger logger = LoggerFactory.getLogger(ActivitiMessageServiceImpl.class);

    private static boolean isRunning = false;

    private String account;

    private String password;

    private String address;

    private Integer port;

    private NetMsgclient netMsgclient;

    private Map<String, ActivitiMessage> messageQueue = new ConcurrentHashMap<>();

    private List<ActivitiMessage> receivedMessageList = new ArrayList<>();

    private ReceiveMsg receiveMsg = new ReceiveMsg(){

        @Override
        public void getReturnMsg(ReturnMsgBean returnMsgBean) {
            super.getReturnMsg(returnMsgBean);
            String sequenceId = returnMsgBean.getSequenceId();
            String msgId = returnMsgBean.getMsgId();
            String sendNum = returnMsgBean.getSendNum();
            String receiveNum = returnMsgBean.getReceiveNum();
            String submitTime = returnMsgBean.getSubmitTime();
            String sendTime = returnMsgBean.getSendTime();
            String msgStatus = returnMsgBean.getMsgStatus();
            int msgErrStatus = returnMsgBean.getMsgErrStatus();
        }

        @Override
        public void getAnswer(AnswerBean answerBean) {
            super.getAnswer(answerBean);
            String seqIdString = answerBean.getSeqId();
            int status = answerBean.getStatus();
            String msgId = answerBean.getMsgId();
        }

    };

    @Autowired
    private ActivitiMessageDao activitiMessageDao;

    @Transactional
    @Override
    //@Scheduled(cron = "0 */1 * * * ?")
    public void sendSmsMessage() {
        if(isRunning) {
            logger.info("任务还在执行");
            return;
        }
        isRunning = true;
        try{
            connectLinkage();
            List<ActivitiMessage> messageList = activitiMessageDao.findUnsentMag();
            for(ActivitiMessage message: messageList){
                String msgId = message.getMsgId();
                if(message.getType()==1 && (StringUtils.isEmpty(msgId) || msgId.equals("16"))){
                    String receiver = message.getReceiver();
                    String content = message.getContent();
                    msgId = netMsgclient.sendMsg(netMsgclient, 0, receiver, content, 0);
                    message.setMsgId(msgId);
                    messageQueue.put(msgId, message);
                }
            }
            saveMessages(messageList);
        }catch(IOException e){
            logger.error(e.getLocalizedMessage(), e);
            try{
                netMsgclient.closeConn();
                netMsgclient = null;
                Thread.sleep(60000);
            }catch(Exception ex){
                logger.error(e.getLocalizedMessage(), ex);
            }
        }
        isRunning = false;
    }

    @Transactional
    @Override
    public void saveMessage(ActivitiMessage message) {
        activitiMessageDao.saveBaseModelObject(message);
    }

    @Transactional
    @Override
    public void saveMessages(List<ActivitiMessage> messageList) {
        messageList.forEach(message -> activitiMessageDao.saveBaseModelObject(message));
    }

    private void connectLinkage() throws IOException{
        if(netMsgclient==null){
            netMsgclient = new NetMsgclient();
            netMsgclient.initParameters(address, port, account, password, receiveMsg);
            boolean isLogin = netMsgclient.anthenMsg(netMsgclient);
            if(!isLogin){
                throw new IOException("连接企信通失败,用户名或密码错误");
            }
        }
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPort(Integer port) {
        this.port = port;
    }
}
