package com.jshx.activiti.service;

import com.jshx.module.admin.entity.User;
import org.activiti.bpmn.model.DelayProperty;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.form.FormProperty;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Task;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 提供Activiti的基础服务
 * <p>
 * Created by chenjian on 16/4/29.
 */
public interface ActivitiService {

    /**
     * 查询流程当前节点的下一步节点。用于流程提示时的提示。
     *
     * @param taskId
     * @return
     * @throws Exception
     */
    Map<String, FlowNode> findNextTask(String taskId);

    /**
     * 查询流程当前节点的上一步节点
     *
     * @param taskId
     * @return
     */
    Map<String, FlowNode> findPreTask(String taskId);

    /**
     * 根据任务定义查询上一步节点
     *
     * @param processInstanceId
     * @param taskDefKey
     * @return
     */
    List<Task> findPreTaskByDefKey(String processInstanceId, String taskDefKey);

    /**
     * 根据任务查找处理人
     *
     * @param taskId
     * @return
     */
    Map<String, Object> findHandler(String taskId);

    /**
     * 获取form表单
     *
     * @param taskId
     * @return
     */
    List<Map<String, Object>> getFormProperties(String taskId);

    /**
     * 获取指定任务的候选人
     *
     * @param taskId
     * @return
     */
    List<User> getCandidate(String taskId);

    /**
     * 获取指定任务的办理人
     *
     * @param taskId
     * @return
     */
    User getAssignee(String taskId);

    /**
     * 获取指定任务的候选人
     *
     * @param delegateTask
     * @return
     */
    List<User> getCandidate(DelegateTask delegateTask);

    /**
     * 获取指定任务的办理人
     *
     * @param delegateTask
     * @return
     */
    User getAssignee(DelegateTask delegateTask);

    /**
     * 获取流程发起者
     *
     * @param processInstanceId
     * @return
     */
    User getCreator(String processInstanceId);

    /**
     * 启动流程
     *
     * @param processDefinitionId
     * @param startUser
     */
    void startProcessInstance(String processDefinitionId, String startUser);

    /**
     * 终止流程
     *
     * @param processInstanceId
     * @param reason
     */
    void terminateProcessInstance(String processInstanceId, String reason);

    /**
     * 获取节点配置
     *
     * @param taskId
     * @return
     */
    Map<String, Object> getTaskConfig(String taskId);

    /**
     * 获取可跳转节点ID
     *
     * @param processInstanceId
     * @param taskDefKey
     * @return
     */
    Map<String, String> getJumpToTasks(String processInstanceId, String taskDefKey);

    /**
     * 获取节点超时告警
     *
     * @param processInstanceId
     * @param taskDefKey
     * @return
     */
    List<DelayProperty> getTaskDelayProperty(String processInstanceId, String taskDefKey);

    /**
     * 获取待办任务
     *
     * @param loginUser
     * @return
     */
    List<Task> getClaimedTasks(String loginUser);

    void getFormProperties(List<FormProperty> formProperties, List<Map<String, Object>> properties);

    void findNextStep(Task task, Map<String, FlowNode> nextNodeMap, List<Map<String, Object>> nextSteps);

    void changeAssignee(Task task, String asignee) throws IOException;

    /**
     * 添加审批意见
     *
     * @param task
     * @param loginId   登陆id
     * @param comment   批注信息
     */
    public void addComment(Task task, String loginId, String comment);

    /**
     * 获取批注信息，入参是当前任务id，整个流程目前所有的批注信息
     *
     * @param taskId
     * @return
     */
    public List<Comment> findCommentByTaskId(String taskId);


    /**
     *获取当前任务完成之后的连线名称，如果连线没有名称，默认显示办理
     * @param taskId
     * @return
     */
    public List<String> findOutComeListByTaskId(String taskId);

    /**
     * 设置下一步任务的处理人
     * @param processInstanceId 流程实例Id
     * @param taskId 模型中任务的id
     * @param users 处理人list
     */
    public void setAssignee(String processInstanceId, String taskId, List<String> users);


    /**
     *根据taskDefKey、procDefId查询任务的签收时间
     * @param taskDefKey 流程如中用户任务id
     * @param procInstId  流程实例id
     */
    public Date findClaimDate(String taskDefKey, String procInstId);

    /**
     * 根据流程定义key，任务key查找到期时间表达式
     * @param procDefKey
     * @param taskDefKey
     * @return
     */
    public String findDueDateExpression(String procDefKey, String taskDefKey);

    /**
     * 自动签收
     * @param list
     * @param task
     * @return
     */
    public void autoClaim(List<User> list,Task task);
}
