package com.jshx.activiti.freeflow.command;

import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.runtime.AtomicOperation;
import org.apache.log4j.Logger;
import com.jshx.activiti.freeflow.FreeFlowService;

public class StartActivityCmd implements Command<java.lang.Void>
{
	private ActivityImpl activity;
	
	private String executionId;

	public StartActivityCmd(String executionId, ActivityImpl activity)
	{
		this.activity = activity;
		this.executionId = executionId;
	}

	@Override
	public Void execute(CommandContext commandContext)
	{
		//创建新任务
		Logger.getLogger(FreeFlowService.class).debug(
			String.format("executing activity: %s", activity.getId()));

		ExecutionEntity execution = commandContext.getExecutionEntityManager().findExecutionById(executionId);
		execution.setActivity(activity);
		execution.performOperation(AtomicOperation.ACTIVITY_START);
		return null;
	}
}