package com.jshx.activiti.freeflow.command;

import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.apache.log4j.Logger;
import com.jshx.activiti.freeflow.FreeFlowService;

public class DeleteHistoryTaskCmd implements Command<java.lang.Void>{

	private HistoricTaskInstance currentTaskEntity;

	public DeleteHistoryTaskCmd(HistoricTaskInstance currentTask)
	{
		this.currentTaskEntity = currentTask;
	}

	@Override
	public Void execute(CommandContext commandContext)
	{
		if (currentTaskEntity != null)
		{
			Logger.getLogger(FreeFlowService.class).debug(
				String.format("deleting task: %s [id=%s]", currentTaskEntity.getName(), currentTaskEntity.getId()));
			
			Context.getCommandContext().getHistoricTaskInstanceEntityManager()
					.deleteHistoricTaskInstanceById(currentTaskEntity.getId());						
		}

		return null;
	}
}
