/**
 * 
 */
package com.jshx.activiti.delay;

import java.text.MessageFormat;
import java.util.List;

import javax.naming.NamingException;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.cfg.MailServerInfo;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.HtmlEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jshx.activiti.service.ActivitiService;
import com.jshx.core.exception.BasalException;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.service.UserService;

/**
 * @author chensy
 * @version 2016年6月27日 下午4:33:45
 */
public class SendDelayWarningMail {
	
	protected ActivitiService activitiService;
	
	protected UserService userService;
	
	protected RuntimeService runtimeService;
	
	protected static final String CONTENT = "{0}提交了流程{1},需要您处理事项{2}，请您及时处理";
	
	protected static final String TITLE = "您有一项待办任务";
	
	private static final Logger sendDelayWarningLogger = LoggerFactory.getLogger(DelayReport.class);	
	
	public void sendMailToAssignee(Task currentTask){
		
		User user = activitiService.getCreator(currentTask.getProcessInstanceId());
		
		if(user==null || StringUtils.isEmpty(user.getEmail()))
            throw new BasalException(BasalException.ERROR, "未能找到流程启动者邮箱或丢失流程启动者信息");
		String from = user.getEmail();
        String sender = user.getDisplayName();
        
        StringBuilder sb = new StringBuilder();
        String asignee = currentTask.getAssignee();
        if(StringUtils.isNoneEmpty(asignee)){
            user = userService.findUserByLoginId(asignee);
            if(StringUtils.isNotEmpty(user.getEmail())){
                sb.append(user.getEmail()).append(",");
            }
        }
        
        String taskName = currentTask.getName();
        ExecutionEntity pi = (ExecutionEntity)runtimeService.createProcessInstanceQuery().processInstanceId(currentTask.getProcessInstanceId()).singleResult();
        String processName = pi.getProcessDefinition().getName();
        String content = MessageFormat.format(CONTENT, sender, processName, taskName);
        
        try{
            HtmlEmail email = new HtmlEmail();
            email.setTextMsg(content);
            email.setFrom(from);
            email.setSubject(TITLE);
            setMailServerProperties(email, currentTask.getTenantId());

            String[] tos = sb.toString().split(",");
            for(String to: tos){
                if(StringUtils.isNotEmpty(to))
                    email.addTo(to);
            }
            email.send();
        }catch(Exception e){
        	sendDelayWarningLogger.warn("发送邮件失败", e);
        }
	}
	
    protected void setMailServerProperties(Email email, String tenantId) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();

        boolean isMailServerSet = false;
        if (tenantId != null && tenantId.length() > 0) {
            if (processEngineConfiguration.getMailSessionJndi(tenantId) != null) {
                setEmailSession(email, processEngineConfiguration.getMailSessionJndi(tenantId));
                isMailServerSet = true;

            } else if (processEngineConfiguration.getMailServer(tenantId) != null) {
                MailServerInfo mailServerInfo = processEngineConfiguration.getMailServer(tenantId);
                String host = mailServerInfo.getMailServerHost();
                if (host == null) {
                    throw new ActivitiException("Could not send email: no SMTP host is configured for tenantId " + tenantId);
                }
                email.setHostName(host);

                email.setSmtpPort(mailServerInfo.getMailServerPort());

                email.setSSLOnConnect(mailServerInfo.isMailServerUseSSL());
                email.setStartTLSEnabled(mailServerInfo.isMailServerUseTLS());

                String user = mailServerInfo.getMailServerUsername();
                String password = mailServerInfo.getMailServerPassword();
                if (user != null && password != null) {
                    email.setAuthentication(user, password);
                }

                isMailServerSet = true;
            }
        }

        if (!isMailServerSet) {
            String mailSessionJndi = processEngineConfiguration.getMailSessionJndi();
            if (mailSessionJndi != null) {
                setEmailSession(email, mailSessionJndi);

            } else {
                String host = processEngineConfiguration.getMailServerHost();
                if (host == null) {
                    throw new ActivitiException("Could not send email: no SMTP host is configured");
                }
                email.setHostName(host);

                int port = processEngineConfiguration.getMailServerPort();
                email.setSmtpPort(port);

                email.setSSLOnConnect(processEngineConfiguration.getMailServerUseSSL());
                email.setStartTLSEnabled(processEngineConfiguration.getMailServerUseTLS());

                String user = processEngineConfiguration.getMailServerUsername();
                String password = processEngineConfiguration.getMailServerPassword();
                if (user != null && password != null) {
                    email.setAuthentication(user, password);
                }
            }
        }
    }

    protected void setEmailSession(Email email, String mailSessionJndi) {
        try {
            email.setMailSessionFromJNDI(mailSessionJndi);
        } catch (NamingException e) {
            throw new ActivitiException("Could not send email: Incorrect JNDI configuration", e);
        }
    }

}
