/*
 * Activiti Modeler component part of the Activiti project
 * Copyright 2005-2014 Alfresco Software, Ltd. All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * Assignment
 */
var KisBpmAssignmentCtrl = [ '$scope', '$modal', function($scope, $modal) {

    // Config for the modal window
    var opts = {
    	backdrop: 'static',   
        template:  'editor-app/configuration/properties/assignment-popup.html?version=' + Date.now(),
        scope: $scope
    };

    // Open the dialog
    $modal(opts);
}];

var KisBpmAssignmentPopupCtrl = [ '$scope', '$rootScope', '$modal',function($scope, $rootScope,$modal) {
    	
    // Put json representing assignment on scope
	var AssignmentCopy = new Object();	
    if ($scope.property.value !== undefined && $scope.property.value !== null
        && $scope.property.value.assignment !== undefined
        && $scope.property.value.assignment !== null) 
    {
        $scope.assignment = $scope.property.value.assignment;
        
        AssignmentCopy.assignee = $scope.property.value.assignment.assignee;
        if($scope.property.value.assignment.candidateUsers !== undefined && $scope.property.value.assignment.candidateUsers !== null){
        	AssignmentCopy.candidateUsers = $scope.property.value.assignment.candidateUsers.concat();
        }
        if($scope.property.value.assignment.candidateGroups !== undefined && $scope.property.value.assignment.candidateGroups !== null){
        	AssignmentCopy.candidateGroups = $scope.property.value.assignment.candidateGroups.concat();
        }

    } else {
        $scope.assignment = {};
        assignmentCopy = {};
    }

    if ($scope.assignment.candidateUsers == undefined || $scope.assignment.candidateUsers.length == 0)
    {
    	$scope.assignment.candidateUsers = [{value: ''}];
    }
    
    // Click handler for + button after enum value
    var userValueIndex = 1;
    var candidateUserNumb = $scope.assignment.candidateUsers.length;
    $scope.addCandidateUserValue = function(index) {
        $scope.assignment.candidateUsers.splice(index + 1, 0, {value: 'value ' + userValueIndex++});
        candidateUserNumb++;
    };

    // Click handler for - button after enum value
    $scope.removeCandidateUserValue = function(index) {
    	if(candidateUserNumb === 1){
    		$scope.assignment.candidateUsers = [{value: ''}];
    	}else{
    		$scope.assignment.candidateUsers.splice(index, 1);
    		candidateUserNumb--;
    	}
    };
    
    if ($scope.assignment.candidateGroups == undefined || $scope.assignment.candidateGroups.length == 0)
    {
    	$scope.assignment.candidateGroups = [{value: ''}];
    }
    
    var groupValueIndex = 1;
    var candidateGroupNumb = $scope.assignment.candidateGroups.length;
    $scope.addCandidateGroupValue = function(index) {
        $scope.assignment.candidateGroups.splice(index + 1, 0, {value: 'value ' + groupValueIndex++});
        candidateGroupNumb++;
    };

    // Click handler for - button after enum value
    $scope.removeCandidateGroupValue = function(index) {
    	if(candidateGroupNumb === 1){
    		$scope.assignment.candidateGroups = [{value: ''}];
    	}else{
    		$scope.assignment.candidateGroups.splice(index, 1);
    		candidateGroupNumb--;
    	}
       // $scope.assignment.candidateGroups.splice(index, 1);
    };

	//查找角色
	$scope.searchGroup = function(target){
		$scope.currTarget = target;

		var opts = {
			template:  'editor-app/configuration/properties/assignment-group-popup.html?version=' + Date.now(),
			scope: $scope,
			container: "#assignmentPopup"
		};

		// Open the dialog
		$scope.groupModal = $modal(opts);
	}

    $scope.save = function() {

        $scope.property.value = {};
        handleAssignmentInput($scope);
        $scope.assignment.assignee = jQuery("#assigneeField").val();
        $scope.property.value.assignment = $scope.assignment;
        $scope.property.value.taskListeners = $scope.taskListeners;

        $scope.updatePropertyInModel($scope.property);
		$scope.selectedShape.refresh();

		if(!$scope.assignment.candidateGroups){//若candidateGroups为空或者长度为1但内容为空，则删除相应的taskListener
			handleUselessListener($scope);
		}else if($scope.assignment.candidateGroups.length === 1 && ($scope.assignment.candidateGroups[0].value === "" || $scope.assignment.candidateGroups[0].value=== undefined) ){
			handleUselessListener($scope);
		}
    	$scope.property.mode = 'read';
    	$scope.$hide();
    };

    // Close button handler
    $scope.close = function() {
    	$scope.property.value = {};
    	$scope.property.value.assignment = AssignmentCopy;
    	$scope.property.value.taskListeners = $scope.taskListeners;
        $scope.updatePropertyInModel($scope.property);
		$scope.selectedShape.refresh();
    	
    	handleAssignmentInput($scope);
    	
    	if(!AssignmentCopy.candidateGroups){//如果candidateGroups为空，则将本次修改引入的taskListener删除，否则不做处理
    		handleUselessListener($scope);
    	}
   	
    	$scope.property.mode = 'read';
    	$scope.$hide();
    };
    
    var handleUselessListener = function($scope){
        if(!$scope.selectedShape.properties["oryx-tasklisteners"]){
            $scope.selectedShape.properties["oryx-tasklisteners"] = {};
            $scope.selectedShape.properties["oryx-tasklisteners"].taskListeners = [];
        }
        $scope.taskListeners = $scope.selectedShape.properties["oryx-tasklisteners"].taskListeners;
        if(!$scope.taskListeners){
            $scope.taskListeners = {};
        }
        var len = $scope.taskListeners.length;
        for(var j = 0; j < len; j++){
            var taskListener = $scope.taskListeners[j];
            if(taskListener.className===$rootScope.config.DEFAULT_ASSIGN_LISTENER){
            	$scope.taskListeners.splice(j,1);
                break;
            }
        }
    };
    
    var handleAssignmentInput = function($scope) {
    	var len = jQuery("input[name='userFieldProperty']").length;
    	var candidateUsersArray = new Array(len);
    	for(var i = 0; i < len; i++){
    		candidateUsersArray[i] =  jQuery("input[name='userFieldProperty']")[i].value;
    	}
    	
    	var group_len = jQuery("input[name='groupFieldProperty']").length;
    	var candidateGroupsArray = new Array(group_len);
    	for(var i = 0; i < group_len; i++){
    		candidateGroupsArray[i] =  jQuery("input[name='groupFieldProperty']")[i].value;
    	}
    	
    	if ($scope.assignment.candidateUsers)
    	{
	    	var emptyUsers = true;
	    	var toRemoveIndexes = [];
	        for (var i = 0; i < $scope.assignment.candidateUsers.length; i++)
	        {
	        	if ($scope.assignment.candidateUsers[i].value != '')
	        	{
	        		emptyUsers = false;
	        		$scope.assignment.candidateUsers[i].value = candidateUsersArray[i];
	        	}
	        	else
	        	{
	        		toRemoveIndexes[toRemoveIndexes.length] = i;
	        	}
	        }
	        
	        for (var i = 0; i < toRemoveIndexes.length; i++)
	        {
	        	$scope.assignment.candidateUsers.splice(toRemoveIndexes[i], 1);
	        }
	        
	        if (emptyUsers)
	        {
	        	$scope.assignment.candidateUsers = undefined;
	        }
    	}
        
    	if ($scope.assignment.candidateGroups)
    	{
	        var emptyGroups = true;
	        var toRemoveIndexes = [];
	        for (var i = 0; i < $scope.assignment.candidateGroups.length; i++)
	        {
	        	if ($scope.assignment.candidateGroups[i].value != '')
	        	{
	        		emptyGroups = false;
	        		$scope.assignment.candidateGroups[i].value = candidateGroupsArray[i];
	        	}
	        	else
	        	{
	        		toRemoveIndexes[toRemoveIndexes.length] = i;
	        	}
	        }
	        
	        for (var i = 0; i < toRemoveIndexes.length; i++)
	        {
	        	$scope.assignment.candidateGroups.splice(toRemoveIndexes[i], 1);
	        }
	        
	        if (emptyGroups)
	        {
	        	$scope.assignment.candidateGroups = undefined;
	        }
    	}
    };
}];