var KisBpmFreeflowGroupPopupCtrl = [ '$scope', '$http', '$rootScope', '$alert', function($scope, $http, $rootScope, $alert) {

    $scope.roles = [];
    $scope.depts = [];
    $scope.group = {};

    $scope.getRoles = function(){
        $http({
            url: $rootScope.config.roleUrl,
            method: 'post',
            params : {
                selNode: $scope.roleId
            }
        }).success(function(data){
            if(!$scope.roleId){
                $scope.roles = data;
            }

            else{
                $scope.roleNode.children = data;
            }
        });
    };

    $scope.getDepts = function(){
        $http({
            url: $rootScope.config.deptUrl,
            method: 'post',
            params : {
                selDept: $scope.deptId
            }
        }).success(function(data){
            if(!$scope.deptId)
                $scope.depts = data;
            else{
                $scope.deptNode.children = data;
            }
        });
    };


    $scope.getRoles();
    $scope.getDepts();

    $scope.checkRole = function(role){
        $scope.group.role = role;
    }

    $scope.checkDept = function(dept){
        $scope.group.dept = dept;
    }

    $scope.toggleRole = function (scope, node) {
        $scope.roleId = node.id;
        $scope.roleNode = node;
        if(node.text!=="角色" && !node.children)
            $scope.getRoles();
        scope.toggle();
    };

    $scope.toggleDept = function (scope, node) {
        $scope.deptId = node.id;
        $scope.deptNode = node;
        if(node.text!=="组织机构" && !node.children)
            $scope.getDepts();
        scope.toggle();
    };

    $scope.save = function() {

        if(!$scope.group.role){

            $alert({
                "title": "提示",
                "content": "请选择角色",
                "duration": 3,
                "type": "alert",
                container: "#candidateGroupPopup"
            });
            return false;
        }

        $scope.currTarget.value = $scope.group.role;
        if($scope.group.dept){
            $scope.currTarget.value = $scope.group.dept + "|" + $scope.currTarget.value;
        }
        $scope.selectedProperties[0].group = $scope.currTarget.value;

        $scope.closeGroup();
    }

    $scope.closeGroup = function() {
        $scope.roleId = null;
        $scope.roleNode = null;

        var length = jQuery(".modal-backdrop").length;
        for(var i = 1; i < length; i++){
            jQuery(jQuery(".modal-backdrop")[i]).remove();
        }
        jQuery("#role_nodes_renderer.html").remove();
        jQuery("#dept_nodes_renderer.html").remove();
        jQuery("#candidateGroupPopup").remove();

    };
}];