<%@page language="java" pageEncoding="UTF-8" %>
<%@include file="/common/header.jsp" %>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>项目退件</title>
    <%@include file="/common/jsLib.jsp" %>
    <script type="text/javascript">
        var freeFlowData = null;

        $(function () {
            $('#deptTree').tree({
                url: 'findChildDept.action',
                onBeforeExpand: function (node) {
                    $('#deptTree').tree('options').url = "findChildDept.action?selDept=" + node.id;
                },
                onClick: function (node) {
                    if (node.attributes == "last") { //判断是否为叶节点
                        $('#inputStr').val(node.text);
                        $('#inputUserId').val(node.id);
                        $('#inputPhoneNum').val(node.phoneNum);
                    }
                    else {
                        $(this).tree(node.state == 'closed' ? 'expand' : 'collapse', node.target);
                    }
                },
                onDblClick: function (node) {
                    $(this).tree(node.state == 'closed' ? 'expand' : 'collapse', node.target);
                }

            });
        });

        function reloadDate() {
            doQuery();
        }
        
        function hold(id,businessKey,type)
        {
        	$("#holdComment").val("");
        	$("#win_hold").window("open");
        }
        
        function holdProject() {
        	if($("#holdComment").val().length>200){
        		$.messager.alert('提示', '挂起原因200字以内！');
        		return;
        	}
        	var row = $('#pagination').datagrid('getSelected'); 
        	$.messager.confirm('申请挂起', '确定要申请挂起？', function (result) {
                if (result) {
                    $.ajax({
                        url: "terminateProcessApply.action",
                        type: 'post',
                        dataType: 'json',
                        async: false,
                        data: {
                        	"processInstanceId": row.id,
                            "xmbzj": row.businessKey,
                            "comment": $("#holdComment").val(),
                            "type": 1
                        },
                        error: function () {
                            $.messager.alert('错误', '申请挂起出错！');
                        },
                        success: function (data) {
                            if (data.result) {
                                $.messager.alert('提示', '申请挂起成功！', 'info', function () {
                                	$("#win_hold").window("close");
                                	doQuery();
                                });
                            } else {
                                $.messager.alert('错误', '申请挂起出错！');
                            }
                        }
                    });
                }
            });
        }
        
        function disable(id,businessKey,type)
        {
        	$("#disableComment").val("");
        	$("#win_disable").window("open");
        }
        
        function disableProject() {
        	if($("#disableComment").val().length>200){
        		$.messager.alert('提示', '作废原因200字以内！');
        		return;
        	}
        	var row = $('#pagination').datagrid('getSelected'); 
        	$.messager.confirm('申请作废', '确定要申请作废？', function (result) {
                if (result) {
                    $.ajax({
                        url: "terminateProcessApply.action",
                        type: 'post',
                        dataType: 'json',
                        async: false,
                        data: {
                        	"processInstanceId":row.id,
                            "xmbzj": row.businessKey,
                            "comment": $("#disableComment").val(),
                            "type":2
                        },
                        error: function () {
                            $.messager.alert('错误', '申请作废出错！');
                        },
                        success: function (data) {
                            if (data.result) {
                                $.messager.alert('提示', '申请作废成功！', 'info', function () {
                                	$("#win_disable").window("close");
                                	doQuery();
                                });
                            } else {
                                $.messager.alert('错误', '申请作废出错！');
                            }
                        }
                    });
                }
            });
        }
        
        function doQuery() {
            var queryParams = {
                "xmxxb.slbh": $("#slbh").val(),
                "xmxxb.xxylb": $("#xxylb").val(),
                "xmxxb.jsdw": $("#jsdw").val(),
                "xmxxb.xmmc": $("#xmmc").val()
            };
            $('#pagination').datagrid('options').queryParams = queryParams;
            $('#pagination').datagrid('clearSelections');
            $("#pagination").datagrid('load');
        }

        function view(row_Id){
        	var dt=new Date();
            createSimpleWindow("win_xmxxb","查看项目信息表","${ctx}/jsp/xmxxb/xmxxbView.action?xmxxb.id="+row_Id+"&dt="+dt.getTime(),800,500);
        	
        }

        $(function () {
            $('#pagination').datagrid($.extend(dg_cm_pp_3, {
                title: '项目列表',
                url: 'findRunningProcessForZslc.action',
                queryParams:{
                	"xmxxb.slbh": $("#slbh").val(),
                    "xmxxb.xxylb": $("#xxylb").val(),
                    "xmxxb.jsdw": $("#jsdw").val(),
                    "xmxxb.xmmc": $("#xmmc").val()
				},
                singleSelect:true,
                columns: [[
					{field: 'op', title: '操作', width: fixWidth(0.15), formatter: function (value, rec) {
					    var showhistory = "<a href='#' class='btn_01_mini' onclick=\"viewHistory('" + rec.id + "')\">历史任务<b></b></a>&nbsp;"
					    if ("admin"!="${curr_user.loginId}" && null == rec.returnStatus)
					        return "<a href='#' class='btn_01_mini' onclick=\"hold()\">挂起<b></b></a>&nbsp;<a href='#' class='btn_01_mini' onclick=\"disable()\">作废<b></b></a>&nbsp;" + showhistory;
					    else
					        return showhistory;
					}},
                    {field: 'slbh', title: '受理编号', width: fixWidth(0.15), formatter: function (value, rec){
                    	return "<a href='#' onclick=\"view('" + rec.businessKey + "')\"><font style='color:blue'>"+value+"</font></a>";
                    }},
                    {field: 'xxylb', title: '信息一览表编号', width: fixWidth(0.15)},
                    {field: 'jsdw', title: '建设单位名称', width: fixWidth(0.25)},
                    {field: 'projectName', title: '工程项目名称', width: fixWidth(0.25)}
                ]]
            }));
        });

        function viewHistory(processInstanceId) {
            createSimpleWindow("taskHistory","查看历史任务","${ctx}/jsp/activiti/initViewHistory.action?processInstanceId="+processInstanceId, 800, 400);
        }

        function showOperLog(processInstanceId){
            createSimpleWindow("operLog","查看操作日志","${ctx}/jsp/activitoperlog/activitiOperLogList.action?processInstanceId="+processInstanceId, 800, 400);
        }
    </script>
</head>

<body>
<div class="page_content">
    <div class="box_01 submitdata">
        <div class="inner12px">
            <form name="myform" method="post">
                <div class="cell boxBmargin12">
                    <table>
                    	<tr>
							<th width="15%">受理编号</th>
							<td width="35%"><input name="xmxxb.slbh" id="slbh" type="text"></td>
							<th width="15%">信息一览表编号</th>
							<td width="35%"><input name="xmxxb.xxylb" id="xxylb" type="text"></td>
						</tr>
						<tr>
							<th width="15%">建筑单位名称</th>
							<td width="35%"><input name="xmxxb.jsdw" id="jsdw" type="text"></td>
							<th width="15%">工程项目名称</th>
							<td width="35%"><input name="xmxxb.xmmc" id="xmmc" type="text"></td>
						</tr>
                        <tr>
                            <td colspan="4">
                                <div class="btn_area_setc">
                                    <a href="###" class="btn_01" onclick="doQuery()">查询<b></b></a>
                                    <a href="###" class="btn_01" onclick="clear_form(document.myform);">清空<b></b></a>
                                </div>
                            </td>
                        </tr>
                    </table>
                </div>
            </form>
            <div id="pagination"></div>
        </div>
    </div>
</div>
<div id="win_hold" class="easyui-window" closed="true" modal="true" title="挂起申请" style="width:500px;height:300px;top:20%">  
    <div class="inner6px">
        <div class="cell">
            <div style="padding-top: 3%">
               	<table width="100%">
	               	<tr>
	               		<th width="15%">挂起原因</th>
	               		<td width="85%" align="center">
	               			<textarea id ="holdComment" placeholder="请填入挂起原因,200字以内" style="width: 90%;height:150px"></textarea>
	               		</td>
	               	</tr>
                    <tr>
                       <td colspan="2" height="100px" style="text-align:center">
                       	  	<a href="javascript:void(0);" class="btn_01" onclick="holdProject()">提交<b></b></a>&nbsp;
					   </td>
                    </tr>
               </table>
            </div>
	    </div>
	</div> 
</div>
<div id="win_disable" class="easyui-window" closed="true" modal="true" title="作废申请" style="width:500px;height:300px;top:20%">  
    <div class="inner6px">
        <div class="cell">
            <div style="padding-top: 3%">
               	<table width="100%">
	               	<tr>
	               		<th width="15%">作废原因</th>
	               		<td width="85%" align="center">
	               			<textarea id ="disableComment" placeholder="请填入作废原因,200字以内" style="width: 90%;height:150px"></textarea>
	               		</td>
	               	</tr>
                    <tr>
                       <td colspan="2" height="100px" style="text-align:center">
                       	  	<a href="javascript:void(0);" class="btn_01" onclick="disableProject()">提交<b></b></a>&nbsp;
					   </td>
                    </tr>
               </table>
            </div>
	    </div>
	</div> 
</div> 
</body>
</html>
