<%@page language="java" pageEncoding="UTF-8" isELIgnored="false" %>
<%@include file="/common/header.jsp" %>
<%@taglib prefix="activiti" uri="/activiti/tags" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <title>南京征收管理系统</title>
    <%@include file="/common/jsLib.jsp" %>
    <script>
        $(function () {
            window.top["Refresh_CloudHomePage_Content"] = function () {
                window.location.reload();
            }
        })

        function reloadDate() {
            $('#pagination').datagrid('clearSelections');
            search_xmlb();
        }

        // 查看
        function view(row_Id) {
            var dt = new Date();
            createSimpleWindow("win_zzhxm", "查看详细信息", "/jsp/rfdz/RfdzView.action?zzhxm.id=" + row_Id + "&dt=" + dt.getTime(), 850, 700);
        }
        function view_detail(row_Id) {
            var dt = new Date();
            // parent.addTab("sfxxTab", "收费信息", "收费信息.html?zzhxm.id=" + row_Id + "&dt=" + dt.getTime(), 850, 700);
            parent.addTab("rfdzTab","收费信息","/jsp/rfdz/RfdzSfxxDetail.action?paymentItem.id="+row_Id+"&dt="+dt.getTime(),850,700);
        }
        function search_xmlb() {
            var queryParams = {
                "ghxkzbh": $("#ghxkzbh").val(),
                "jfpzbh": $("#jfpzbh").val(),
                "xxbbh": $("#xxbbh").val(),
                "ghxmbh": $("#ghxmbh").val(),
                "jsdwmc": $("#jsdwmc").val(),
                "gcxmmc": $("#gcxmmc").val(),
                "jfhj": $("#jfhj").val(),
                "hczt": $("#hczt").val()
            };
            console.info(queryParams);
            $('#pagination').datagrid('options').queryParams = queryParams;
            $('#pagination').datagrid('clearSelections');
            $("#pagination").datagrid('load');
        }

        $(function () {
            $('#pagination').datagrid($.extend(window.dg_cm_pp_2, {
                title: '人防费核查项目列表',
                url: 'rflist.action',
                queryParams: {
                    "ghxkzbh": $("#ghxkzbh").val(),
                    "jfpzbh": $("#jfpzbh").val(),
                    "xxbbh": $("#xxbbh").val(),
                    "ghxmbh": $("#ghxmbh").val(),
                    "jsdwmc": $("#jsdwmc").val(),
                    "gcxmmc": $("#gcxmmc").val(),
                    "jfhj": $("#jfhj").val(),
                    "hczt": $("#hczt").val()
                },
                frozenColumns: [[
                    // 				    {field:'id',checkbox:true}
                ]],
                striped: true,
                columns: [[
                    {
                        field: 'op', title: '操作', width: 100, align: 'center', formatter: function (value, rec) {
                            return "<a class='btn_01_mini' onclick=view('"+rec.id+"') >查看<b></b></a>"
                        }
                    },
                    {
                        field: 'op1', title: '关联操作', width: 130, align: 'center', formatter: function (value, rec) {
                            return "<a class='btn_01_mini' onclick=view_detail('" + rec.id + "') >收费信息<b></b></a>";
                        }
                    },

                    { field: 'dwmc', title: '建设单位名称', width: 186, align: 'center' },
                    { field: 'xmmc', title: '工程项目名称', width: 186, align: 'center' },
                    {
                        field: 'op2', title: '工程项目地点', width: 186, align: 'center', formatter: function (value, rec) {
                            return "<span>" + rec.xmxxb.jzdwdz + "</span>";
                        }
                    },

                    {
                        field: 'op3', title: '规划许可证号', width: 186, align: 'center', formatter: function (value, rec) {
                            return "<span>" + rec.xmxxb.xkzh + "</span>";
                        }
                    },

                    {
                        field: 'op4', title: '缴费环节', width: 150, align: 'center', formatter: function (value, rec) {
                            if(rec.xmxxb.paymentLink == 1) {
                                return "<span>施工许可前</span>";
                            } else if(rec.xmxxb.paymentLink == 3) {
                                return "<span>30日内</span>";
                            }
                            return "<span></span>";

                        }
                    },
                    {
                        field: 'op5', title: '二级统计单位', width: 186, align: 'center', formatter: function (value, rec) {
                            return "<span>" + rec.xmxxb.zsfw + "</span>";
                        }
                    },
                    { field: 'xmdm', title: '核查状态', width: 150, align: 'center' },
                    { field: 'ECN', title: '缴款通知书编号', width: 186, align: 'center' },
                    { field: 'zslxdbh', title: '缴款凭证编号', width: 186, align: 'center' },

                ]],

            }));
        });


    </script>
</head>

<body>
    <div class="page_content">
        <div class="box_01 submitdata">
            <div class="inner12px">
                <div class="cell boxBmargin12">
                    <table width="100%">
                        <tr>
                            <th width="15%">规划许可证编号</th>
                            <td width="35%"><input name="ghxkzbh" id="ghxkzbh" value="" type="text"></td>
                            <th width="15%">缴费凭证编号</th>
                            <td width="35%"><input name="jfpzbh" id="jfpzbh" value="" type="text"></td>
                        </tr>
                        <tr>
                            <th width="15%">信息表编号</th>
                            <td width="35%"><input name="xxbbh" id="xxbbh" value="" type="text"></td>
                            <th width="15%">规划项目编号</th>
                            <td width="35%"><input name="ghxmbh" id="ghxmbh" value="" type="text"></td>
                        </tr>
                        <tr>
                            <th width="15%">建设单位名称</th>
                            <td width="35%"><input name="jsdwmc" id="jsdwmc" value="" type="text"></td>
                            <th width="15%">工程项目名称</th>
                            <td width="35%"><input name="gcxmmc" id="gcxmmc" value="" type="text"></td>
                        </tr>
                        <tr>
                            <th width="15%">缴费环节</th>
                            <td width="35%">
                                <select name="jfhj" id="jfhj">
                                    <option value="">请选择</option>
                                    <option value="0">无</option>
                                    <option value="1">施工许可前</option>
                                    <option value="3">30日</option>
                                </select>
                            </td>
                            <th width="15%">核查状态</th>
                            <td width="35%">
                                <select name="hczt" id="hczt">
                                    <option value="">请选择</option>
                                    <option value="0">无</option>
                                    <option value="1">已同步</option>
                                    <option value="2">未同步</option>
                                </select>
                            </td>
                        </tr>
                        <!-- <%-- <tr>
                            <th width="15%">子账户状态</th>
                            <td width="35%">
                                <select name="zzhxm.accountStatus" id="accountStatus">
                                    <option value="">请选择</option>
                                    <option value="0">未激活</option>
                                    <option value="1">已激活</option>
                                    <option value="2">已作废</option>
                                    <option value="3">已到账</option>
                                    <option value="4">已缴销</option>
                                </select>
                            </td>
                            </tr>--%> -->
                        <tr>
                            <td colspan="4" align="center">
                                <a href="###" class="btn_01" onclick="search_xmlb()">查询<b></b></a>&nbsp;
                                <!-- 						<a href="###" class="btn_01" onclick="search_sdjd(1)" >已复核项目<b></b></a>&nbsp; -->
                                <a href="###" class="btn_01" onclick="clear_form(document.myform);">清空<b></b></a>&nbsp;
                            </td>
                        </tr>
                    </table>
                </div>

                <div id="pagination">
                </div>
            </div>
        </div>
    </div>
</body>

</html>