/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import com.informix.util.IfxErrMsg;
import java.sql.SQLException;

public abstract class Interval {
    public static final byte TU_YEAR = 0;
    public static final byte TU_MONTH = 2;
    public static final byte TU_DAY = 4;
    public static final byte TU_HOUR = 6;
    public static final byte TU_MINUTE = 8;
    public static final byte TU_SECOND = 10;
    public static final byte TU_FRAC = 12;
    public static final byte TU_F1 = 11;
    public static final byte TU_F2 = 12;
    public static final byte TU_F3 = 13;
    public static final byte TU_F4 = 14;
    public static final byte TU_F5 = 15;
    protected static final int DECSIZE = 16;
    protected static final int NUMBER_UNITS = 7;
    protected static final int YEAR_IDX = 0;
    protected static final int MONTH_IDX = 1;
    protected static final int DAY_IDX = 2;
    protected static final int HOUR_IDX = 3;
    protected static final int MIN_IDX = 4;
    protected static final int SEC_IDX = 5;
    protected static final int FRAC_IDX = 6;
    protected static final char[] dtdelim = new char[]{'-', '-', ' ', ':', ':', '.', ' '};
    protected static final boolean DEBUG = true;
    protected static boolean debugFlag;
    protected short int_qual;

    protected Interval() throws SQLException {
    }

    public static byte getLength(short s) {
        return (byte)(s >> 8);
    }

    protected byte getLength() {
        short s = this.int_qual;
        return (byte)(s >> 8);
    }

    public short getQualifier() {
        return this.int_qual;
    }

    public static short getQualifier(byte by, byte by2, byte by3) throws SQLException {
        Interval.goodQualifier(by, by2, by3);
        byte by4 = (byte)(by3 - by2 + by);
        short s = (short)(by4 << 8 | by2 << 4 | by3);
        return s;
    }

    protected short getQualifier(byte by, byte by2) throws SQLException {
        this.goodQualifier(by, by2);
        short s = (short)(by2 - by + (by == 0 ? 4 : 2));
        short s2 = (short)((byte)s << 8 | by << 4 | by2);
        return s2;
    }

    public static void goodQualifier(byte by, byte by2, byte by3) throws SQLException {
        if (by < 0 || by > 9) {
            throw IfxErrMsg.getSQLException(-79717, null);
        }
        if (by2 < 0 || by2 > 15) {
            throw IfxErrMsg.getSQLException(-79718, null);
        }
        if (by3 < 0 || by3 > 15) {
            throw IfxErrMsg.getSQLException(-79719, null);
        }
    }

    protected boolean goodQualifier(byte by, byte by2) throws SQLException {
        if (by > by2) {
            throw IfxErrMsg.getSQLException(-79720, null);
        }
        if (by < 0 || by > 15) {
            throw IfxErrMsg.getSQLException(-79718, null);
        }
        if (by2 < 0 || by2 > 15) {
            throw IfxErrMsg.getSQLException(-79719, null);
        }
        return true;
    }

    public static byte getScale(short s) {
        byte by = Interval.getEndCode(s);
        byte by2 = 0;
        if (by > 10) {
            by2 = (byte)(by - 10);
        }
        return by2;
    }

    public static byte getStartCode(short s) {
        byte by = (byte)(s >> 4 & 0xF);
        return by;
    }

    public static byte getEndCode(short s) {
        byte by = (byte)(s & 0xF);
        return by;
    }

    public byte getStartCode() {
        return Interval.getStartCode(this.int_qual);
    }

    public byte getEndCode() {
        return Interval.getEndCode(this.int_qual);
    }

    protected byte getFirstLength(short s) {
        int n = (byte)(s >> 8) - (Interval.getEndCode(s) - Interval.getStartCode(s));
        byte by = (byte)n;
        return by;
    }

    public static byte getStaticStartCode(short s) {
        byte by = (byte)(s >> 4 & 0xF);
        return by;
    }

    public static byte getStaticEndCode(short s) {
        byte by = (byte)(s & 0xF);
        return by;
    }

    public static String getFieldName(byte by) {
        switch (by) {
            case 0: {
                return "year";
            }
            case 2: {
                return "month";
            }
            case 4: {
                return "day";
            }
            case 6: {
                return "hour";
            }
            case 8: {
                return "minute";
            }
            case 10: {
                return "second";
            }
            case 11: {
                return "fraction(1)";
            }
            case 12: {
                return "fraction(2)";
            }
            case 13: {
                return "fraction(3)";
            }
            case 14: {
                return "fraction(4)";
            }
            case 15: {
                return "fraction(5)";
            }
        }
        return "";
    }

    public static String getIfxTypeName(int n, short s) {
        String string = null;
        if (n == 14) {
            string = "interval ";
        } else if (n == 10) {
            string = "datetime ";
        } else {
            return null;
        }
        string = String.valueOf(string) + Interval.getFieldName(Interval.getStaticStartCode(s)) + " to " + Interval.getFieldName(Interval.getStaticEndCode(s));
        return string;
    }

    protected int[] stringToUnits(String string, short s) throws SQLException {
        int[] nArray = new int[7];
        int n = 0;
        while (n < 7) {
            nArray[n] = 0;
            ++n;
        }
        byte by = Interval.getEndCode(s);
        byte by2 = Interval.getStartCode(s);
        byte by3 = this.getFirstLength(s);
        string = string.trim();
        int n2 = 0;
        if (string.length() == 0) {
            return nArray;
        }
        String string2 = "str --" + string + "--";
        if (debugFlag) {
            System.out.println(string2);
        }
        string2 = "startCode " + by2 + " endCode " + by + " qual " + Integer.toString(s, 16);
        if (debugFlag) {
            System.out.println(string2);
        }
        try {
            if (by2 == 12) {
                if (string.charAt(n2) == '0') {
                    ++n2;
                }
                if (string.charAt(n2) != '.') {
                    throw IfxErrMsg.getSQLMinorException(-79721, -80000, null);
                }
                ++n2;
            } else {
                int n3 = 0;
                while (n3 < string.length()) {
                    if (!Character.isDigit(string.charAt(n2 + n3))) break;
                    n3 = (byte)(n3 + 1);
                }
                String string3 = "fwidth " + by3 + " numDigits " + n3;
                if (debugFlag) {
                    System.out.println(string3);
                }
                if (n3 == 0) {
                    throw IfxErrMsg.getSQLMinorException(-79721, -80001, null);
                }
                if (n3 > by3) {
                    throw IfxErrMsg.getSQLMinorException(-79721, -80002, null);
                }
                nArray[by2 / 2] = Integer.parseInt(string.substring(n2, n2 + n3));
                string3 = "data[" + by2 / 2 + "]: " + nArray[by2 / 2];
                if (debugFlag) {
                    System.out.println(string3);
                }
                n2 += n3 + 1;
                by2 = (byte)(by2 + 2);
            }
            while (by2 <= by && by2 <= 10) {
                int n4 = n2;
                int n5 = n2 + 1;
                if (!Character.isDigit(string.charAt(n2)) && string.charAt(n2) != ' ') {
                    throw IfxErrMsg.getSQLMinorException(-79722, -80003, Integer.toString(n2), null);
                }
                if (n5 < string.length() && Character.isDigit(string.charAt(n5))) {
                    n4 = n5++;
                }
                nArray[by2 / 2] = Integer.parseInt(string.substring(n2, n4 + 1));
                String string4 = "data[" + by2 / 2 + "]: " + nArray[by2 / 2];
                if (debugFlag) {
                    System.out.println(string4);
                }
                string4 = "strIdx " + n2 + " endIdx " + n4 + " idx " + n5;
                if (debugFlag) {
                    System.out.println(string4);
                }
                if (n5 < string.length() && string.charAt(n5) != dtdelim[by2 / 2]) {
                    if (by2 == by) break;
                    string4 = "startCode " + by2 + " idx " + n5;
                    if (debugFlag) {
                        System.out.println(string4);
                    }
                    throw IfxErrMsg.getSQLMinorException(-79723, -80003, Integer.toString(n5), null);
                }
                n2 = n5 + 1;
                by2 = (byte)(by2 + 2);
            }
            if (n2 < string.length()) {
                String string5 = "fraction part if any :" + string.substring(n2) + ":";
                if (debugFlag) {
                    System.out.println(string5);
                }
                int n6 = n2 - 1;
                int n7 = n2;
                by2 = 11;
                int n8 = 0;
                while (n7 < string.length() && by2 <= by) {
                    if (!Character.isDigit(string.charAt(n7))) break;
                    ++n6;
                    ++n7;
                    by2 = (byte)(by2 + 1);
                    ++n8;
                }
                if (n6 >= n2) {
                    int n9 = Integer.parseInt(string.substring(n2, n6 + 1));
                    int n10 = 9 - n8;
                    int n11 = 0;
                    while (n11 < n10) {
                        n9 *= 10;
                        ++n11;
                    }
                    nArray[6] = n9;
                }
                n2 = n7;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw IfxErrMsg.getSQLException(-79724, null);
        }
        if (n2 < string.length()) {
            throw IfxErrMsg.getSQLException(-79725, string.substring(n2), null);
        }
        return nArray;
    }

    protected static void print(String string) {
        if (debugFlag) {
            System.out.print(string);
        }
    }

    protected static void println(String string) {
        if (debugFlag) {
            System.out.println(string);
        }
    }
}

