/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import com.informix.lang.Decimal;
import com.informix.lang.Interval;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;

public final class IfxToJavaType {
    public static final int DAYS1900 = 693594;
    public static final int DAYS4CENT = 146097;
    public static final int DAYS4YEAR = 1461;
    public static byte[] daymon = new byte[13];
    private static Calendar Cal;

    public static String IfxToJavaChar(byte[] byArray, short s) {
        String string = new String(byArray);
        return string;
    }

    public static String IfxToJavaChar(byte[] byArray, short s, String string) throws IOException {
        String string2 = null;
        string2 = string != null ? new String(byArray, string == "ISO2022CN_GB" ? "ISO2022CN" : string) : new String(byArray);
        return string2;
    }

    public static Date IfxToJavaDate(byte[] byArray, short s) {
        int n = IfxToJavaType.IfxToJavaInt(byArray, s);
        if (n == Integer.MIN_VALUE) {
            return null;
        }
        return IfxToJavaType.convertDaysToDate(n);
    }

    public static final boolean rleapyear(int n) {
        return (n & 3) == 0 && (n % 400 == 0 || n % 100 != 0);
    }

    public static Date convertDaysToDate(int n) {
        int n2 = n + 693594;
        int n3 = (n2 * 4 + 3) / 146097;
        n2 -= n3 * 146097 / 4;
        int n4 = n3 * 100;
        n3 = (n2 * 4 + 3) / 1461;
        int n5 = (n2 -= n3 * 1461 / 4) + 1;
        IfxToJavaType.daymon[2] = ((n4 += n3 + 1) & 3) == 0 && (n4 % 400 == 0 || n4 % 100 != 0 || false) ? 29 : 28;
        int n6 = 1;
        while (n6 <= 12) {
            if (n5 <= daymon[n6]) break;
            n5 -= daymon[n6];
            ++n6;
        }
        Date date = new Date(n4 - 1900, n6 - 1, n5);
        return date;
    }

    public static synchronized int convertDateToDays(Date date) {
        Cal.setTime(date);
        int n = Cal.get(2) + 1;
        int n2 = Cal.get(5);
        int n3 = Cal.get(1);
        IfxToJavaType.daymon[2] = (n3 & 3) == 0 && (n3 % 400 == 0 || n3 % 100 != 0 || false) ? 29 : 28;
        int n4 = n3 - 1;
        int n5 = n4 / 100 * 146097 / 4 + n4 % 100 * 1461 / 4 + n2 - 1 - 693594;
        int n6 = 1;
        while (n6 < n) {
            n5 += daymon[n6];
            ++n6;
        }
        return n5;
    }

    public static Timestamp IfxToJavaDateTime(byte[] byArray, short s) {
        Decimal decimal = new Decimal(byArray, s, true);
        return decimal.timestampValue();
    }

    public static Interval IfxToJavaInterval(byte[] byArray, short s) {
        Decimal decimal = new Decimal(byArray, s, true);
        if (decimal.dec_pos == -1) {
            return null;
        }
        return decimal.intervalValue();
    }

    public static BigDecimal IfxToJavaDecimal(byte[] byArray, short s) {
        Decimal decimal = new Decimal(byArray, s);
        return decimal.numericValue();
    }

    public static double IfxToJavaDouble(byte[] byArray, short s) {
        long l = (long)byArray[0] << 56 | (long)byArray[1] << 48 & 0xFF000000000000L | (long)byArray[2] << 40 & 0xFF0000000000L | (long)byArray[3] << 32 & 0xFF00000000L | (long)byArray[4] << 24 & 0xFF000000L | (long)byArray[5] << 16 & 0xFF0000L | (long)byArray[6] << 8 & 0xFF00L | (long)byArray[7] & 0xFFL;
        return Double.longBitsToDouble(l);
    }

    public static float IfxToJavaReal(byte[] byArray, short s) {
        int n = IfxToJavaType.IfxToJavaInt(byArray, (short)0);
        return Float.intBitsToFloat(n);
    }

    protected static final short widenByte(byte by) {
        return (short)((short)by & 0xFF);
    }

    public static short IfxToJavaSmallInt(byte[] byArray, short s) {
        short s2 = byArray[0];
        byte by = byArray[1];
        s2 = (short)((s2 << 8) + (short)((short)by & 0xFF));
        return s2;
    }

    public static int IfxToJavaInt(byte[] byArray, short s) {
        int n = byArray[0];
        byte by = byArray[1];
        int n2 = (n << 8) + (short)((short)by & 0xFF) << 8;
        by = byArray[2];
        int n3 = n2 + (short)((short)by & 0xFF) << 8;
        by = byArray[3];
        n = n3 + (short)((short)by & 0xFF);
        return n;
    }

    public static long IfxToJavaLongInt(byte[] byArray, short s) {
        long l = 0L;
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = new byte[2];
        byte[] byArray5 = new byte[8];
        System.arraycopy(byArray, 0, byArray4, 0, 2);
        short s2 = IfxToJavaType.IfxToJavaSmallInt(byArray4, s);
        System.arraycopy(byArray, 2, byArray2, 0, 4);
        System.arraycopy(byArray, 6, byArray3, 0, 4);
        byArray5[0] = byArray3[0];
        byArray5[1] = (byte)(0xFF & (short)byArray3[1]);
        byArray5[2] = (byte)(0xFF & (short)byArray3[2]);
        byArray5[3] = (byte)(0xFF & (short)byArray3[3]);
        byArray5[4] = (byte)(0xFF & (short)byArray2[0]);
        byArray5[5] = (byte)(0xFF & (short)byArray2[1]);
        byArray5[6] = (byte)(0xFF & (short)byArray2[2]);
        byArray5[7] = (byte)(0xFF & (short)byArray2[3]);
        BigInteger bigInteger = new BigInteger(byArray5);
        l = bigInteger.longValue();
        if (s2 == 0) {
            l = Long.MIN_VALUE;
        } else if (s2 == -1) {
            l *= -1L;
        }
        return l;
    }

    static {
        IfxToJavaType.daymon[0] = 0;
        IfxToJavaType.daymon[1] = 31;
        IfxToJavaType.daymon[2] = 28;
        IfxToJavaType.daymon[3] = 31;
        IfxToJavaType.daymon[4] = 30;
        IfxToJavaType.daymon[5] = 31;
        IfxToJavaType.daymon[6] = 30;
        IfxToJavaType.daymon[7] = 31;
        IfxToJavaType.daymon[8] = 31;
        IfxToJavaType.daymon[9] = 30;
        IfxToJavaType.daymon[10] = 31;
        IfxToJavaType.daymon[11] = 30;
        IfxToJavaType.daymon[12] = 31;
        Cal = Calendar.getInstance();
    }
}

