/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxSQLData;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDistinct;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxUDT;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.lang.IfxTypes;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;

class IfxValue
extends Trace {
    static Hashtable IfxTypeToObjectTable = null;
    static Hashtable IfxTypeToObjectTable_9x = null;
    private static final int IUS_TYPES = 10;
    private static final int NO_SCALE = -1;
    private static final String DISTINCT_CLASS_NAME = "IfxDistinct";
    private static final String BLOB_CLASS_NAME = "IfxSmBlob";
    private static final String CLOB_CLASS_NAME = "IfxSmBlob";
    private static final String SERVER_BLOB_CLASS_NAME = "IfxDirectBlob";
    private static final String SERVER_CLOB_CLASS_NAME = "IfxDirectClob";
    private static final String BOOLEAN_CLASS_NAME = "IfxBoolean";
    private static final String LVARCHAR_CLASS_NAME = "IfxLvarchar";
    private static final String UDT_CLASS_NAME = "IfxUDT";

    private static String IfxTypeToObject_9x(IfxConnection ifxConnection, int n) {
        if (ifxConnection.isDirect()) {
            switch (n) {
                case 102: {
                    return SERVER_BLOB_CLASS_NAME;
                }
                case 101: {
                    return SERVER_CLOB_CLASS_NAME;
                }
            }
        }
        return (String)IfxTypeToObjectTable_9x.get(new Integer(n));
    }

    private static int getRealIfxType(IfxConnection ifxConnection, int n) {
        if (!ifxConnection.isIEEEM() && IfxTypes.IsFloatTypes(n)) {
            n = 5;
        } else if (!ifxConnection.isUSVER() && n == 17) {
            n = 2;
        }
        return n & 0xFF;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, IfxColumnInfo ifxColumnInfo) throws SQLException {
        byte by;
        String string = null;
        String string2 = null;
        if (ifxColumnInfo == null) {
            throw IfxErrMsg.getSQLException(-79714, ifxConnection);
        }
        Trace trace = ifxConnection.getTrace();
        int n = IfxValue.getRealIfxType(ifxConnection, ifxColumnInfo.SQLtype);
        if (ifxConnection.isDirect()) {
            if (n >= 17) {
                if (ifxColumnInfo.ExtendedId == 5 || ifxColumnInfo.SourceType == 5) {
                    string = BOOLEAN_CLASS_NAME;
                    n = 45;
                } else if (ifxColumnInfo.ExtendedId == 1 || ifxColumnInfo.SourceType == 1) {
                    string = LVARCHAR_CLASS_NAME;
                    n = 43;
                }
                if (string == null) {
                    string = IfxValue.IfxTypeToObject_9x(ifxConnection, n);
                }
            } else {
                string = (String)IfxTypeToObjectTable.get(new Integer(n));
            }
            if (n == 14) {
                by = (byte)(ifxColumnInfo.ColLength >> 4 & 0xF);
                string2 = by == 0 || by == 2 ? "YM" : "DF";
            }
        } else if (!ifxColumnInfo.IsDistinct) {
            if (n >= 17 && ifxConnection.isUSVER()) {
                if (ifxColumnInfo.ExtendedId == 5) {
                    string = BOOLEAN_CLASS_NAME;
                    n = 45;
                } else if (ifxColumnInfo.ExtendedId == 1) {
                    string = LVARCHAR_CLASS_NAME;
                    n = 43;
                }
                if (ifxColumnInfo.ExtendedId != 0) {
                    if (ifxColumnInfo.ExtendedId == 10) {
                        string = "IfxSmBlob";
                        n = 44;
                    } else if (ifxColumnInfo.ExtendedId == 11) {
                        string = "IfxSmBlob";
                        n = 44;
                    } else if (n == 40 || n == 41) {
                        string = UDT_CLASS_NAME;
                        n = 44;
                    }
                }
                if (string == null) {
                    string = IfxValue.IfxTypeToObject_9x(ifxConnection, n);
                }
            } else {
                string = (String)IfxTypeToObjectTable.get(new Integer(n));
            }
            if (n == 14) {
                by = (byte)(ifxColumnInfo.ColLength >> 4 & 0xF);
                string2 = by == 0 || by == 2 ? "YM" : "DF";
            }
        } else {
            string = DISTINCT_CLASS_NAME;
        }
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79714, ifxConnection);
        }
        IfxObject ifxObject = IfxValue.createInstanceFromClassName(string, string2, ifxConnection);
        if (ifxObject != null) {
            ifxObject.setIfxType(n);
            ifxObject.setExtendedTypeName(ifxColumnInfo.ExtendedName);
            ifxObject.setExtendedOwner(ifxColumnInfo.ExtendedOwner);
            ifxObject.setExtendedId(ifxColumnInfo.ExtendedId);
            ifxObject.setSourceType(ifxColumnInfo.SourceType);
            ifxObject.setEncodedLength(ifxColumnInfo.ColLength);
            ifxObject.setConnection(ifxConnection);
        }
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, IfxColumnInfo ifxColumnInfo, int n) throws SQLException {
        IfxObject ifxObject;
        Trace trace = ifxConnection.getTrace();
        if (ifxColumnInfo != null) {
            if (n == -1 && ifxColumnInfo.ExtendedId != 0 && ifxColumnInfo.ExtendedId != 11) {
                n = 43;
                ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n, null);
            } else {
                ifxObject = IfxValue.makeInstance(ifxConnection, ifxColumnInfo);
            }
        } else {
            int n2 = IfxTypes.FromJDBCToIfxType(n);
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n2, null);
        }
        return ifxObject;
    }

    private static IfxObject createInstanceFromClassName(String string, String string2, IfxConnection ifxConnection) throws SQLException {
        IfxObject ifxObject = null;
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79728, ifxConnection);
        }
        try {
            Class<?> clazz = string2 == null ? Class.forName("com.informix.jdbc." + string) : Class.forName("com.informix.jdbc." + string + string2);
            ifxObject = (IfxObject)clazz.newInstance();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), ifxConnection);
        }
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, Object object, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        Trace trace = ifxConnection.getTrace();
        if (object == null && ifxColumnInfo != null) {
            ifxObject = IfxValue.makeInstance(ifxConnection, ifxColumnInfo);
        } else if (object instanceof IfmxSQLData) {
            ifxObject = IfxValue.makeInstance(ifxConnection, (IfmxSQLData)object, ifxColumnInfo);
        } else {
            String string = object.getClass().getName();
            int n = IfxTypes.FromJavaToIfxType(string);
            if (ifxColumnInfo != null) {
                if (string.equals("java.lang.Boolean")) {
                    ifxObject = IfxValue.makeInstance(ifxConnection, (Boolean)object, ifxColumnInfo);
                } else if (string.equals("[B")) {
                    ifxObject = IfxValue.makeInstance(ifxConnection, (byte[])object, ifxColumnInfo);
                }
            }
            if (ifxObject == null) {
                if (ifxColumnInfo == null || ifxColumnInfo.ExtendedId != 0) {
                    String string2 = null;
                    if (object instanceof IntervalYM) {
                        string2 = new String("YM");
                    } else if (object instanceof IntervalDF) {
                        string2 = new String("DF");
                    }
                    if (n == -99) {
                        throw IfxErrMsg.getSQLException(-79728, ifxConnection);
                    }
                    if (ifxConnection.isUSVER() && n == 0) {
                        n = 43;
                    }
                    ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n, string2);
                    ifxObject.fromObject(object);
                } else {
                    ifxObject = IfxValue.makeInstance(ifxConnection, ifxColumnInfo);
                    ifxObject.fromObject(object);
                }
            }
        }
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, Object object, IfxColumnInfo ifxColumnInfo, int n) throws SQLException {
        Trace trace = ifxConnection.getTrace();
        return IfxValue.makeInstance(ifxConnection, object, ifxColumnInfo, -1, n);
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, Object object, IfxColumnInfo ifxColumnInfo, int n, int n2) throws SQLException {
        IfxObject ifxObject = null;
        Trace trace = ifxConnection.getTrace();
        if (ifxColumnInfo != null && n2 == -1 && ifxColumnInfo.ExtendedId != 0 && ifxColumnInfo.ExtendedId != 11) {
            n2 = 43;
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n2, null);
        } else if (n2 == 2000 || n2 == 2001 || n2 == 1111 || n2 == -4 || n2 == -3 || n2 == -1) {
            ifxObject = IfxValue.makeInstance(ifxConnection, object, ifxColumnInfo);
        } else {
            int n3 = IfxTypes.FromJDBCToIfxType(n2);
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n3, null);
        }
        if (ifxObject != null) {
            if (n == -1) {
                ifxObject.fromObject(object);
            } else {
                ifxObject.fromObject(object, n);
            }
        }
        return ifxObject;
    }

    static IfxObject makeInstanceFromIfxType(IfxConnection ifxConnection, int n) throws SQLException {
        return IfxValue.makeInstanceFromIfxType(ifxConnection, n, null);
    }

    static IfxObject makeInstanceFromIfxType(IfxConnection ifxConnection, int n, String string) throws SQLException {
        IfxObject ifxObject = null;
        ifxConnection.getTrace();
        n = IfxValue.getRealIfxType(ifxConnection, n);
        ifxObject = n >= 17 && ifxConnection.isUSVER() ? IfxValue.createInstanceFromClassName(IfxValue.IfxTypeToObject_9x(ifxConnection, n), null, ifxConnection) : IfxValue.createInstanceFromClassName((String)IfxTypeToObjectTable.get(new Integer(n)), string, ifxConnection);
        if (ifxObject != null) {
            if (n == 101 || n == 102) {
                ifxObject.setExtendedTypeName(IfxTypes.IfxTypeToName(n));
                if (!ifxConnection.isDirect()) {
                    n = 44;
                }
            }
            ifxObject.setIfxType(n);
            ifxObject.setConnection(ifxConnection);
        }
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, BigDecimal bigDecimal, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        if (ifxColumnInfo != null && ifxColumnInfo.SQLtype <= 18) {
            int n = ifxColumnInfo.SQLtype;
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n, null);
        } else {
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 5, null);
        }
        ifxObject.fromDecimal(bigDecimal);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, boolean bl, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        ifxObject = ifxColumnInfo != null ? IfxValue.makeInstance(ifxConnection, ifxColumnInfo) : IfxValue.makeInstanceFromIfxType(ifxConnection, 1, null);
        ifxObject.fromBoolean(bl);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, short s, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        if (ifxColumnInfo != null && ifxColumnInfo.SQLtype <= 18) {
            int n = ifxColumnInfo.SQLtype;
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n, null);
        } else {
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 1, null);
        }
        ifxObject.fromShort(s);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, byte by, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        if (ifxColumnInfo != null && ifxColumnInfo.SQLtype <= 18) {
            int n = ifxColumnInfo.SQLtype;
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n, null);
        } else {
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 1, null);
        }
        ifxObject.fromByte(by);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, int n, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        if (ifxColumnInfo != null && ifxColumnInfo.SQLtype <= 18) {
            int n2 = ifxColumnInfo.SQLtype;
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n2, null);
        } else {
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 2, null);
        }
        ifxObject.fromInt(n);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, long l, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        if (ifxColumnInfo != null && ifxColumnInfo.SQLtype < 17) {
            int n = ifxColumnInfo.SQLtype;
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n, null);
        } else {
            int n = ifxConnection.isUSVER() ? 17 : 2;
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n, null);
        }
        ifxObject.fromLong(l);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, float f, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        if (ifxColumnInfo != null && ifxColumnInfo.SQLtype <= 18) {
            int n = ifxColumnInfo.SQLtype;
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n, null);
        } else {
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 4, null);
        }
        ifxObject.fromFloat(f);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, double d, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        if (ifxColumnInfo != null && ifxColumnInfo.SQLtype <= 18) {
            int n = ifxColumnInfo.SQLtype;
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n, null);
        } else {
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 3, null);
        }
        ifxObject.fromDouble(d);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, String string, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject;
        Trace trace = ifxConnection.getTrace();
        if (ifxColumnInfo != null) {
            if (ifxColumnInfo.SQLtype == 13 || ifxColumnInfo.SQLtype == 16) {
                ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 13, null);
            } else if (ifxColumnInfo.SQLtype > 18) {
                if (ifxColumnInfo.ExtendedId == 11) {
                    ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 101, null);
                    ifxObject.extendedID = 11;
                } else if (ifxColumnInfo.ExtendedId == 5) {
                    ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 0, null);
                } else {
                    ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 43, null);
                    ifxObject.extendedID = 1;
                    if (ifxColumnInfo.IsDistinct) {
                        ifxColumnInfo.ExtendedOwner = new String("informix");
                        ifxObject.extendedName = new String("lvarchar");
                    }
                }
            } else {
                String string2 = null;
                if (ifxColumnInfo.SQLtype == 14) {
                    byte by = (byte)(ifxColumnInfo.ColLength >> 4 & 0xF);
                    string2 = by == 0 || by == 2 ? "YM" : "DF";
                }
                ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, ifxColumnInfo.SQLtype, string2);
            }
        } else {
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 0, null);
        }
        ifxObject.fromString(string);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, byte[] byArray, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = ifxColumnInfo != null ? IfxValue.makeInstance(ifxConnection, ifxColumnInfo) : (ifxConnection.isDirect() ? IfxValue.makeInstanceFromIfxType(ifxConnection, 102, null) : IfxValue.makeInstanceFromIfxType(ifxConnection, 11, null));
        ifxObject.fromBytes(byArray);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, Date date, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        if (ifxColumnInfo != null && ifxColumnInfo.SQLtype <= 18) {
            int n = ifxColumnInfo.SQLtype;
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n, null);
        } else {
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 7, null);
        }
        ifxObject.fromDate(date);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, Time time, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        if (ifxColumnInfo != null && ifxColumnInfo.SQLtype <= 18) {
            int n = ifxColumnInfo.SQLtype;
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n, null);
        } else {
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 10, null);
        }
        ifxObject.fromTime(time);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, Timestamp timestamp, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        if (ifxColumnInfo != null && ifxColumnInfo.SQLtype <= 18) {
            int n = ifxColumnInfo.SQLtype;
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n, null);
        } else {
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 10, null);
        }
        ifxObject.fromTimestamp(timestamp);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, InputStream inputStream, int n, IfxColumnInfo ifxColumnInfo) throws SQLException {
        if (inputStream instanceof IfxLobInputStream) {
            InputStream inputStream2 = ((IfxLobInputStream)inputStream).getStream();
        } else {
            InputStream inputStream3 = inputStream;
        }
        IfxObject ifxObject = ifxColumnInfo != null ? IfxValue.makeInstance(ifxConnection, ifxColumnInfo) : (ifxConnection.isDirect() ? IfxValue.makeInstanceFromIfxType(ifxConnection, 102, null) : IfxValue.makeInstanceFromIfxType(ifxConnection, 11, null));
        ifxObject.fromInputStream(inputStream, n);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, IntervalYM intervalYM, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        if (ifxColumnInfo != null && ifxColumnInfo.SQLtype <= 18) {
            int n = ifxColumnInfo.SQLtype;
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n, null);
        } else {
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 14, "YM");
        }
        ifxObject.fromIntervalYM(intervalYM);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, IntervalDF intervalDF, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        if (ifxColumnInfo != null && ifxColumnInfo.SQLtype <= 18) {
            int n = ifxColumnInfo.SQLtype;
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n, null);
        } else {
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 14, "DF");
        }
        ifxObject.fromIntervalDF(intervalDF);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, IfmxSQLData ifmxSQLData, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        IfxUDTInfo ifxUDTInfo = null;
        String string = ifmxSQLData.getSQLTypeName();
        if (string != null) {
            ifxUDTInfo = ifxConnection.getUDTInfo(ifxColumnInfo, string);
        }
        if (ifxUDTInfo == null) {
            throw IfxErrMsg.getSQLException(-79770, ifxConnection);
        }
        ifxObject = IfxValue.createInstanceByTypeInfo(ifxConnection, ifxUDTInfo);
        if (ifxObject != null) {
            ifxObject.fromObject(ifmxSQLData);
        }
        return ifxObject;
    }

    private static IfxObject createInstanceByTypeInfo(IfxConnection ifxConnection, IfxUDTInfo ifxUDTInfo) throws SQLException {
        IfxObject ifxObject;
        block10: {
            ifxObject = null;
            try {
                switch (ifxUDTInfo.JDBCtype) {
                    case 2000: {
                        ifxObject = new IfxUDT();
                        if (!ifxConnection.isDirect()) {
                            ifxObject.setIfxType(44);
                        } else {
                            ifxObject.setIfxType(ifxUDTInfo.SQLtype);
                        }
                        break;
                    }
                    case 2001: {
                        ifxObject = new IfxDistinct();
                        ifxObject.setIfxType(ifxUDTInfo.SQLtype);
                        ifxObject.isDistinct = true;
                        break;
                    }
                    default: {
                        if (ifxObject == null) break block10;
                    }
                }
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), ifxConnection);
            }
            if (ifxObject == null) break block10;
            ifxObject.setExtendedTypeName(ifxUDTInfo.name);
            ifxObject.setExtendedOwner(ifxUDTInfo.owner);
            ifxObject.setExtendedId(ifxUDTInfo.xid);
            ifxObject.setSourceType(ifxUDTInfo.source);
            ifxObject.setConnection(ifxConnection);
        }
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, IfxColumnInfo ifxColumnInfo, int n, String string) throws SQLException {
        IfxObject ifxObject;
        if (ifxColumnInfo != null) {
            ifxObject = IfxValue.makeInstance(ifxConnection, ifxColumnInfo);
        } else {
            int n2 = IfxTypes.FromJDBCToIfxType(n);
            if (n2 <= 18 || n2 == 101 || n2 == 102) {
                ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n2, null);
            } else {
                IfxUDTInfo ifxUDTInfo = null;
                if (string != null) {
                    ifxUDTInfo = ifxConnection.getUDTInfo(ifxColumnInfo, string);
                }
                if (ifxUDTInfo == null) {
                    throw IfxErrMsg.getSQLException(-79770, ifxConnection);
                }
                ifxObject = IfxValue.createInstanceByTypeInfo(ifxConnection, ifxUDTInfo);
            }
        }
        return ifxObject;
    }

    IfxValue() {
    }

    static {
        if (IfxTypeToObjectTable == null) {
            IfxTypeToObjectTable = new Hashtable(49, 1.0f);
            IfxTypeToObjectTable.put(new Integer(0), "IfxChar");
            IfxTypeToObjectTable.put(new Integer(1), "IfxShort");
            IfxTypeToObjectTable.put(new Integer(2), "IfxInteger");
            IfxTypeToObjectTable.put(new Integer(3), "IfxFloat");
            IfxTypeToObjectTable.put(new Integer(4), "IfxSmallFloat");
            IfxTypeToObjectTable.put(new Integer(5), "IfxDecimal");
            IfxTypeToObjectTable.put(new Integer(6), "IfxInteger");
            IfxTypeToObjectTable.put(new Integer(8), "IfxDecimal");
            IfxTypeToObjectTable.put(new Integer(7), "IfxDate");
            IfxTypeToObjectTable.put(new Integer(10), "IfxDateTime");
            IfxTypeToObjectTable.put(new Integer(8), "IfxDecimal");
            IfxTypeToObjectTable.put(new Integer(11), "IfxBlob");
            IfxTypeToObjectTable.put(new Integer(12), "IfxBlob");
            IfxTypeToObjectTable.put(new Integer(13), "IfxVarChar");
            IfxTypeToObjectTable.put(new Integer(14), "IfxInterval");
            IfxTypeToObjectTable.put(new Integer(15), "IfxChar");
            IfxTypeToObjectTable.put(new Integer(16), "IfxVarChar");
            IfxTypeToObjectTable.put(new Integer(17), "IfxInteger");
            IfxTypeToObjectTable.put(new Integer(18), "IfxInteger");
        }
        if (IfxTypeToObjectTable_9x == null) {
            IfxTypeToObjectTable_9x = new Hashtable(10, 1.0f);
            IfxTypeToObjectTable_9x.put(new Integer(17), "IfxInt8");
            IfxTypeToObjectTable_9x.put(new Integer(18), "IfxInt8");
            IfxTypeToObjectTable_9x.put(new Integer(19), "IfxCollection");
            IfxTypeToObjectTable_9x.put(new Integer(20), "IfxCollection");
            IfxTypeToObjectTable_9x.put(new Integer(21), "IfxCollection");
            IfxTypeToObjectTable_9x.put(new Integer(22), "IfxRow");
            IfxTypeToObjectTable_9x.put(new Integer(40), UDT_CLASS_NAME);
            IfxTypeToObjectTable_9x.put(new Integer(41), UDT_CLASS_NAME);
            IfxTypeToObjectTable_9x.put(new Integer(43), LVARCHAR_CLASS_NAME);
            IfxTypeToObjectTable_9x.put(new Integer(45), BOOLEAN_CLASS_NAME);
            IfxTypeToObjectTable_9x.put(new Integer(44), UDT_CLASS_NAME);
            IfxTypeToObjectTable_9x.put(new Integer(101), "IfxSmBlob");
            IfxTypeToObjectTable_9x.put(new Integer(102), "IfxSmBlob");
        }
    }
}

