/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxSQLData;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSQLOutput;
import com.informix.jdbc.SQLUDTOutput;
import com.informix.lang.Decimal;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;

public class IfxUDTOutput
extends IfxSQLOutput
implements SQLUDTOutput,
IfmxUDTSQLOutput {
    private static final int NO_ALIGNMENT = -1;

    IfxUDTOutput() {
    }

    IfxUDTOutput(IfxConnection ifxConnection) throws SQLException {
        super(ifxConnection);
    }

    private void checkAlignment(int n, int n2) throws SQLException {
        if (n2 != -1) {
            int n3 = (this.currentPos + n + (n2 - 1) & ~(n2 - 1)) - (this.currentPos + n);
            try {
                while (n3-- > 0) {
                    this.os.write(0);
                    ++this.currentPos;
                }
                return;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
    }

    public void writeString(String string, int n) throws SQLException {
        this.checkAlignment(n, -1);
        try {
            int n2 = n - string.length();
            byte[] byArray = string.getBytes();
            this.os.write(byArray, 0, string.length() > n ? n : string.length());
            while (n2-- > 0) {
                this.os.write(0);
            }
            this.currentPos += n;
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeByte(byte by) throws SQLException {
        this.checkAlignment(1, -1);
        try {
            this.os.writeByte(by);
            ++this.currentPos;
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeBoolean(boolean bl) throws SQLException {
        byte by = 0;
        if (bl) {
            by = 1;
        }
        try {
            this.writeByte(by);
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeShort(short s) throws SQLException {
        this.checkAlignment(2, 2);
        super.writeShort(s);
    }

    public void writeInt(int n) throws SQLException {
        this.checkAlignment(4, 4);
        super.writeInt(n);
    }

    public void writeLong(long l) throws SQLException {
        try {
            short s = 1;
            if (l < 0L) {
                s = -1;
                l = -l;
            }
            long l2 = l & 0xFFFFFFFFL;
            this.writeInt((int)l2);
            int n = (int)(l >> 32);
            this.writeInt(n);
            this.writeShort(s);
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeFloat(float f) throws SQLException {
        this.checkAlignment(4, 4);
        super.writeFloat(f);
    }

    public void writeDouble(double d) throws SQLException {
        this.checkAlignment(8, 8);
        super.writeDouble(d);
    }

    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        try {
            this.checkAlignment(2, 2);
            this.os.write(new Decimal(bigDecimal).javaToDec_t());
            this.currentPos += 22;
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeBytes(byte[] byArray, int n) throws SQLException {
        try {
            this.checkAlignment(n, -1);
            int n2 = n - byArray.length;
            this.os.write(byArray);
            while (n2-- > 0) {
                this.os.write(0);
            }
            this.currentPos += n;
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        try {
            String string = JavaToIfxType.convertTimestampToString(timestamp);
            Decimal decimal = new Decimal(string);
            this.checkAlignment(2, 2);
            this.os.writeShort((short)4365);
            this.os.write(decimal.javaToDec_t());
            this.currentPos += 24;
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeCharacterStream(Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeCharacterStream(Reader).", this.conn);
    }

    public void writeAsciiStream(InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeAsciiStream(InputStream).", this.conn);
    }

    public void writeBinaryStream(InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeBinaryStream(InputStream).", this.conn);
    }

    public void writeObject(IfmxSQLData ifmxSQLData) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeObject(SQLData).", this.conn);
    }

    void writeIfxLocator(IfxLocator ifxLocator) throws SQLException {
        this.writeBytes(ifxLocator.getRawLocator());
    }

    public void writeInterval(Interval interval) throws SQLException {
        try {
            long l;
            String string = null;
            byte[] byArray = new byte[2];
            short s = 0;
            if (interval instanceof IntervalYM) {
                string = JavaToIfxType.convertIntervalToString((IntervalYM)interval);
                l = ((IntervalYM)interval).getMonths();
                if (l < 0L) {
                    l = -l;
                }
                String string2 = new Long(l /= 12L).toString();
                string2.trim();
                byArray = Decimal.encodeIntervalPrecision(byArray, (byte)string2.length(), (byte)0, (byte)2);
            } else {
                string = JavaToIfxType.convertIntervalToString((IntervalDF)interval);
                l = ((IntervalDF)interval).getSeconds();
                if (l < 0L) {
                    l = -l;
                }
                if (l <= 0L) {
                    byArray = Decimal.encodeIntervalPrecision(byArray, (byte)2, (byte)12, (byte)15);
                } else {
                    byte by = 0;
                    by = string.charAt(0) == '-' ? (byte)(string.length() - 13) : (byte)(string.length() - 12);
                    byArray = Decimal.encodeIntervalPrecision(byArray, by, (byte)4, (byte)15);
                }
            }
            s = (short)(byArray[0] * 256 + byArray[1]);
            Decimal decimal = new Decimal(string, s);
            short s2 = interval.getQualifier();
            this.checkAlignment(2, 2);
            this.os.writeShort(s2);
            this.os.write(decimal.javaToDec_t());
            this.currentPos += 24;
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.getMessage(), this.conn);
        }
    }
}

