/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxPreparedStatement;
import com.informix.jdbc.IfxBlob;
import com.informix.jdbc.IfxCallableStatement;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxValue;
import com.informix.jdbc.PreparedStatement2;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxByteArrayOutputStream;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.stringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;

public class IfxPreparedStatement
extends IfxStatement
implements IfmxPreparedStatement,
PreparedStatement2 {
    String baseStatement;
    private Vector vector = new Vector();
    private InputStream blob_inputstr;
    private int blob_length;
    Trace trace;
    IfxResultSetMetaData rsmd;
    private int inputcount;
    private boolean canUsePut = false;
    private boolean usePut = false;
    private IfxByteArrayOutputStream bStream;
    short batchCount;
    static final int ONE = 1;
    private int[] putIndexArray;
    private int curRow;
    private Vector textObjArray = new Vector();
    private int textObjArrayIdx;
    IfxResultSetMetaData putRsmd;
    static final int INIT_IDX_SIZE = 1000;
    static final int INC_IDX_SIZE = 1000;
    int inputvals;

    IfxPreparedStatement(IfxConnection ifxConnection) {
        super(ifxConnection);
    }

    void setSqlString(String string) throws SQLException {
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        this.baseStatement = string;
        if (this instanceof IfxCallableStatement) {
            this.setqmarks(this.cntqmarks(string, "="));
        } else {
            this.setqmarks(this.cntqmarks(string, null));
        }
        String string2 = this.commandString = this.escapeProcessing ? this.jconn.nativeSQL(string) : string;
        if (this.numqmarks > 0) {
            this.vector.setSize(this.numqmarks);
        }
        if (this.BatchVector.size() > 0) {
            this.clearBatch();
        }
    }

    IfxPreparedStatement(IfxConnection ifxConnection, String string) throws SQLException {
        super(ifxConnection);
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79726, ifxConnection);
        }
        this.baseStatement = string;
        if (this instanceof IfxCallableStatement) {
            this.setqmarks(this.cntqmarks(string, "="));
        } else {
            this.setqmarks(this.cntqmarks(string, null));
        }
        this.commandString = this.escapeProcessing ? this.jconn.nativeSQL(string) : string;
        this.setupExecutePrepare();
        if (this.BatchVector.size() > 0) {
            this.clearBatch();
        }
    }

    void setupExecutePrepare() throws SQLException {
        this.savedResult = new IfxResultSet(this);
        this.savedResult.executePrepare();
        if (this.numqmarks > 0) {
            this.vector.setSize(this.numqmarks);
        }
        this.rsmd = (IfxResultSetMetaData)this.savedResult.getMetaData();
        if (!this.jconn.isDirect() && ((IfxSqliConnect)this.jconn).getUsePut() && this.getStatementType() == 6 && this.numqmarks == this.rsmd.getColumnCount()) {
            this.canUsePut = true;
            this.putRsmd = new IfxResultSetMetaData(this.rsmd);
        }
    }

    Vector getVector() {
        return this.vector;
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.savedResult == null) {
            throw IfxErrMsg.getSQLException(-79727, this.jconn);
        }
        this.savedResult.close();
        return this.executeQueryImpl(false);
    }

    public ResultSet executeQuery(boolean bl) throws SQLException {
        if (this.savedResult == null) {
            throw IfxErrMsg.getSQLException(-79727, this.jconn);
        }
        this.savedResult.close();
        return this.executeQueryImpl(bl);
    }

    public int executeUpdate() throws SQLException {
        if (this.savedResult == null) {
            throw IfxErrMsg.getSQLException(-79727, this.jconn);
        }
        this.savedResult.close();
        return this.executeUpdateImpl();
    }

    public boolean execute() throws SQLException {
        if (this.savedResult == null) {
            throw IfxErrMsg.getSQLException(-79727, this.jconn);
        }
        this.savedResult.close();
        return this.executeImpl();
    }

    public void setNull(int n, int n2) throws SQLException {
        try {
            int n3 = this.numqmarks;
            if (n > n3) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null) {
                ifxObject.clear();
                ++this.inputvals;
                return;
            }
            ifxObject = IfxValue.makeInstance(this.jconn, this.getColumnInfo(n), n2);
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setNull(int n, int n2, int n3) throws SQLException {
        try {
            int n4 = this.numqmarks;
            if (n > n4) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null) {
                ifxObject.clear();
                ++this.inputvals;
                return;
            }
            IfxConnection ifxConnection = this.jconn;
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n3, null);
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        try {
            int n3 = this.numqmarks;
            if (n > n3) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null) {
                ifxObject.clear();
                ++this.inputvals;
                return;
            }
            ifxObject = IfxValue.makeInstance(this.jconn, this.getColumnInfo(n), n2, string);
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            int n2 = this.numqmarks;
            if (n > n2) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null) {
                ifxObject.clear();
                ifxObject.fromDecimal(bigDecimal);
                ++this.inputvals;
                return;
            }
            ifxObject = IfxValue.makeInstance(this.jconn, bigDecimal, this.getColumnInfo(n));
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal, int n2) throws SQLException {
        this.setBigDecimal(n, bigDecimal);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        try {
            int n2 = this.numqmarks;
            if (n > n2) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null) {
                ifxObject.clear();
                ifxObject.fromBoolean(bl);
                ++this.inputvals;
                return;
            }
            ifxObject = IfxValue.makeInstance(this.jconn, bl, this.getColumnInfo(n));
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setBoolean(int n, boolean bl, int n2) throws SQLException {
        try {
            int n3 = this.numqmarks;
            if (n > n3) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null) {
                ifxObject.clear();
                ifxObject.fromBoolean(bl);
                ++this.inputvals;
                return;
            }
            IfxConnection ifxConnection = this.jconn;
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n2, null);
            ifxObject.fromBoolean(bl);
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setByte(int n, byte by) throws SQLException {
        try {
            int n2 = this.numqmarks;
            if (n > n2) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null) {
                ifxObject.clear();
                ifxObject.fromByte(by);
                ++this.inputvals;
                return;
            }
            ifxObject = IfxValue.makeInstance(this.jconn, by, this.getColumnInfo(n));
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setByte(int n, byte by, int n2) throws SQLException {
        this.setByte(n, by);
    }

    public void setShort(int n, short s) throws SQLException {
        try {
            int n2 = this.numqmarks;
            if (n > n2) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null) {
                ifxObject.clear();
                ifxObject.fromShort(s);
                ++this.inputvals;
                return;
            }
            ifxObject = IfxValue.makeInstance(this.jconn, s, this.getColumnInfo(n));
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setShort(int n, short s, int n2) throws SQLException {
        this.setShort(n, s);
    }

    public void setInt(int n, int n2) throws SQLException {
        try {
            int n3 = this.numqmarks;
            if (n > n3) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null) {
                ifxObject.clear();
                ifxObject.fromInt(n2);
                ++this.inputvals;
                return;
            }
            ifxObject = IfxValue.makeInstance(this.jconn, n2, this.getColumnInfo(n));
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setInt(int n, int n2, int n3) throws SQLException {
        this.setInt(n, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        try {
            int n2 = this.numqmarks;
            if (n > n2) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null) {
                ifxObject.clear();
                ifxObject.fromLong(l);
                ++this.inputvals;
                return;
            }
            ifxObject = IfxValue.makeInstance(this.jconn, l, this.getColumnInfo(n));
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setLong(int n, long l, int n2) throws SQLException {
        this.setLong(n, l);
    }

    public void setFloat(int n, float f) throws SQLException {
        try {
            int n2 = this.numqmarks;
            if (n > n2) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null) {
                ifxObject.clear();
                ifxObject.fromFloat(f);
                ++this.inputvals;
                return;
            }
            ifxObject = IfxValue.makeInstance(this.jconn, f, this.getColumnInfo(n));
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setFloat(int n, float f, int n2) throws SQLException {
        this.setFloat(n, f);
    }

    public void setDouble(int n, double d) throws SQLException {
        try {
            int n2 = this.numqmarks;
            if (n > n2) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null) {
                ifxObject.clear();
                ifxObject.fromDouble(d);
                ++this.inputvals;
                return;
            }
            ifxObject = IfxValue.makeInstance(this.jconn, d, this.getColumnInfo(n));
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setDouble(int n, double d, int n2) throws SQLException {
        this.setDouble(n, d);
    }

    public void setString(int n, String string) throws SQLException {
        try {
            int n2 = this.numqmarks;
            if (n > n2) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null && !(ifxObject instanceof IfxBlob)) {
                ifxObject.clear();
                ifxObject.fromString(string);
                ++this.inputvals;
                return;
            }
            ifxObject = this.usePut ? IfxValue.makeInstance(this.jconn, string, this.getColumnInfo(n)) : IfxValue.makeInstance(this.jconn, string, null);
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setString(int n, String string, int n2) throws SQLException {
        this.setString(n, string);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        try {
            int n2 = this.numqmarks;
            if (n > n2) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null && !(ifxObject instanceof IfxBlob)) {
                ifxObject.clear();
                ifxObject.fromBytes(byArray);
                ++this.inputvals;
                return;
            }
            ifxObject = IfxValue.makeInstance(this.jconn, byArray, this.getColumnInfo(n));
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setBytes(int n, byte[] byArray, int n2) throws SQLException {
        try {
            int n3 = this.numqmarks;
            if (n > n3) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null && !(ifxObject instanceof IfxBlob)) {
                ifxObject.clear();
                ifxObject.fromBytes(byArray);
                ++this.inputvals;
                return;
            }
            IfxConnection ifxConnection = this.jconn;
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n2, null);
            ifxObject.fromBytes(byArray);
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        try {
            int n2 = this.numqmarks;
            if (n > n2) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null) {
                ifxObject.clear();
                ifxObject.fromDate(date);
                ++this.inputvals;
                return;
            }
            ifxObject = IfxValue.makeInstance(this.jconn, date, this.getColumnInfo(n));
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setDate(int n, Date date, int n2) throws SQLException {
        this.setDate(n, date);
    }

    public void setTime(int n, Time time) throws SQLException {
        try {
            int n2 = this.numqmarks;
            if (n > n2) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null) {
                ifxObject.clear();
                ifxObject.fromTime(time);
                ++this.inputvals;
                return;
            }
            ifxObject = IfxValue.makeInstance(this.jconn, time, this.getColumnInfo(n));
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setTime(int n, Time time, int n2) throws SQLException {
        this.setTime(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            int n2 = this.numqmarks;
            if (n > n2) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null) {
                ifxObject.clear();
                ifxObject.fromTimestamp(timestamp);
                ++this.inputvals;
                return;
            }
            ifxObject = IfxValue.makeInstance(this.jconn, timestamp, this.getColumnInfo(n));
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, int n2) throws SQLException {
        this.setTimestamp(n, timestamp);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            int n3 = this.numqmarks;
            if (n > n3) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null && !(ifxObject instanceof IfxBlob)) {
                ifxObject.clear();
                ifxObject.fromAsciiStream(inputStream, n2);
                ++this.inputvals;
                return;
            }
            ifxObject = IfxValue.makeInstance(this.jconn, inputStream, n2, this.getColumnInfo(n));
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2, int n3) throws SQLException {
        try {
            int n4 = this.numqmarks;
            if (n > n4) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null && !(ifxObject instanceof IfxBlob)) {
                ifxObject.clear();
                ifxObject.fromAsciiStream(inputStream, n2);
                ++this.inputvals;
                return;
            }
            IfxConnection ifxConnection = this.jconn;
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n3, null);
            ifxObject.fromAsciiStream(inputStream, n2);
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": PreparedStatement.setUnicodeStream(int,InputStream,int).", this.jconn);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            int n3 = this.numqmarks;
            if (n > n3) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null && !(ifxObject instanceof IfxBlob)) {
                ifxObject.clear();
                ifxObject.fromBinaryStream(inputStream, n2);
                ++this.inputvals;
                return;
            }
            ifxObject = IfxValue.makeInstance(this.jconn, inputStream, n2, this.getColumnInfo(n));
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2, int n3) throws SQLException {
        try {
            int n4 = this.numqmarks;
            if (n > n4) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null && !(ifxObject instanceof IfxBlob)) {
                ifxObject.clear();
                ifxObject.fromBinaryStream(inputStream, n2);
                ++this.inputvals;
                return;
            }
            IfxConnection ifxConnection = this.jconn;
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n3, null);
            ifxObject.fromBinaryStream(inputStream, n2);
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setInterval(int n, Interval interval) throws SQLException {
        if (interval instanceof IntervalYM) {
            this.setIntervalYM(n, (IntervalYM)interval);
            return;
        }
        if (interval instanceof IntervalDF) {
            this.setIntervalDF(n, (IntervalDF)interval);
        }
    }

    public void setIntervalYM(int n, IntervalYM intervalYM) throws SQLException {
        try {
            int n2 = this.numqmarks;
            if (n > n2) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null) {
                ifxObject.clear();
                ifxObject.fromIntervalYM(intervalYM);
                ++this.inputvals;
                return;
            }
            ifxObject = IfxValue.makeInstance(this.jconn, intervalYM, this.getColumnInfo(n));
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setIntervalDF(int n, IntervalDF intervalDF) throws SQLException {
        try {
            int n2 = this.numqmarks;
            if (n > n2) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null) {
                ifxObject.clear();
                ifxObject.fromIntervalDF(intervalDF);
                ++this.inputvals;
                return;
            }
            ifxObject = IfxValue.makeInstance(this.jconn, intervalDF, this.getColumnInfo(n));
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void clearParameters() throws SQLException {
        try {
            this.vector = new Vector();
            this.vector.setSize(this.numqmarks);
            this.inputvals = 0;
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        try {
            int n4 = this.numqmarks;
            if (n > n4) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null && !(ifxObject instanceof IfxBlob)) {
                ifxObject.clear();
                ifxObject.fromObject(object);
                ++this.inputvals;
                return;
            }
            ifxObject = IfxValue.makeInstance(this.jconn, object, this.getColumnInfo(n), n3, n2);
            DataTruncation dataTruncation = ifxObject.getWarning();
            if (dataTruncation != null) {
                this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
            }
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        try {
            int n3 = this.numqmarks;
            if (n > n3) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null && !(ifxObject instanceof IfxBlob)) {
                ifxObject.clear();
                ifxObject.fromObject(object);
                ++this.inputvals;
                return;
            }
            ifxObject = IfxValue.makeInstance(this.jconn, object, this.getColumnInfo(n), n2);
            DataTruncation dataTruncation = ifxObject.getWarning();
            if (dataTruncation != null) {
                this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
            }
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void setObject(int n, Object object) throws SQLException {
        try {
            int n2 = this.numqmarks;
            if (n > n2) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null && !(ifxObject instanceof IfxBlob)) {
                ifxObject.clear();
                ifxObject.fromObject(object);
                ++this.inputvals;
                return;
            }
            ifxObject = IfxValue.makeInstance(this.jconn, object, this.getColumnInfo(n));
            DataTruncation dataTruncation = ifxObject.getWarning();
            if (dataTruncation != null) {
                this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
            }
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void IfxSetObject(int n, Object object, int n2, int n3) throws SQLException {
        try {
            int n4 = this.numqmarks;
            if (n > n4) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null && !(ifxObject instanceof IfxBlob)) {
                ifxObject.clear();
                ifxObject.fromObject(object, n2);
                return;
            }
            Object object2 = this.jconn;
            ifxObject = IfxValue.makeInstanceFromIfxType((IfxConnection)object2, n3, null);
            ifxObject.fromObject(object, n2);
            object2 = ifxObject.getWarning();
            if (object2 != null) {
                this.chainWarnings(new DataTruncation(n, false, true, ((DataTruncation)object2).getDataSize(), ((DataTruncation)object2).getTransferSize()));
            }
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    public void IfxSetObject(int n, Object object, int n2) throws SQLException {
        try {
            int n3 = this.numqmarks;
            if (n > n3) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            IfxObject ifxObject = (IfxObject)this.vector.elementAt(n - 1);
            if (this.usePut && ifxObject != null && !(ifxObject instanceof IfxBlob)) {
                ifxObject.clear();
                ifxObject.fromObject(object);
                return;
            }
            Object object2 = this.jconn;
            ifxObject = IfxValue.makeInstanceFromIfxType((IfxConnection)object2, n2, null);
            ifxObject.fromObject(object);
            object2 = ifxObject.getWarning();
            if (object2 != null) {
                this.chainWarnings(new DataTruncation(n, false, true, ((DataTruncation)object2).getDataSize(), ((DataTruncation)object2).getTransferSize()));
            }
            this.set(n, ifxObject);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.jconn);
        }
    }

    void set(int n, IfxObject ifxObject) throws SQLException {
        boolean bl = false;
        int n2 = this.vector.size();
        int n3 = 0;
        n3 = this.getqmarks();
        if (n > n3) {
            throw IfxErrMsg.getSQLException(-79749, this.jconn);
        }
        int n4 = n + this.BatchVector.size() * n3;
        if (n4 > n2) {
            this.vector.setSize(n2 += n3);
        } else {
            Object e = this.vector.elementAt(n4 - 1);
            if (!(e == null || this.usePut && e instanceof IfxBlob)) {
                e = null;
                bl = true;
            }
        }
        this.vector.setElementAt(ifxObject, n4 - 1);
        if (!bl) {
            ++this.inputvals;
        }
        if (this.canUsePut && this.rsmd.needSvrConv(n)) {
            this.setIfxColumnInfo(n, ifxObject);
        }
    }

    private void checkParameterIndex(int n, int n2) throws SQLException {
        if (n > n2) {
            throw IfxErrMsg.getSQLException(-79749, this.jconn);
        }
    }

    private int cntqmarks(String string) {
        return this.cntqmarks(string, null);
    }

    private int cntqmarks(String string, String string2) {
        int n;
        int n2 = 0;
        if (string2 != null && (n = string.indexOf(string2)) != -1) {
            string = string.substring(n);
        }
        if ((n2 = string.indexOf("?")) != -1) {
            n = string.length();
            int n3 = 1;
            ++n2;
            while (n2 < n) {
                int n4 = 0;
                n4 = string.indexOf(63, n2);
                if (n4 < 0) break;
                ++n3;
                n2 = n4 + 1;
            }
            return n3;
        }
        return 0;
    }

    public void addBatch(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": PreparedStatement.addBatch(String).", this.jconn);
    }

    public void addBatch() throws SQLException {
        Object object;
        int n;
        int n2;
        Object object2;
        int n3;
        if (this.jconn == null) {
            throw IfxErrMsg.getSQLException(-79730, this.jconn);
        }
        if (!this.canUsePut) {
            if (this.savedResult != null) {
                this.savedResult.closePrev();
                this.savedResult = null;
            }
            this.commandString = this.commandString.trim();
            if (!this.commandString.endsWith(";")) {
                this.commandString = String.valueOf(this.commandString) + ";";
            }
            this.BatchVector.addElement(this.commandString);
            this.inputcount = this.vector.size();
            return;
        }
        if (!this.usePut) {
            this.usePut = true;
            this.bStream = new IfxByteArrayOutputStream(this.savedResult.getTupleBufferSize());
            this.batchCount = 0;
            if (this.rsmd.hasVariableLengthColumns || this.rsmd.textByteColumnCount > 0) {
                this.putIndexArray = new int[1000];
                this.putIndexArray[0] = 0;
            }
            if (this.rsmd.textByteColumnCount > 0) {
                this.textObjArray.setSize(100);
                this.textObjArrayIdx = 0;
            }
            n3 = 0;
            while (n3 < this.inputvals) {
                object2 = (IfxObject)this.vector.elementAt(n3);
                n2 = ((IfxObject)object2).getIfxType();
                if (n2 == 0 && n2 != (n = this.rsmd.getIfxColumnType(n3 + 1))) {
                    object = IfxValue.makeInstance(this.jconn, ((IfxObject)object2).toString(), this.rsmd.getColumnInfo(n3 + 1));
                    if (this.rsmd.isDistinct(n3 + 1) && object.extendedID == 1) {
                        this.putRsmd.setExtendedOwnerName(n3 + 1, "informix");
                    }
                    this.set(n3 + 1, (IfxObject)object);
                    this.vector.setElementAt(object, n3);
                    object2 = null;
                }
                ++n3;
            }
        }
        if (this.inputvals != this.numqmarks) {
            throw IfxErrMsg.getSQLException(-79749, this.jconn);
        }
        n3 = 0;
        while (n3 < this.inputvals) {
            object2 = (IfxObject)this.vector.elementAt(n3);
            n2 = this.putRsmd.getIfxColumnType(n3 + 1);
            switch (n2) {
                case 0: 
                case 13: 
                case 15: 
                case 16: {
                    String string = ((IfxObject)object2).toString();
                    if (string == null) break;
                    ((IfxObject)object2).fromString(stringUtil.fixLength(string, this.putRsmd.getColumnLength(n3 + 1), ' '));
                    break;
                }
                case 11: 
                case 12: {
                    if (this.textObjArray.size() <= this.textObjArrayIdx) {
                        this.textObjArray.setSize(this.textObjArrayIdx + 100);
                    }
                    if (((IfxBlob)object2).isBlobLoaded() || ((IfxObject)object2).isNull()) {
                        this.textObjArray.setElementAt(null, this.textObjArrayIdx++);
                        break;
                    }
                    this.textObjArray.setElementAt(object2, this.textObjArrayIdx++);
                }
            }
            n = this.putRsmd.getEncodedLength(n3 + 1);
            ((IfxObject)object2).setEncodedLength(n);
            object = ((IfxObject)object2).toIfxTuple();
            this.bStream.write((byte[])object, 0, ((byte[])object).length);
            ++n3;
        }
        if (this.putRsmd.hasVariableLengthColumns || this.putRsmd.textByteColumnCount > 0) {
            if (this.putIndexArray.length < this.batchCount) {
                object2 = new int[this.putIndexArray.length + 1000];
                System.arraycopy(this.putIndexArray, 0, object2, 0, this.putIndexArray.length);
                this.putIndexArray = (int[])object2;
            }
            this.batchCount = (short)(this.batchCount + 1);
            this.putIndexArray[this.batchCount] = this.bStream.getCount();
        } else {
            if ((this.savedResult.getTupleSize() & 1) >= 1) {
                this.bStream.write(0);
            }
            this.batchCount = (short)(this.batchCount + 1);
        }
        this.inputvals = 0;
    }

    public int[] executeBatch() throws SQLException {
        if (!this.usePut) {
            this.commandString = "";
            this.BatchRowCount[0] = 0;
            if (this.BatchVector.size() == 0) {
                throw IfxErrMsg.getSQLException(-79726, this.jconn);
            }
            int n = 0;
            while (n < this.BatchVector.size()) {
                this.commandString = String.valueOf(this.commandString) + this.BatchVector.elementAt(n);
                ++n;
            }
            String string = this.commandString;
            this.setqmarks(this.cntqmarks(string, null));
            this.setupExecutePrepare();
        } else {
            this.curRow = 0;
        }
        this.BatchRowCount[0] = this.executeUpdateImpl();
        this.clearBatch();
        return this.BatchRowCount;
    }

    public void clearBatch() throws SQLException {
        if (this.usePut) {
            this.bStream.resetCount();
            this.batchCount = 0;
            this.curRow = 0;
            this.textObjArrayIdx = 0;
            return;
        }
        this.BatchVector.removeAllElements();
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": PreparedStatement.setCharacterStream(int,Reader,int).", this.jconn);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        long l = time.getTime();
        Time time2 = new Time(l - (long)calendar.get(15) - (long)calendar.get(16));
        this.setTime(n, time2);
    }

    public void setTime(int n, Time time, Calendar calendar, int n2) throws SQLException {
        long l = time.getTime();
        Time time2 = new Time(l - (long)calendar.get(15) - (long)calendar.get(16));
        this.setTime(n, time2, n2);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rsmd;
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        long l = date.getTime();
        Date date2 = new Date(l - (long)calendar.get(15) - (long)calendar.get(16));
        this.setDate(n, date2);
    }

    public void setDate(int n, Date date, Calendar calendar, int n2) throws SQLException {
        long l = date.getTime();
        Date date2 = new Date(l - (long)calendar.get(15) - (long)calendar.get(16));
        this.setDate(n, date2, n2);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        long l = ((java.util.Date)timestamp).getTime();
        Timestamp timestamp2 = new Timestamp(l - (long)calendar.get(15) - (long)calendar.get(16));
        this.setTimestamp(n, timestamp2);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar, int n2) throws SQLException {
        long l = ((java.util.Date)timestamp).getTime();
        Timestamp timestamp2 = new Timestamp(l - (long)calendar.get(15) - (long)calendar.get(16));
        this.setTimestamp(n, timestamp2, n2);
    }

    private IfxColumnInfo getColumnInfo(int n) throws SQLException {
        if (this.rsmd == null) {
            throw IfxErrMsg.getSQLException(-79727, this.jconn);
        }
        if (this.getStatementType() != 6 && this.getStatementType() != 4) {
            return null;
        }
        if (this.rsmd.getColumnCount() == 0) {
            return null;
        }
        if (n > this.rsmd.getColumnCount()) {
            return null;
        }
        try {
            if (this.canUsePut) {
                return this.putRsmd.getColumnInfo(n);
            }
            return this.rsmd.getColumnInfo(n);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    boolean usePut() {
        return this.usePut;
    }

    byte[] getAllRows() {
        return this.bStream.toByteArray();
    }

    byte[] getNextRow() {
        int n = this.putIndexArray[this.curRow];
        int n2 = this.putIndexArray[this.curRow + 1];
        ++this.curRow;
        return this.bStream.toByteArray(n, n2 - n);
    }

    IfxBlob getIfxBlobAt(int n) {
        return (IfxBlob)this.textObjArray.elementAt(n);
    }

    short getBatchCount() {
        return this.batchCount;
    }

    int getIfxBlobArraySize() {
        return this.textObjArray.size();
    }

    void setIfxColumnInfo(int n, IfxObject ifxObject) throws SQLException {
        this.putRsmd.setIfxColumnType(n, ifxObject.ifxType);
        this.putRsmd.setExtendedName(n, ifxObject.extendedName);
        this.putRsmd.setColumnExtendedId(n, ifxObject.extendedID);
        this.putRsmd.setEncodedLength(n, ifxObject.encodedLength);
    }

    ResultSetMetaData getPutMetaData() throws SQLException {
        return this.putRsmd;
    }
}

