/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.memoryUtil;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IfxInt8
extends IfxObject {
    private long value;
    public static final long IFX_INT8_NULL = Long.MIN_VALUE;

    IfxInt8() throws SQLException {
        this.setIfxType(17);
    }

    IfxInt8(long l) throws SQLException {
        this.setIfxType(17);
        this.value = l;
        this.unnullify();
    }

    IfxInt8(Long l) throws SQLException {
        this.setIfxType(17);
        this.value = l;
        this.unnullify();
    }

    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxLongInt(this.value);
    }

    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] byArray = new byte[10];
            memoryUtil.byfill(byArray, (byte)0);
            byArray[1] = 1;
            return byArray;
        }
        return JavaToIfxType.JavaToIfxLongInt(this.value);
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return new Long(this.value);
    }

    public void fromIfx(byte[] byArray) {
        this.value = IfxToJavaType.IfxToJavaLongInt(byArray, (short)0);
        if (this.isIfxNull()) {
            this.nullify();
            return;
        }
        this.unnullify();
    }

    public byte toByte() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (byte)this.value;
    }

    public void fromByte(byte by) throws SQLException {
        this.value = by;
        this.unnullify();
    }

    public void fromByte(Byte by) throws SQLException {
        if (by == null) {
            this.nullify();
            return;
        }
        this.value = by.longValue();
        this.unnullify();
    }

    public short toShort() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (short)this.value;
    }

    public void fromShort(short s) throws SQLException {
        this.value = s;
        this.unnullify();
    }

    public void fromShort(Short s) throws SQLException {
        if (s == null) {
            this.nullify();
            return;
        }
        this.value = s.longValue();
        this.unnullify();
    }

    public int toInt() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (int)this.value;
    }

    public void fromInt(int n) throws SQLException {
        this.value = n;
        this.unnullify();
    }

    public void fromShort(Integer n) throws SQLException {
        if (n == null) {
            this.nullify();
            return;
        }
        this.value = n.longValue();
        this.unnullify();
    }

    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this.value;
    }

    public void fromLong(long l) throws SQLException {
        this.value = l;
        this.unnullify();
    }

    public void fromLong(Long l) throws SQLException {
        if (l == null) {
            this.nullify();
            return;
        }
        this.value = l;
        this.unnullify();
    }

    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value;
    }

    public void fromFloat(float f) throws SQLException {
        this.value = (long)f;
        this.unnullify();
    }

    public void fromFloat(Float f) throws SQLException {
        if (f == null) {
            this.nullify();
            return;
        }
        this.value = f.longValue();
        this.unnullify();
    }

    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value;
    }

    public void fromDouble(double d) {
        this.value = (long)d;
        this.unnullify();
    }

    public void fromDouble(Double d) throws SQLException {
        if (d == null) {
            this.nullify();
            return;
        }
        this.value = d.longValue();
        this.unnullify();
    }

    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal((double)this.value);
    }

    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.nullify();
            return;
        }
        this.value = bigDecimal.longValue();
        this.unnullify();
    }

    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value != 0L;
    }

    public void fromBoolean(boolean bl) throws SQLException {
        this.value = bl ? 1 : 0;
        this.unnullify();
    }

    public void fromBoolean(Boolean bl) throws SQLException {
        if (bl == null) {
            this.nullify();
            return;
        }
        this.value = bl == true ? 1 : 0;
        this.unnullify();
    }

    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return Long.toString(this.value);
    }

    public void fromString(String string) throws SQLException {
        if (string == null) {
            this.nullify();
            return;
        }
        this.value = Long.valueOf(string.trim());
        this.unnullify();
    }

    public boolean equals(Object object) {
        if (this.isNull() || object == null) {
            return false;
        }
        return object instanceof IfxInt8 && this.value == ((IfxInt8)object).value;
    }

    public short getEncodedLength() {
        return 4864;
    }

    public boolean isIfxNull() {
        return this.value == Long.MIN_VALUE;
    }
}

