/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class IfxDriver
implements Driver {
    private static Trace trace = null;
    private String errMsg;
    private int errNum;
    private final String INFORMIXSQLI = "informix-sqli";
    private final String INFORMIXDIRECT = "informix-direct";
    private final String CONNECTIONCLASS = "CONNECTIONCLASS";
    private final String PROTOCOLCLASS = "PROTOCOLCLASS";
    private final String PROXY = "PROXY";
    private final String DEFAULTDIRECTCONN = "com.informix.jdbc.IfxDirectConnection";
    private final String DEFAULTDIRECTPROT = "com.informix.jdbc.IfxDirectProtocol";
    private final String DEFAULTSQLICONN = "com.informix.jdbc.IfxSqliConnect";
    private final String DEFAULTSQLIPROT = "com.informix.jdbc.IfxSqli";
    private String DbName;
    private String SubProtocol;
    private String OrigUrl;
    private String NewUrl;
    private String Proxy;
    private static final String JDBCRelVer = "1.50.J";

    public Connection connect(String string, Properties properties) throws SQLException {
        if (this.checkURL(string)) {
            Object object;
            Class[] classArray;
            Properties properties2 = new Properties();
            Connection connection = null;
            if (properties == null || ((Hashtable)properties).isEmpty()) {
                ((Hashtable)properties2).clear();
            } else {
                classArray = null;
                object = properties.propertyNames();
                while (object.hasMoreElements()) {
                    classArray = object.nextElement().toString();
                    ((Hashtable)properties2).put(classArray.toUpperCase(), ((Hashtable)properties).get(classArray));
                }
                classArray = null;
            }
            this.getPropertiesFromUrl(string, properties2);
            try {
                classArray = new Class[]{string.getClass(), properties2.getClass()};
                object = Class.forName(properties2.getProperty("CONNECTIONCLASS"));
                Constructor constructor = ((Class)object).getConstructor(classArray);
                Object[] objectArray = new Object[]{this.NewUrl, properties2};
                connection = (Connection)constructor.newInstance(objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw (SQLException)invocationTargetException.getTargetException();
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79704, exception.toString(), null);
            }
            return connection;
        }
        return null;
    }

    public boolean acceptsURL(String string) throws SQLException {
        return this.checkURL(string);
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        String[] stringArray = new String[]{"DATABASE", "INFORMIXSERVER", "USER", "PASSWORD"};
        Properties properties2 = new Properties();
        if (!this.checkURL(string)) {
            throw IfxErrMsg.getSQLException(-79705, this.errMsg, null);
        }
        this.getPropertiesFromUrl(string, properties2);
        String string2 = null;
        Properties properties3 = new Properties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string2 = enumeration.nextElement().toString();
            ((Hashtable)properties3).put(string2.toUpperCase(), ((Hashtable)properties).get(string2));
        }
        string2 = null;
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[stringArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (((Hashtable)properties3).get(stringArray[n2]) == null && ((Hashtable)properties2).get(stringArray[n2]) == null) {
                driverPropertyInfoArray[n++] = new DriverPropertyInfo(stringArray[n2].toLowerCase(), null);
            }
            ++n2;
        }
        DriverPropertyInfo[] driverPropertyInfoArray2 = new DriverPropertyInfo[n];
        while (n-- > 0) {
            driverPropertyInfoArray2[n] = driverPropertyInfoArray[n];
        }
        return driverPropertyInfoArray2;
    }

    public int getMajorVersion() {
        try {
            return IfxDriver.getJDBCMajorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public int getMinorVersion() {
        try {
            return IfxDriver.getJDBCMinorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public boolean jdbcCompliant() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean checkURL(String var1_1) throws SQLException {
        block28: {
            block29: {
                block30: {
                    block31: {
                        block27: {
                            var10_2 = true;
                            this.DbName = null;
                            this.SubProtocol = null;
                            this.OrigUrl = null;
                            this.NewUrl = null;
                            if (var1_1.indexOf(58) == -1) {
                                this.errNum = -80004;
                                this.errMsg = String.valueOf(IfxErrMsg.getMinorMsg(-80035, null)) + " '" + var1_1 + "'" + IfxErrMsg.getMinorMsg(-80004, null) + " ':'";
                                return false;
                            }
                            var2_3 = new StringTokenizer(var1_1, ":", true);
                            var5_4 = var2_3.nextToken();
                            if (!var5_4.equalsIgnoreCase("jdbc")) {
                                this.errNum = -79756;
                                this.errMsg = String.valueOf(IfxErrMsg.getMinorMsg(-80035, null)) + " '" + var1_1 + "' " + IfxErrMsg.getMessage(-79756, null);
                                return false;
                            }
                            var9_5 = var2_3.nextToken();
                            var6_6 = var2_3.nextToken();
                            if (var2_3.hasMoreTokens()) {
                                var9_5 = var2_3.nextToken();
                            }
                            if (var6_6 != null && var6_6.charAt(0) == '/' && var6_6.charAt(1) == '/') {
                                var6_6 = var6_6.substring(2, var6_6.length());
                            }
                            if (var6_6.equals("informix-sqli")) {
                                System.getProperty("java.version");
                                this.SubProtocol = new String("informix-sqli");
                                if (var2_3.hasMoreTokens()) {
                                    var6_6 = var2_3.nextToken();
                                }
                                if (var2_3.hasMoreTokens()) {
                                    var9_5 = var2_3.nextToken();
                                }
                            } else if (var6_6.equals("informix-direct")) {
                                this.SubProtocol = new String("informix-direct");
                                var10_2 = false;
                                if (var2_3.hasMoreTokens()) {
                                    var6_6 = var2_3.nextToken();
                                    if (!var6_6.equals(":") && var2_3.hasMoreTokens()) {
                                        var9_5 = var2_3.nextToken();
                                    }
                                } else {
                                    var6_6 = null;
                                }
                            } else {
                                this.errNum = -79757;
                                this.errMsg = String.valueOf(IfxErrMsg.getMessage(-79757, null)) + ": '" + var6_6 + "'";
                                return false;
                            }
                            if (var6_6 != null && var6_6.charAt(0) == '/' && var6_6.charAt(1) == '/') {
                                var6_6 = var6_6.substring(2, var6_6.length());
                            }
                            if (var10_2) break block27;
                            if (var6_6 != null && var6_6.length() > 0 && var6_6.charAt(0) == '/') {
                                var11_7 = var6_6;
                                var4_9 = new StringTokenizer(var11_7, "/");
                                var8_11 = var4_9.nextToken();
                                if (!this.validDatabaseIdentifier(var8_11)) {
                                    this.errNum = -79760;
                                    this.errMsg = String.valueOf(IfxErrMsg.getMessage(-79760, null)) + ": '" + var8_11 + "'";
                                    return false;
                                }
                                this.DbName = new String(var8_11);
                                this.NewUrl = null;
                            }
                            break block28;
                        }
                        var3_13 = new StringTokenizer(var6_6, ".");
                        var11_8 = var3_13.nextToken();
                        if (var11_8.indexOf("=") != -1) break block29;
                        if (var11_8.indexOf("/") != -1) break block30;
                        if (!this.isANum(var11_8)) ** GOTO lbl74
                        if (var3_13.countTokens() == 3 && this.isAIPNum(var11_8)) ** GOTO lbl69
                        throw IfxErrMsg.getSQLException(-79758, ": '" + var6_6 + "'", null);
lbl-1000:
                        // 1 sources

                        {
                            var11_8 = var3_13.nextToken();
                            if (this.isAIPNum(var11_8)) continue;
                            throw IfxErrMsg.getSQLException(-79758, ": '" + var6_6 + "'", null);
lbl69:
                            // 2 sources

                            ** while (var3_13.hasMoreTokens())
                        }
lbl70:
                        // 1 sources

                        break block31;
lbl-1000:
                        // 1 sources

                        {
                            var11_8 = var3_13.nextToken();
                            if (!this.isANum(var11_8)) continue;
                            throw IfxErrMsg.getSQLException(-79758, ": '" + var6_6 + "'", null);
lbl74:
                            // 2 sources

                            ** while (var3_13.hasMoreTokens())
                        }
                    }
                    if (!var2_3.hasMoreTokens()) {
                        throw IfxErrMsg.getSQLException(-79705, null);
                    }
                    var7_14 = var2_3.nextToken();
                    if (var2_3.hasMoreTokens()) {
                        var9_5 = var2_3.nextToken();
                    }
                    if (var7_14 != null && var7_14.indexOf(47) == -1) {
                        if (!this.isANum(var7_14)) {
                            throw IfxErrMsg.getSQLException(-79759, ": '" + var7_14 + "'", null);
                        }
                        this.NewUrl = new String(String.valueOf(var6_6) + ":" + var7_14);
                    } else if (var7_14 != null) {
                        var4_10 = new StringTokenizer(var7_14, "/");
                        if (!this.isANum(var7_14 = var4_10.nextToken())) {
                            throw IfxErrMsg.getSQLException(-79759, ": '" + var7_14 + "'", null);
                        }
                        this.NewUrl = new String(String.valueOf(var6_6) + ":" + var7_14);
                        var8_12 = var4_10.nextToken(":").substring(1);
                        if (var8_12.charAt(0) == '/') {
                            var8_12 = var8_12.substring(1, var8_12.length());
                            var4_10 = new StringTokenizer(var8_12, "/");
                            var4_10.nextToken();
                            var8_12 = var4_10.nextToken();
                        }
                        if (!this.validDatabaseIdentifier(var8_12)) {
                            throw IfxErrMsg.getSQLException(-79760, ": '" + var8_12 + "'", null);
                        }
                        this.DbName = new String(var8_12);
                    }
                    break block28;
                }
                this.DbName = var11_8.substring(1, var11_8.length());
                this.NewUrl = null;
                break block28;
            }
            this.NewUrl = null;
        }
        this.OrigUrl = new String(var1_1);
        return true;
    }

    private boolean isAIPNum(String string) {
        try {
            int n = Integer.parseInt(string);
            return n >= 0 && n <= 255;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean isANum(String string) {
        try {
            Integer n = new Integer(string);
            return n >= 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    void getPropertiesFromUrl(String string, Properties properties) {
        int n;
        int n2 = -1;
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = null;
        StringTokenizer stringTokenizer2 = null;
        if (((Hashtable)properties).get("DATABASE") == null && this.DbName != null) {
            ((Hashtable)properties).put("DATABASE", this.DbName);
        }
        if ((n = string.indexOf(61)) != -1) {
            int n3 = -1;
            while ((n3 = string.indexOf(58, (n2 = n3) + 1)) != -1 && n3 < n) {
            }
            if (n2 == -1) {
                return;
            }
        }
        if ((string2 = string.substring(n2 + 1)) != null) {
            stringTokenizer = new StringTokenizer(string2, ";");
        }
        if (string2 != null && string2.indexOf(61) != -1 && stringTokenizer.hasMoreTokens()) {
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken(";");
                stringTokenizer2 = new StringTokenizer(string3, "=");
                String string4 = stringTokenizer2.nextToken();
                String string5 = stringTokenizer2.nextToken(";").substring(1);
                ((Hashtable)properties).put(string4.toUpperCase(), string5);
            }
        }
        if (this.SubProtocol.equals("informix-direct")) {
            if (((Hashtable)properties).get("PROTOCOLCLASS") == null) {
                ((Hashtable)properties).put("PROTOCOLCLASS", "com.informix.jdbc.IfxDirectProtocol");
            }
            if (((Hashtable)properties).get("CONNECTIONCLASS") == null) {
                ((Hashtable)properties).put("CONNECTIONCLASS", "com.informix.jdbc.IfxDirectConnection");
            }
        } else {
            if (((Hashtable)properties).get("PROTOCOLCLASS") == null) {
                ((Hashtable)properties).put("PROTOCOLCLASS", "com.informix.jdbc.IfxSqli");
            }
            if (((Hashtable)properties).get("CONNECTIONCLASS") == null) {
                ((Hashtable)properties).put("CONNECTIONCLASS", "com.informix.jdbc.IfxSqliConnect");
            }
        }
        if ((this.Proxy = properties.getProperty("PROXY")) != null) {
            this.formatProxy(this.Proxy);
            ((Hashtable)properties).put("PROXY", this.Proxy);
        }
        ((Hashtable)properties).put("USERURL", this.OrigUrl);
        if (this.NewUrl == null && this.SubProtocol.equals("informix-direct")) {
            this.NewUrl = this.OrigUrl;
        }
    }

    private void checkTracing(String string, Properties properties) {
    }

    private boolean validDatabaseIdentifier(String string) {
        int n = 1;
        int n2 = 0;
        String string2 = null;
        n2 = string.lastIndexOf("/");
        string2 = n2 != -1 ? string.substring(n2 + 1) : string;
        int n3 = string2.length();
        char c = string2.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        n = 1;
        while (n < n3) {
            c = string2.charAt(n);
            if (!Character.isLetterOrDigit(c) && c != '_' && c != '#') {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static String calcReleaseNum() {
        return null;
    }

    public static String getJDBCVersion() throws SQLException {
        return "1.50.JC1";
    }

    static int getJDBCMajorVersion() throws SQLException {
        Integer n;
        String string = "1.50.JC1";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = stringTokenizer.nextToken();
        try {
            n = new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw IfxErrMsg.getSQLException(-79716, null);
        }
        return n;
    }

    static int getJDBCMinorVersion() throws SQLException {
        Integer n;
        String string = "1.50.JC1";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (!stringTokenizer.hasMoreTokens()) {
            throw IfxErrMsg.getSQLException(-79716, null);
        }
        stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            throw IfxErrMsg.getSQLException(-79716, null);
        }
        String string2 = stringTokenizer.nextToken();
        try {
            n = new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw IfxErrMsg.getSQLException(-79716, null);
        }
        return n;
    }

    private boolean formatProxy(String string) {
        String string2 = null;
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer("http://");
        try {
            string3 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.toUpperCase().indexOf("HTTP") != -1 || string2.toUpperCase().indexOf("SERVLET") != -1 || string2.toUpperCase().indexOf("JDBCPROXY") != -1) continue;
            string3 = string2;
        }
        stringBuffer.append(string3);
        stringBuffer.append("/servlet/IfxJDBCProxy");
        this.Proxy = new String(stringBuffer.toString());
        return true;
    }

    static {
        try {
            DriverManager.registerDriver(new IfxDriver());
        }
        catch (SQLException sQLException) {
            System.out.println(String.valueOf(IfxErrMsg.getMinorMsg(-80034, null)) + " " + -79704 + "\n" + IfxErrMsg.getMessage(-79704, null));
        }
    }
}

