/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class IfxDecimal
extends IfxObject {
    private BigDecimal value;
    private short encodedLength;
    protected short dec_exp;
    protected short dec_pos = (short)-1;
    protected short dec_ndgts;
    protected byte[] dec_dgts;
    public static final String digChar = "0123456789";
    public static final int DECSIZE = 16;
    public static final short DECPOSNULL = -1;
    public static final short DECPOSPOSITIVE = 1;
    public static final short DECPOSNEGATIVE = 0;
    public static final short BYTESHIFT = 8;
    public static final short BYTEMASK = 255;
    public static final short BYTESIGNED = 128;
    public static final short BYTEMASK7 = 127;
    private static final short DEFAULT_DOUBLE_SCALE = 15;
    private static final short DEFAULT_FLOAT_SCALE = 6;

    public IfxDecimal() throws SQLException {
        this.setIfxType(5);
    }

    public IfxDecimal(BigDecimal bigDecimal) throws SQLException {
        this.encodedLength = 0;
        this.setIfxType(5);
        if (bigDecimal == null) {
            this.isNull = true;
            return;
        }
        this.value = bigDecimal;
        this.isNull = false;
    }

    public IfxDecimal(byte[] byArray) throws SQLException {
        this.encodedLength = 0;
        this.setIfxType(5);
        this.convBigDecimal(byArray);
    }

    public byte[] toIfx() {
        if (this.value == null) {
            byte[] byArray = new byte[4];
            IfxDecimal.byfill(byArray, (byte)0);
            this.isNull = true;
            return byArray;
        }
        this.convFromString(this.value.toString());
        this.isNull = false;
        return this.convIfx(true);
    }

    public byte[] toIfxTuple() {
        if (this.value == null) {
            int n = ((this.encodedLength >> 8 & 0xFF) + (this.encodedLength & 0xFF & 1) + 3) / 2 - 1 + 1;
            byte[] byArray = new byte[n];
            IfxDecimal.byfill(byArray, (byte)0);
            this.isNull = true;
            return byArray;
        }
        this.convFromString(this.value.toString());
        this.isNull = false;
        return this.convIfx(false);
    }

    public void fromIfx(byte[] byArray, short s) {
        this.encodedLength = s;
        this.convBigDecimal(byArray);
        if (this.value == null) {
            this.isNull = true;
            return;
        }
        this.isNull = false;
    }

    public Object toObject() throws SQLException {
        if (this.isNull) {
            return null;
        }
        return this.value;
    }

    public byte toByte() throws SQLException {
        this.clearWarning();
        if (this.isNull) {
            return 0;
        }
        return (byte)this.value.doubleValue();
    }

    public void fromByte(Byte by) throws SQLException {
        this.encodedLength = 0;
        if (by == null) {
            this.isNull = true;
            return;
        }
        this.fromByte((byte)by);
    }

    public void fromByte(Byte by, int n) throws SQLException {
        this.encodedLength = 0;
        if (by == null) {
            this.isNull = true;
            return;
        }
        this.fromByte((byte)by);
        this.value = this.value.setScale(n, 4);
    }

    public void fromByte(byte by) throws SQLException {
        this.encodedLength = 0;
        this.value = new BigDecimal((double)by);
        this.isNull = false;
    }

    public short toShort() throws SQLException {
        if (this.isNull) {
            return 0;
        }
        return (short)this.value.doubleValue();
    }

    public void fromShort(Short s) throws SQLException {
        this.encodedLength = (short)1280;
        if (s == null) {
            this.isNull = true;
            return;
        }
        this.fromShort((short)s);
    }

    public void fromShort(Short s, int n) throws SQLException {
        this.encodedLength = (short)(1280 + n);
        if (s == null) {
            this.isNull = true;
            return;
        }
        this.fromShort((short)s);
        this.value = this.value.setScale(n, 4);
    }

    public void fromShort(short s) throws SQLException {
        this.encodedLength = (short)1280;
        this.value = new BigDecimal((double)s);
        this.isNull = false;
    }

    public int toInt() throws SQLException {
        if (this.isNull) {
            return 0;
        }
        return this.value.intValue();
    }

    public void fromInt(Integer n) throws SQLException {
        this.encodedLength = (short)2560;
        if (n == null) {
            this.isNull = true;
            return;
        }
        this.fromInt((int)n);
    }

    public void fromInt(Integer n, int n2) throws SQLException {
        this.encodedLength = (short)(2560 + n2);
        if (n == null) {
            this.isNull = true;
            return;
        }
        this.fromInt((int)n);
        this.value = this.value.setScale(n2, 4);
    }

    public void fromInt(int n) throws SQLException {
        this.encodedLength = (short)2560;
        this.value = new BigDecimal((double)n);
        this.isNull = false;
    }

    public long toLong() throws SQLException {
        if (this.isNull) {
            return 0L;
        }
        return this.value.longValue();
    }

    public void fromLong(Long l) throws SQLException {
        this.encodedLength = (short)4864;
        if (l == null) {
            this.isNull = true;
            return;
        }
        this.fromLong((long)l);
    }

    public void fromLong(Long l, int n) throws SQLException {
        this.encodedLength = (short)(4864 + n);
        if (l == null) {
            this.isNull = true;
            return;
        }
        this.fromLong((long)l);
        this.value = this.value.setScale(n, 4);
    }

    public void fromLong(long l) throws SQLException {
        this.encodedLength = (short)4864;
        this.value = new BigDecimal((double)l);
        this.isNull = false;
    }

    public float toFloat() throws SQLException {
        if (this.isNull) {
            return 0.0f;
        }
        return this.value.floatValue();
    }

    public void fromFloat(Float f) throws SQLException {
        this.encodedLength = 0;
        if (f == null) {
            this.isNull = true;
            return;
        }
        this.fromFloat(f.floatValue());
    }

    public void fromFloat(Float f, int n) throws SQLException {
        this.encodedLength = 0;
        if (f == null) {
            this.isNull = true;
            return;
        }
        this.value = new BigDecimal(f.doubleValue());
        this.value = this.value.setScale(n, 4);
    }

    public void fromFloat(float f) throws SQLException {
        this.encodedLength = 0;
        this.value = new BigDecimal(f);
        this.value = this.value.setScale(6, 4);
        this.isNull = false;
    }

    public double toDouble() throws SQLException {
        if (this.isNull) {
            return 0.0;
        }
        return this.value.doubleValue();
    }

    public void fromDouble(Double d) throws SQLException {
        this.encodedLength = 0;
        if (d == null) {
            this.isNull = true;
            return;
        }
        this.fromDouble((double)d);
    }

    public void fromDouble(Double d, int n) throws SQLException {
        this.encodedLength = 0;
        if (d == null) {
            this.isNull = true;
            return;
        }
        this.value = new BigDecimal(d);
        this.value = this.value.setScale(n, 4);
    }

    public void fromDouble(double d) throws SQLException {
        this.encodedLength = 0;
        this.value = new BigDecimal(d);
        this.value = this.value.setScale(15, 4);
        this.isNull = false;
    }

    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull) {
            return null;
        }
        return this.value;
    }

    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        this.encodedLength = 0;
        if (bigDecimal == null) {
            this.isNull = true;
            return;
        }
        this.value = bigDecimal;
        this.isNull = false;
    }

    public void fromDecimal(BigDecimal bigDecimal, int n) throws SQLException {
        this.encodedLength = 0;
        if (bigDecimal == null) {
            this.isNull = true;
            return;
        }
        this.value = bigDecimal.setScale(n, 4);
        this.isNull = false;
    }

    public void fromDecimal(BigDecimal bigDecimal, int n, short s) throws SQLException {
        if (bigDecimal == null) {
            this.isNull = true;
            return;
        }
        this.value = bigDecimal.setScale(n, 4);
        this.encodedLength = s;
        this.isNull = false;
    }

    public boolean toBoolean() throws SQLException {
        if (this.isNull) {
            return false;
        }
        return this.value.intValue() != 0;
    }

    public void fromBoolean(Boolean bl) throws SQLException {
        this.encodedLength = 0;
        if (bl == null) {
            this.isNull = true;
            return;
        }
        this.fromBoolean((boolean)bl);
    }

    public void fromBoolean(Boolean bl, int n) throws SQLException {
        this.encodedLength = 0;
        if (bl == null) {
            this.isNull = true;
            return;
        }
        this.fromBoolean((boolean)bl);
        this.value = this.value.setScale(n, 4);
    }

    public void fromBoolean(boolean bl) throws SQLException {
        this.encodedLength = 0;
        this.value = new BigDecimal((double)(bl ? 1 : 0));
        this.isNull = false;
    }

    public String toString() {
        if (this.isNull) {
            return null;
        }
        return this.value.toString();
    }

    public void fromString(String string) throws SQLException {
        this.encodedLength = 0;
        if (string == null) {
            this.isNull = true;
            return;
        }
        this.value = new BigDecimal(string.trim());
        this.isNull = false;
    }

    public void fromString(String string, int n) throws SQLException {
        this.encodedLength = 0;
        if (string == null) {
            this.isNull = true;
            return;
        }
        this.value = new BigDecimal(string.trim());
        this.value = this.value.setScale(n, 4);
        this.isNull = false;
    }

    public boolean equals(Object object) {
        if (this.isNull || object == null) {
            return false;
        }
        return object instanceof IfxDecimal && this.value.equals(((IfxDecimal)object).value);
    }

    public short getEncodedLength() {
        if (this.encodedLength == 0 && !this.isNull) {
            this.computeEncodedLength();
            return this.encodedLength;
        }
        return this.encodedLength;
    }

    public void setEncodedLength(int n) {
        this.encodedLength = (short)n;
    }

    private void convBigDecimal(byte[] byArray) {
        if (byArray[0] == 0 && byArray[1] == 0) {
            this.value = null;
            return;
        }
        this.dec_ndgts = this.encodedLength == 0 ? (short)(byArray.length - 1) : (short)(((this.encodedLength >> 8 & 0xFF) + (this.encodedLength & 0xFF & 1) + 3) / 2 - 1);
        this.dec_dgts = new byte[this.dec_ndgts];
        IfxDecimal.bycopy(byArray, 1, this.dec_dgts, 0);
        short s = byArray[0];
        this.dec_pos = 1;
        if ((s & 0x80) == 0) {
            IfxDecimal.decComplement(this.dec_dgts, 0);
            s = (short)(s ^ 0x7F);
            this.dec_pos = 0;
        }
        this.dec_exp = s = (short)((s & 0x7F) - 64);
        this.value = new BigDecimal(this.stringValue());
        if (this.encodedLength != 0) {
            int n = this.encodedLength;
            if ((n &= 0xFF) != 255) {
                this.value = this.value.setScale(n, 4);
            }
        }
        if (this.value == null) {
            this.isNull = true;
            return;
        }
        this.isNull = false;
    }

    private void convFromString(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        boolean bl = false;
        int n4 = 0;
        this.dec_pos = 1;
        char c = string.charAt(0);
        if (c == '-') {
            this.dec_pos = 0;
            ++n;
        } else if (c == '+') {
            ++n;
        }
        if (n > 0) {
            --n3;
        }
        int n5 = n;
        while (n5 < string.length() && string.charAt(n5) != '.') {
            ++n2;
            ++n5;
        }
        if (n5 != string.length()) {
            bl = true;
            --n3;
            n2 += this.extractExponent(string, n5);
        }
        if (n2 % 2 != 0) {
            ++n3;
            this.dec_exp = (short)((n2 + 1) / 2);
            n4 = 1;
        } else {
            this.dec_exp = (short)(n2 / 2);
        }
        byte[] byArray = new byte[n3];
        IfxDecimal.byfill(byArray, (byte)0);
        String string2 = n4 == 1 ? "0" : "";
        n5 = 0;
        while (n5 < string.length() && string.charAt(n5) != 'E') {
            int n6 = digChar.indexOf(string.charAt(n5));
            if (n6 != -1) {
                byArray[n4] = (byte)n6;
                string2 = String.valueOf(string2) + string.charAt(n5);
                ++n4;
            }
            ++n5;
        }
        byArray = this.adjust(byArray, string2);
        n3 = byArray.length;
        this.dec_ndgts = (short)(n3 / 2);
        this.dec_dgts = new byte[this.dec_ndgts];
        int n7 = 0;
        while (n7 < this.dec_dgts.length) {
            this.dec_dgts[n7] = (byte)(byArray[2 * n7] * 10 + byArray[2 * n7 + 1]);
            ++n7;
        }
        if (this.encodedLength == 0) {
            this.computeEncodedLength();
            return;
        }
        this.dec_ndgts = (short)(((this.encodedLength >> 8 & 0xFF) + (this.encodedLength & 0xFF & 1) + 3) / 2 - 1);
    }

    private byte[] adjust(byte[] byArray, String string) {
        int n;
        int n2;
        int n3 = 0;
        if (this.encodedLength != 0) {
            short s = this.encodedLength;
            n2 = s >> 8 & 0xFF;
            n = n2 / 2;
            if (n2 % 2 == 1) {
                ++n;
            }
            s = this.encodedLength;
            n3 = (s & 0xFF) / 2;
        } else {
            n2 = 32;
            n = 16;
        }
        byte[] byArray2 = byArray;
        if (byArray.length > n2) {
            BigInteger bigInteger = new BigInteger(string);
            BigInteger bigInteger2 = new BigInteger("10");
            BigInteger bigInteger3 = new BigInteger("1");
            int n4 = 0;
            while (n4 < byArray.length - n2) {
                bigInteger3 = bigInteger3.multiply(bigInteger2);
                ++n4;
            }
            BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(bigInteger3);
            int n5 = 0;
            if (byArray.length > n2 + 1) {
                n5 = byArray[n2];
            }
            if (byArray.length > n2 + 2) {
                n5 *= 10;
                n5 += byArray[n2 + 1];
            }
            if (n5 >= 50) {
                bigIntegerArray[0] = bigIntegerArray[0].add(new BigInteger("1"));
            }
            String string2 = bigIntegerArray[0].toString();
            int n6 = 0;
            if (string.charAt(0) == '0') {
                ++n6;
                string2 = String.valueOf(string2) + "0";
            }
            byte[] byArray3 = new byte[n2];
            IfxDecimal.byfill(byArray3, (byte)0);
            int n7 = 0;
            while (n6 < n2 && n7 < string2.length()) {
                int n8 = digChar.indexOf(string2.charAt(n7));
                if (n8 != -1) {
                    byArray3[n6] = (byte)n8;
                }
                ++n7;
                ++n6;
            }
            byArray2 = byArray3;
        } else if (byArray.length < n2 && n3 != 0 && this.encodedLength != 0) {
            byArray2 = new byte[n2];
            IfxDecimal.byfill(byArray2, (byte)0);
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        return byArray2;
    }

    protected void computeEncodedLength() {
        if (this.dec_ndgts == 0 || this.dec_pos == -1) {
            this.encodedLength = 0;
            return;
        }
        int n = 2 * (this.dec_ndgts - this.dec_exp);
        int n2 = 2 * this.dec_ndgts;
        if (this.dec_dgts[this.dec_ndgts - 1] % 10 == 0) {
            --n;
            --n2;
        }
        if (this.dec_dgts[0] < 10) {
            --n2;
        }
        if (n < 0) {
            n2 += -n;
            n = 0;
        }
        this.encodedLength = (short)(((byte)n2 << 8) + n);
    }

    protected int extractExponent(String string, int n) {
        int n2 = 0;
        boolean bl = true;
        int n3 = n;
        while (n3 < string.length() && string.charAt(n3) != 'E') {
            ++n3;
        }
        if (n3 == string.length()) {
            return n2;
        }
        if (string.charAt(++n3) == '+') {
            ++n3;
        } else if (string.charAt(n3) == '-') {
            ++n3;
            bl = false;
        }
        int n4 = n3;
        while (n4 < string.length()) {
            n2 = n2 * 10 + digChar.indexOf(string.charAt(n4));
            ++n4;
        }
        if (bl) {
            return n2;
        }
        return -n2;
    }

    private byte[] convIfx(boolean bl) {
        int n = bl ? 2 : 0;
        byte[] byArray = new byte[this.dec_ndgts + 1 + n];
        IfxDecimal.byfill(byArray, (byte)0);
        if (bl) {
            int n2 = this.dec_ndgts + 1;
            byArray[0] = (byte)(n2 >> 8 & 0xFF);
            byArray[1] = (byte)(n2 & 0xFF);
        }
        if (this.dec_pos == -1) {
            return byArray;
        }
        byArray[n] = (byte)(this.dec_exp + 64 & 0x7F);
        IfxDecimal.bycopy(this.dec_dgts, 0, byArray, n + 1);
        if (this.dec_pos == 0) {
            if (this.dec_ndgts == 0) {
                int n3 = n;
                byArray[n3] = (byte)(byArray[n3] | 0x80);
            } else {
                IfxDecimal.decComplement(byArray, 1 + n);
                int n4 = n;
                byArray[n4] = (byte)(byArray[n4] ^ 0x7F);
            }
        } else {
            int n5 = n;
            byArray[n5] = (byte)(byArray[n5] | 0x80);
        }
        return byArray;
    }

    private static byte[] byfill(byte[] byArray, byte by) {
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = by;
            ++n;
        }
        return byArray;
    }

    private static char[] charfill(char[] cArray, int n, int n2, char c) {
        int n3 = n;
        while (n3 <= n2 && n3 < cArray.length) {
            cArray[n3] = c;
            ++n3;
        }
        return cArray;
    }

    private static void bycopy(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n2;
        int n4 = n;
        while (n4 < byArray.length && n3 < byArray2.length) {
            byArray2[n3] = byArray[n4];
            ++n4;
            ++n3;
        }
    }

    private static void charcopy(char[] cArray, int n, int n2, char[] cArray2, int n3) {
        int n4 = n3;
        int n5 = n;
        while (n5 < cArray.length && n5 <= n2 && n4 < cArray2.length) {
            cArray2[n4] = cArray[n5];
            ++n5;
            ++n4;
        }
    }

    private static byte[] decComplement(byte[] byArray, int n) {
        int n2 = 100;
        int n3 = byArray.length - 1;
        while (n3 >= n) {
            if (byArray[n3] != 0 || n2 != 100) {
                byArray[n3] = (byte)(n2 - byArray[n3]);
                n2 = 99;
            }
            --n3;
        }
        return byArray;
    }

    private char[] sigdigToChar() {
        char[] cArray = new char[this.dec_ndgts * 2];
        int n = 0;
        while (n < this.dec_ndgts) {
            cArray[n * 2] = digChar.charAt(this.dec_dgts[n] / 10);
            cArray[n * 2 + 1] = digChar.charAt(this.dec_dgts[n] % 10);
            ++n;
        }
        return cArray;
    }

    private String stringValue() {
        char[] cArray;
        if (this.dec_pos == -1) {
            return "";
        }
        int n = this.dec_exp * 2;
        if (this.dec_ndgts <= 0 && this.dec_exp == 0) {
            return "0.0";
        }
        char[] cArray2 = this.sigdigToChar();
        if (n > 0) {
            if (n <= cArray2.length) {
                cArray = new char[cArray2.length + 2];
                IfxDecimal.charcopy(cArray2, 0, n - 1, cArray, 1);
                cArray[n + 1] = 46;
                if (n != cArray2.length) {
                    IfxDecimal.charcopy(cArray2, n, cArray2.length - 1, cArray, n + 2);
                }
            } else {
                cArray = new char[n + 2];
                IfxDecimal.charcopy(cArray2, 0, cArray2.length - 1, cArray, 1);
                IfxDecimal.charfill(cArray, cArray2.length + 1, n, '0');
                cArray[n + 1] = 46;
            }
        } else {
            cArray = new char[(n *= -1) + cArray2.length + 3];
            cArray[1] = 48;
            cArray[2] = 46;
            IfxDecimal.charfill(cArray, 3, n + 2, '0');
            IfxDecimal.charcopy(cArray2, 0, cArray2.length, cArray, n + 3);
        }
        char[] cArray3 = IfxDecimal.trimZerosFB(cArray, 1);
        cArray3[0] = this.dec_pos == 1 ? 48 : 45;
        return new String(cArray3);
    }

    private static char[] trimZerosFB(char[] cArray, int n) {
        int n2 = n;
        while (n2 < cArray.length && cArray[n2] == '0') {
            ++n2;
        }
        if (n2 == cArray.length) {
            char[] cArray2 = new char[2];
            cArray2[1] = 48;
            return cArray2;
        }
        int n3 = cArray.length - 1;
        while (n3 >= n2 && cArray[n3] == '0') {
            --n3;
        }
        char[] cArray3 = new char[n3 - n2 + 2];
        int n4 = 1;
        int n5 = n2;
        while (n5 <= n3) {
            cArray3[n4] = cArray[n5];
            ++n5;
            ++n4;
        }
        return cArray3;
    }

    protected static int precTot(int n) {
        return n >> 8 & 0xFF;
    }

    protected static int precDec(int n) {
        return n & 0xFF;
    }

    protected static String getIfxTypeName(int n) {
        int n2 = n & 0xFF;
        if (n2 == 255) {
            return "decimal(16)";
        }
        return "decimal(" + (n >> 8 & 0xFF) + ", " + n2 + ")";
    }
}

