/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.dateUtil;
import com.informix.util.memoryUtil;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class IfxDate
extends IfxObject {
    private java.sql.Date value;
    public static final int IFX_DATE_NULL = Integer.MIN_VALUE;

    IfxDate() throws SQLException {
        this.setIfxType(7);
    }

    IfxDate(java.sql.Date date) throws SQLException {
        this.setIfxType(7);
        this.value = date;
        if (this.value == null) {
            this.nullify();
            return;
        }
        this.unnullify();
    }

    public java.sql.Date value() {
        return this.value;
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxDate(this.value);
    }

    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] byArray = new byte[4];
            memoryUtil.byfill(byArray, (byte)0);
            byArray[0] = -128;
            return byArray;
        }
        return JavaToIfxType.JavaToIfxDate(this.value);
    }

    public void fromIfx(byte[] byArray) {
        this.value = IfxToJavaType.IfxToJavaDate(byArray, (short)0);
        if (this.value == null) {
            this.nullify();
            return;
        }
        this.unnullify();
    }

    public String toString() {
        String string = null;
        if (this.isNull()) {
            return null;
        }
        try {
            string = dateUtil.convertDateStr(this.value, this.conn);
        }
        catch (SQLException sQLException) {
            string = null;
            return null;
        }
        return string;
    }

    public void fromString(String string) throws SQLException {
        if (string == null) {
            this.nullify();
            return;
        }
        try {
            this.value = dateUtil.convertDateObj(string.trim(), this.conn);
            this.unnullify();
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.nullify();
            throw IfxErrMsg.getSQLException(-79716, illegalArgumentException.toString(), this.conn);
        }
    }

    public Timestamp toTimestamp() {
        if (this.isNull()) {
            return null;
        }
        return new Timestamp(this.value.getTime());
    }

    public void fromTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            this.nullify();
            return;
        }
        this.value = new java.sql.Date(((Date)timestamp).getTime());
        this.unnullify();
    }

    public java.sql.Date toDate() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public void fromDate(java.sql.Date date) {
        if (date == null) {
            this.nullify();
            return;
        }
        this.value = date;
        this.unnullify();
    }

    public boolean equals(Object object) {
        if (this.isNull() || object == null || !(object instanceof IfxDate)) {
            return false;
        }
        IfxDate ifxDate = (IfxDate)object;
        if (ifxDate.isNull()) {
            return false;
        }
        return this.value.equals(ifxDate.value);
    }
}

