/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxScrollableResultSet;
import com.informix.util.IfxErrMsg;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;

public class IfxClientResultSet
extends IfxScrollableResultSet {
    private int rowIndex = -1;
    private Vector rowVector = new Vector();

    public IfxClientResultSet() throws SQLException {
    }

    public IfxClientResultSet(Connection connection, ResultSetMetaData resultSetMetaData) throws SQLException {
        this.rsmd = (IfxResultSetMetaData)resultSetMetaData;
        this.conn = (IfxConnection)connection;
        this.insertMode = true;
        this.rowVector.setSize(20);
    }

    public void executeQuery() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.executeQuery().", this.conn);
    }

    public int executeUpdate() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.executeUpdate().", this.conn);
    }

    public void execute() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxClientResultSet.execute().", this.conn);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rsmd;
    }

    public boolean next() throws SQLException {
        if (this.rowVector == null) {
            return false;
        }
        if (this.curRowID >= this.rowIndex + 1) {
            return false;
        }
        ++this.curRowID;
        this.colVector = this.insertRowVector = (Vector)this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    public void newRow() throws SQLException {
        if (this.rowVector == null) {
            this.insertMode = true;
            this.rowVector = new Vector();
            this.rowVector.setSize(20);
            this.rowIndex = -1;
        }
        super.moveToInsertRow();
        this.add();
        Vector vector = new Vector();
        vector.setSize(this.rsmd.getColumnCount());
        this.rowVector.setElementAt(vector, this.rowIndex);
        this.curRowID = this.rowIndex + 1;
    }

    public void newRow(int n) throws SQLException {
        int n2 = this.curRowID;
        int n3 = 0;
        while (n3 < n) {
            this.newRow();
            ++n3;
        }
        this.curRowID = n2 + 1;
    }

    public int getRow() throws SQLException {
        return this.rowIndex + 1;
    }

    public boolean absolute(int n) throws SQLException {
        if (this.rowIndex == -1) {
            return false;
        }
        if (n > this.rowIndex + 1) {
            this.curRowID = this.rowIndex + 1 + 1;
            return false;
        }
        if (n < 0) {
            this.curRowID = this.rowIndex - (Math.abs(n) - 1) - 1;
            if (this.curRowID < 0) {
                this.curRowID = -1;
                return false;
            }
        } else {
            this.curRowID = n;
        }
        this.colVector = this.insertRowVector = (Vector)this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    public boolean previous() throws SQLException {
        if (this.curRowID <= 0) {
            return false;
        }
        --this.curRowID;
        this.colVector = this.insertRowVector = (Vector)this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    public boolean relative(int n) throws SQLException {
        int n2 = this.curRowID + n;
        if (n2 > this.rowIndex + 1 || n2 < 0) {
            return false;
        }
        this.curRowID = n2;
        this.colVector = this.insertRowVector = (Vector)this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    public void beforeFirst() throws SQLException {
        this.curRowID = 0;
    }

    public boolean first() throws SQLException {
        if (this.curRowID < 0) {
            return false;
        }
        this.curRowID = 1;
        this.colVector = this.insertRowVector = (Vector)this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    public boolean last() throws SQLException {
        if (this.curRowID < 0) {
            return false;
        }
        this.curRowID = this.rowIndex + 1;
        this.colVector = this.insertRowVector = (Vector)this.rowVector.elementAt(this.curRowID - 1);
        return true;
    }

    public void updateNull(int n, int n2) throws SQLException {
        if (this.absolute(n)) {
            this.updateNull(n2);
            return;
        }
        throw IfxErrMsg.getSQLException(-79703, this.conn);
    }

    public void updateNull(int n, String string) throws SQLException {
        this.updateNull(n, this.findColumn(string));
    }

    public void updateBoolean(int n, int n2, boolean bl) throws SQLException {
        if (this.absolute(n)) {
            this.updateBoolean(n2, bl);
            return;
        }
        throw IfxErrMsg.getSQLException(-79703, this.conn);
    }

    public void updateBoolean(int n, String string, boolean bl) throws SQLException {
        this.updateBoolean(n, this.findColumn(string), bl);
    }

    public void updateByte(int n, int n2, byte by) throws SQLException {
        if (this.absolute(n)) {
            this.updateByte(n2, by);
            return;
        }
        throw IfxErrMsg.getSQLException(-79703, this.conn);
    }

    public void updateByte(int n, String string, byte by) throws SQLException {
        this.updateByte(n, this.findColumn(string), by);
    }

    public void updateShort(int n, int n2, short s) throws SQLException {
        if (this.absolute(n)) {
            this.updateShort(n2, s);
            return;
        }
        throw IfxErrMsg.getSQLException(-79703, this.conn);
    }

    public void updateShort(int n, String string, short s) throws SQLException {
        this.updateShort(n, this.findColumn(string), s);
    }

    public void updateInt(int n, int n2, int n3) throws SQLException {
        if (this.absolute(n)) {
            this.updateInt(n2, n3);
            return;
        }
        throw IfxErrMsg.getSQLException(-79703, this.conn);
    }

    public void updateInt(int n, String string, int n2) throws SQLException {
        this.updateInt(n, this.findColumn(string), n2);
    }

    public void updateLong(int n, int n2, long l) throws SQLException {
        if (this.absolute(n)) {
            this.updateLong(n2, l);
            return;
        }
        throw IfxErrMsg.getSQLException(-79703, this.conn);
    }

    public void updateLong(int n, String string, long l) throws SQLException {
        this.updateLong(n, this.findColumn(string), l);
    }

    public void updateFloat(int n, int n2, float f) throws SQLException {
        if (this.absolute(n)) {
            this.updateFloat(n2, f);
            return;
        }
        throw IfxErrMsg.getSQLException(-79703, this.conn);
    }

    public void updateFloat(int n, String string, float f) throws SQLException {
        this.updateFloat(n, this.findColumn(string), f);
    }

    public void updateDouble(int n, int n2, double d) throws SQLException {
        if (this.absolute(n)) {
            this.updateDouble(n2, d);
            return;
        }
        throw IfxErrMsg.getSQLException(-79703, this.conn);
    }

    public void updateDouble(int n, String string, double d) throws SQLException {
        this.updateDouble(n, this.findColumn(string), d);
    }

    public void updateBigDecimal(int n, int n2, BigDecimal bigDecimal) throws SQLException {
        if (this.absolute(n)) {
            this.updateBigDecimal(n2, bigDecimal);
            return;
        }
        throw IfxErrMsg.getSQLException(-79703, this.conn);
    }

    public void updateBigDecimal(int n, String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(n, this.findColumn(string), bigDecimal);
    }

    public void updateString(int n, int n2, String string) throws SQLException {
        if (this.absolute(n)) {
            this.updateString(n2, string);
            return;
        }
        throw IfxErrMsg.getSQLException(-79703, this.conn);
    }

    public void updateString(int n, String string, String string2) throws SQLException {
        this.updateString(n, this.findColumn(string), string2);
    }

    public void updateBytes(int n, int n2, byte[] byArray) throws SQLException {
        if (this.absolute(n)) {
            this.updateBytes(n2, byArray);
            return;
        }
        throw IfxErrMsg.getSQLException(-79703, this.conn);
    }

    public void updateBytes(int n, String string, byte[] byArray) throws SQLException {
        this.updateBytes(n, this.findColumn(string), byArray);
    }

    public void updateDate(int n, int n2, Date date) throws SQLException {
        if (this.absolute(n)) {
            this.updateDate(n2, date);
            return;
        }
        throw IfxErrMsg.getSQLException(-79703, this.conn);
    }

    public void updateDate(int n, String string, Date date) throws SQLException {
        this.updateDate(n, this.findColumn(string), date);
    }

    public void updateTime(int n, int n2, Time time) throws SQLException {
        if (this.absolute(n)) {
            this.updateTime(n2, time);
            return;
        }
        throw IfxErrMsg.getSQLException(-79703, this.conn);
    }

    public void updateTime(int n, String string, Time time) throws SQLException {
        this.updateTime(n, this.findColumn(string), time);
    }

    public void updateTimestamp(int n, int n2, Timestamp timestamp) throws SQLException {
        if (this.absolute(n)) {
            this.updateTimestamp(n2, timestamp);
            return;
        }
        throw IfxErrMsg.getSQLException(-79703, this.conn);
    }

    public void updateTimestamp(int n, String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(n, this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(int n, int n2, InputStream inputStream, int n3) throws SQLException {
        if (this.absolute(n)) {
            this.updateAsciiStream(n2, inputStream, n3);
            return;
        }
        throw IfxErrMsg.getSQLException(-79703, this.conn);
    }

    public void updateAsciiStream(int n, String string, InputStream inputStream, int n2) throws SQLException {
        this.updateAsciiStream(n, this.findColumn(string), inputStream, n2);
    }

    public void updateBinaryStream(int n, int n2, InputStream inputStream, int n3) throws SQLException {
        if (this.absolute(n)) {
            this.updateBinaryStream(n2, inputStream, n3);
            return;
        }
        throw IfxErrMsg.getSQLException(-79703, this.conn);
    }

    public void updateBinaryStream(int n, String string, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(n, this.findColumn(string), inputStream, n2);
    }

    public void updateObject(int n, int n2, Object object) throws SQLException {
        if (this.absolute(n)) {
            this.updateObject(n2, object);
            return;
        }
        throw IfxErrMsg.getSQLException(-79703, this.conn);
    }

    public void updateObject(int n, String string, Object object) throws SQLException {
        this.updateObject(n, this.findColumn(string), object);
    }

    public void deleteRow(int n) throws SQLException {
        this.rowVector.removeElementAt(n - 1);
        --this.rowIndex;
    }

    public void deleteAllRows() {
        if (this.rowVector != null) {
            int n = 0;
            while (n < this.rowIndex) {
                Vector vector = (Vector)this.rowVector.elementAt(n);
                vector.removeAllElements();
                ++n;
            }
            this.rowVector.removeAllElements();
            this.rowVector = null;
        }
    }

    private void add() {
        if (this.rowIndex + 1 >= this.rowVector.size()) {
            this.rowVector.setSize(this.rowIndex + 20);
        }
        ++this.rowIndex;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public String getCursorName() throws SQLException {
        return "ClientResultCurs";
    }

    public void close() {
        this.deleteAllRows();
        this.insertRowVector = null;
        this.colVector = null;
    }

    protected void finalize() {
        this.close();
    }
}

