/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;

public class IfxDataOutputStream
extends FilterOutputStream {
    protected int written = 0;
    private OutputStream os;
    static final int one = 1;

    public IfxDataOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.os = outputStream;
    }

    public final void write(int n) throws IOException {
        this.os.write(n);
        ++this.written;
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        this.os.write(byArray, n, n2);
        this.written += n2;
    }

    public final void writePadded(byte[] byArray, int n, int n2) throws IOException {
        this.os.write(byArray, n, n2);
        this.written += n2;
        if ((n2 & 1) >= 1) {
            this.os.write(0);
            ++this.written;
        }
    }

    public final void write(byte[] byArray) throws IOException {
        int n = byArray.length;
        this.os.write(byArray, 0, n);
        this.written += n;
    }

    public final void writePadded(byte[] byArray) throws IOException {
        int n = byArray.length;
        this.os.write(byArray, 0, n);
        this.written += n;
        if ((byArray.length & 1) >= 1) {
            this.os.write(0);
            ++this.written;
        }
    }

    public final void writeInt(int n) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxInt(n);
        int n2 = byArray.length;
        this.os.write(byArray, 0, n2);
        this.written += n2;
    }

    public final void flush() throws IOException {
        this.os.flush();
    }

    public final void writeByte(int n) throws IOException {
        this.os.write(n);
        ++this.written;
    }

    public final void writeBytes(String string) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxChar(string);
        int n = byArray.length - 2;
        this.os.write(byArray, 2, n);
        this.written += n;
    }

    public final void writeBytes(String string, String string2) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxChar(string, string2);
        int n = byArray.length - 2;
        this.os.write(byArray, 2, n);
        this.written += n;
    }

    public final void writeChar(String string) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxChar(string);
        int n = byArray.length;
        this.os.write(byArray, 0, n);
        this.written += n;
        if ((byArray.length & 1) >= 1) {
            this.os.write(0);
            ++this.written;
        }
    }

    public final void writeChar(String string, String string2) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxChar(string, string2);
        int n = byArray.length;
        this.os.write(byArray, 0, n);
        this.written += n;
        if ((byArray.length & 1) >= 1) {
            this.os.write(0);
            ++this.written;
        }
    }

    public final void writeChars(String string) throws IOException {
        this.writeChar(string);
    }

    public final void writeDate(Date date) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxDate(date);
        int n = byArray.length;
        this.os.write(byArray, 0, n);
        this.written += n;
    }

    public final void writeDateTime(Timestamp timestamp) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxDateTime(timestamp);
        int n = byArray.length;
        this.os.write(byArray, 0, n);
        this.written += n;
        if ((byArray.length & 1) >= 1) {
            this.os.write(0);
            ++this.written;
        }
    }

    public final void writeInterval(IntervalDF intervalDF) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxInterval(intervalDF);
        int n = byArray.length;
        this.os.write(byArray, 0, n);
        this.written += n;
        if ((byArray.length & 1) >= 1) {
            this.os.write(0);
            ++this.written;
        }
    }

    public final void writeInterval(IntervalYM intervalYM) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxInterval(intervalYM);
        int n = byArray.length;
        this.os.write(byArray, 0, n);
        this.written += n;
        if ((byArray.length & 1) >= 1) {
            this.os.write(0);
            ++this.written;
        }
    }

    public final void writeDecimal(BigDecimal bigDecimal) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxDecimal(bigDecimal);
        int n = byArray.length;
        this.os.write(byArray, 0, n);
        this.written += n;
        if ((byArray.length & 1) >= 1) {
            this.os.write(0);
            ++this.written;
        }
    }

    public final void writeDouble(double d) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxDouble(d);
        int n = byArray.length;
        this.os.write(byArray, 0, n);
        this.written += n;
        if ((byArray.length & 1) >= 1) {
            this.os.write(0);
            ++this.written;
        }
    }

    public final void writeReal(float f) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxReal(f);
        int n = byArray.length;
        this.os.write(byArray, 0, n);
        this.written += n;
        if ((byArray.length & 1) >= 1) {
            this.os.write(0);
            ++this.written;
        }
    }

    public final void writeSmallInt(short s) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxSmallInt(s);
        int n = byArray.length;
        this.os.write(byArray, 0, n);
        this.written += n;
    }

    public final void writeShort(int n) throws IOException {
        short s = (short)n;
        this.writeSmallInt(s);
    }

    public final void writeShort(short s) throws IOException {
        this.writeSmallInt(s);
    }

    public final void writeLongInt(long l) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxLongInt(l);
        int n = byArray.length;
        this.os.write(byArray, 0, n);
        this.written += n;
    }

    public final void writeLong(long l) throws IOException {
        this.writeLongInt(l);
    }
}

