/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.recorder;

import com.fr.performance.EnginePerformanceManager;
import com.fr.performance.PerformanceManager;
import com.fr.performance.info.IReportPerformanceInfo;
import com.fr.performance.info.PerformanceInfo;
import com.fr.performance.info.ReportPerformanceInfo;
import com.fr.performance.recorder.LoggerPerformanceRecorder;
import com.fr.performance.recorder.PerformanceInfoRecorder;
import com.fr.performance.recorder.PerformanceInfoRecorderImpl;
import com.fr.performance.recorder.PerformanceRecorder;
import com.fr.performance.recorder.PerformanceRecorderChain;
import com.fr.performance.recorder.PerformanceRecorderManager;
import com.fr.web.core.SessionIDInfor;
import java.util.Map;

public class PerformanceRecorderManagerImpl
implements PerformanceRecorderManager {
    private static ThreadLocal<PerformanceRecorder> recorderThreadLocal = new ThreadLocal();
    private static ThreadLocal<Boolean> recordEnable = new ThreadLocal();
    private static final PerformanceRecorderManagerImpl PERFORMANCE_RECORDER_MANAGER = new PerformanceRecorderManagerImpl();

    private PerformanceRecorderManagerImpl() {
    }

    public static PerformanceRecorderManagerImpl getInstance() {
        return PERFORMANCE_RECORDER_MANAGER;
    }

    public void reset() {
        recorderThreadLocal.remove();
        recordEnable.set(true);
        PerformanceManager.sessionIDInforThreadLocal.remove();
    }

    public boolean isEnabled() {
        Boolean bl = recordEnable.get();
        if (bl == null) {
            return true;
        }
        return bl;
    }

    public void setThreadEnabled(boolean bl) {
        recordEnable.set(bl);
    }

    public SessionIDInfor getThreadSessionIDInfo() {
        return EnginePerformanceManager.getThreadSession();
    }

    public PerformanceRecorder getThreadPerformanceRecorder() {
        PerformanceRecorder performanceRecorder = recorderThreadLocal.get();
        if (performanceRecorder == null) {
            performanceRecorder = this.createPerformanceRecorderChain();
            SessionIDInfor sessionIDInfor = this.getThreadSessionIDInfo();
            if (sessionIDInfor != null) {
                performanceRecorder.setWorkBookName(sessionIDInfor.getBookPath());
                Map map = sessionIDInfor.getParameterMap4Execute();
                performanceRecorder.recordParameterMap(map);
            }
            recorderThreadLocal.set(performanceRecorder);
        }
        return performanceRecorder;
    }

    private PerformanceRecorder createPerformanceRecorderChain() {
        PerformanceRecorderChain performanceRecorderChain = new PerformanceRecorderChain();
        performanceRecorderChain.addRecorder(this.getPerformanceRecorderBySession());
        performanceRecorderChain.addRecorder((PerformanceRecorder)new LoggerPerformanceRecorder());
        return performanceRecorderChain.buildRecorderChain();
    }

    private PerformanceRecorder getPerformanceRecorderBySession() {
        SessionIDInfor sessionIDInfor = EnginePerformanceManager.getThreadSession();
        PerformanceInfoRecorderImpl performanceInfoRecorderImpl = new PerformanceInfoRecorderImpl();
        if (sessionIDInfor == null) {
            return null;
        }
        this.synchronizePerformanceInfo(sessionIDInfor, performanceInfoRecorderImpl);
        return performanceInfoRecorderImpl;
    }

    private void synchronizePerformanceInfo(SessionIDInfor sessionIDInfor, PerformanceInfoRecorder performanceInfoRecorder) {
        IReportPerformanceInfo iReportPerformanceInfo = sessionIDInfor.getPerformanceInfo();
        if (iReportPerformanceInfo != null) {
            performanceInfoRecorder.setReportPerformanceInfo((PerformanceInfo)iReportPerformanceInfo);
        } else {
            iReportPerformanceInfo = ReportPerformanceInfo.newInstance();
            performanceInfoRecorder.setReportPerformanceInfo((PerformanceInfo)iReportPerformanceInfo);
            sessionIDInfor.setPerformanceInfo(iReportPerformanceInfo);
        }
    }

    private static PerformanceRecorder createPerformanceRecorder() {
        return new LoggerPerformanceRecorder();
    }

    static {
        PerformanceManager.registerRecorderManager((PerformanceRecorderManager)PerformanceRecorderManagerImpl.getInstance());
    }
}

