/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.info;

import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.performance.dao.PerformanceSaverManager;
import com.fr.performance.info.CellInfo;
import com.fr.performance.info.DataSourceInfo;
import com.fr.performance.info.ExportInfo;
import com.fr.performance.info.IExportInfo;
import com.fr.performance.info.IReportPerformanceInfo;
import com.fr.performance.info.ISubmitInfo;
import com.fr.performance.info.InfoUtils;
import com.fr.performance.info.PerformanceInfo;
import com.fr.performance.info.SubmitInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportPerformanceInfo
implements IReportPerformanceInfo {
    private static final long serialVersionUID = 1L;
    public static final long CACHE_MARK = -2L;
    public static final ReportPerformanceInfo EOF = new ReportPerformanceInfo();
    private long createTime;
    private Map<String, DataSourceInfo> dataSourceInfoMap = new HashMap<String, DataSourceInfo>();
    private Map<String, CellInfo> cellInfoMap = new HashMap<String, CellInfo>();
    private long totalCalculateTime = -1L;
    private Map<String, Long> sheetMemoryMap = new HashMap<String, Long>();
    private String workBookName;
    private List<IExportInfo> exportInfoList = new ArrayList<IExportInfo>();
    private List<ISubmitInfo> submitInfoList = new ArrayList<ISubmitInfo>();
    private String parameterString = "";
    private Map<String, Long> sqlFunExecuteTimes = new HashMap<String, Long>();
    private Map<String, Long> imageMap = new HashMap<String, Long>();
    private Map<String, Long> cacheImageMap = new HashMap<String, Long>();

    private ReportPerformanceInfo() {
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long l) {
        this.createTime = l;
    }

    public long getId() {
        return this.createTime;
    }

    public static ReportPerformanceInfo newInstance() {
        ReportPerformanceInfo reportPerformanceInfo = new ReportPerformanceInfo();
        reportPerformanceInfo.setCreateTime(PerformanceSaverManager.getUniqueCreateTime());
        return reportPerformanceInfo;
    }

    public void putDataModelRowCount(String string, int n) {
        DataSourceInfo dataSourceInfo = this.getDataSourceInfo(string);
        dataSourceInfo.setRowCount(n);
    }

    public void putDataModelColCount(String string, int n) {
        DataSourceInfo dataSourceInfo = this.getDataSourceInfo(string);
        dataSourceInfo.setColCount(n);
    }

    public void putDataSourceExecuteTime(String string, long l) {
        DataSourceInfo dataSourceInfo = this.getDataSourceInfo(string);
        dataSourceInfo.setExecuteTime(l);
    }

    public void putDataSourceTransferTime(String string, long l) {
        DataSourceInfo dataSourceInfo = this.getDataSourceInfo(string);
        dataSourceInfo.setTransferTime(l);
    }

    public void addBuildDataTime(String string, long l) {
        this.getDataSourceInfo(string).addBuildDataTime(l);
    }

    public DataSourceInfo getDataSourceInfo(String string) {
        DataSourceInfo dataSourceInfo = this.dataSourceInfoMap.get(string);
        if (dataSourceInfo == null) {
            dataSourceInfo = new DataSourceInfo(string);
            this.dataSourceInfoMap.put(string, dataSourceInfo);
        }
        return dataSourceInfo;
    }

    public void putCellCalculateTime(String string, long l) {
        CellInfo cellInfo = this.getCellInfo(string);
        cellInfo.setCalculateTime(l);
    }

    public void addCellPresentTime(String string, long l) {
        CellInfo cellInfo = this.getCellInfo(string);
        cellInfo.addPresentTime(l);
    }

    public void addCellFilterTime(String string, long l) {
        CellInfo cellInfo = this.getCellInfo(string);
        cellInfo.addFilterTime(l);
    }

    public void addCellDynamicParameter(String string, long l) {
        CellInfo cellInfo = this.getCellInfo(string);
        cellInfo.addDynamicParameterTime(l);
    }

    public void addCellCustomDisplayTime(String string, long l) {
        CellInfo cellInfo = this.getCellInfo(string);
        cellInfo.addFilterTime(l);
    }

    public void addCellHighlightTime(String string, long l) {
        CellInfo cellInfo = this.getCellInfo(string);
        cellInfo.addHighlightTime(l);
    }

    public void addCellHyperlinkTime(String string, long l) {
        CellInfo cellInfo = this.getCellInfo(string);
        cellInfo.addHyperlinkTime(l);
    }

    private CellInfo getCellInfo(String string) {
        CellInfo cellInfo = this.cellInfoMap.get(string);
        if (cellInfo == null) {
            cellInfo = new CellInfo();
            cellInfo.setName(string);
            this.cellInfoMap.put(string, cellInfo);
        }
        return cellInfo;
    }

    public long getTotalCalculateTime() {
        return this.totalCalculateTime;
    }

    public void setCalculateTime(long l) {
        this.totalCalculateTime = l;
    }

    public void putReportMemory(String string, long l) {
        this.sheetMemoryMap.put(string, l);
    }

    public String getWorkBookName() {
        return this.workBookName;
    }

    public void setWorkBookName(String string) {
        this.workBookName = string;
    }

    public Map<String, Long> getSheetMemoryMap() {
        return this.sheetMemoryMap;
    }

    public Map<String, DataSourceInfo> getDataSourceInfoMap() {
        return this.dataSourceInfoMap;
    }

    public Map<String, CellInfo> getCellInfoMap() {
        return this.cellInfoMap;
    }

    void setCellInfoMap(Map<String, CellInfo> map) {
        this.cellInfoMap = map;
    }

    void setDataSourceInfoMap(Map<String, DataSourceInfo> map) {
        this.dataSourceInfoMap = map;
    }

    public JSONObject createJSON() throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("baseInfo", (Object)this.createBaseInfo());
        jSONObject.put("dataSourceInfo", (Object)new JSONArray(this.getSortedValues(this.dataSourceInfoMap)));
        jSONObject.put("cellInfo", (Object)new JSONArray(this.getSortedValues(this.cellInfoMap)));
        if (!this.exportInfoList.isEmpty()) {
            jSONObject.put("exportInfo", (Object)new JSONArray(this.exportInfoList));
        }
        if (!this.submitInfoList.isEmpty()) {
            jSONObject.put("submitInfo", (Object)new JSONArray(this.submitInfoList));
        }
        if (!this.sqlFunExecuteTimes.isEmpty()) {
            jSONObject.put("sqlFunInfo", (Object)this.getEntryArray(this.sqlFunExecuteTimes, "mark", "time"));
        }
        if (!this.imageMap.isEmpty()) {
            jSONObject.put("imageInfo", (Object)this.getEntryArray(this.imageMap, "mark", "memory"));
        }
        if (!this.cacheImageMap.isEmpty()) {
            jSONObject.put("cacheImageInfo", (Object)this.getEntryArray(this.cacheImageMap, "mark", "memory"));
        }
        return jSONObject;
    }

    private JSONArray getEntryArray(Map<String, Long> map, String string, String string2) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(string, (Object)entry.getKey());
            jSONObject.put(string2, (Object)entry.getValue());
            jSONArray.put((Object)jSONObject);
        }
        return jSONArray;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        this.parseBaseJSON(jSONObject);
        this.parseCellInfoJSON(jSONObject);
        this.parseDataSourceInfoJSON(jSONObject);
        this.parseExportInfo(jSONObject);
        this.parseSubmitInfo(jSONObject);
        this.parseSqlFun(jSONObject);
        this.parseImageInfo(jSONObject);
    }

    private void parseImageInfo(JSONObject jSONObject) throws JSONException {
        this.parseImageInfoToMap(this.imageMap, jSONObject.optJSONArray("imageInfo"));
        this.parseImageInfoToMap(this.cacheImageMap, jSONObject.optJSONArray("cacheImageInfo"));
    }

    private void parseImageInfoToMap(Map<String, Long> map, JSONArray jSONArray) throws JSONException {
        if (jSONArray != null) {
            map.clear();
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                String string = jSONObject.getString("mark");
                Long l = jSONObject.getLong("memory");
                map.put(string, l);
            }
        }
    }

    private void parseSqlFun(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = jSONObject.optJSONArray("sqlFunInfo");
        if (jSONArray != null) {
            this.sqlFunExecuteTimes.clear();
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                String string = jSONObject2.getString("mark");
                Long l = jSONObject2.getLong("time");
                this.sqlFunExecuteTimes.put(string, l);
            }
        }
    }

    private void parseSubmitInfo(JSONObject jSONObject) throws Exception {
        JSONArray jSONArray = jSONObject.optJSONArray("submitInfo");
        if (jSONArray != null) {
            this.submitInfoList.clear();
            for (int i = 0; i < jSONArray.length(); ++i) {
                SubmitInfo submitInfo = new SubmitInfo();
                submitInfo.parseJSON(jSONArray.getJSONObject(i));
                this.submitInfoList.add(submitInfo);
            }
        }
    }

    private void parseExportInfo(JSONObject jSONObject) throws Exception {
        JSONArray jSONArray = jSONObject.optJSONArray("exportInfo");
        if (jSONArray != null) {
            this.exportInfoList.clear();
            for (int i = 0; i < jSONArray.length(); ++i) {
                ExportInfo exportInfo = new ExportInfo();
                exportInfo.parseJSON(jSONArray.getJSONObject(i));
                this.exportInfoList.add(exportInfo);
            }
        }
    }

    private void parseDataSourceInfoJSON(JSONObject jSONObject) throws Exception {
        JSONArray jSONArray = jSONObject.getJSONArray("dataSourceInfo");
        for (int i = 0; i < jSONArray.length(); ++i) {
            DataSourceInfo dataSourceInfo = new DataSourceInfo();
            dataSourceInfo.parseJSON(jSONArray.getJSONObject(i));
            this.dataSourceInfoMap.put(dataSourceInfo.getName(), dataSourceInfo);
        }
    }

    private void parseCellInfoJSON(JSONObject jSONObject) throws Exception {
        JSONArray jSONArray = jSONObject.getJSONArray("cellInfo");
        for (int i = 0; i < jSONArray.length(); ++i) {
            CellInfo cellInfo = new CellInfo();
            cellInfo.parseJSON(jSONArray.getJSONObject(i));
            this.cellInfoMap.put(cellInfo.getName(), cellInfo);
        }
    }

    private void parseBaseJSON(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = jSONObject.getJSONObject("baseInfo");
        this.setWorkBookName(jSONObject2.getString("name"));
        this.setCalculateTime(jSONObject2.getLong("calculateTime"));
        this.setCreateTime(jSONObject2.getLong("createTime"));
        this.putReportMemory("all", jSONObject2.getLong("memory"));
        this.putParameterString(jSONObject2.optString("parameter"));
    }

    private JSONObject createBaseInfo() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("name", (Object)this.workBookName);
        jSONObject.put("calculateTime", this.totalCalculateTime);
        jSONObject.put("memory", this.getReportMemory());
        long l = this.getImageMemory();
        if (l != 0L) {
            jSONObject.put("imgMemory", this.getImageMemory());
        }
        jSONObject.put("createTime", this.createTime);
        jSONObject.put("parameter", (Object)this.parameterString);
        return jSONObject;
    }

    private long getImageMemory() {
        long l = 0L;
        for (long l2 : this.imageMap.values()) {
            l += l2;
        }
        return l;
    }

    public long getReportMemory() {
        long l = 0L;
        for (Map.Entry<String, Long> entry : this.sheetMemoryMap.entrySet()) {
            l += entry.getValue().longValue();
        }
        return l;
    }

    public long getTotalMemory() {
        return this.getReportMemory() + this.getImageMemory();
    }

    public void addExportInfo(IExportInfo iExportInfo) {
        this.exportInfoList.add(iExportInfo);
    }

    public void addSubmitInfo(ISubmitInfo iSubmitInfo) {
        this.submitInfoList.add(iSubmitInfo);
    }

    public void putParameterString(String string) {
        this.parameterString = string;
    }

    public String getParameterString() {
        return this.parameterString;
    }

    public Map<String, Long> getImageMap() {
        return this.imageMap;
    }

    public void addImageMemory(String string, long l, boolean bl) {
        if (bl) {
            this.addImageMemory(this.cacheImageMap, string + "(from cache)", l);
        } else {
            this.addImageMemory(this.imageMap, string, l);
        }
    }

    public void addImageMemory(String string, long l) {
        this.addImageMemory(string, l, false);
    }

    private void addImageMemory(Map<String, Long> map, String string, long l) {
        Long l2 = map.get(string);
        if (l2 == null) {
            map.put(string, l);
        } else {
            map.put(string, l2 + l);
        }
    }

    public Map<String, Long> getSqlFunExecuteTimes() {
        return this.sqlFunExecuteTimes;
    }

    public void addSqlFunExecuteTimes(String string, long l) {
        Long l2 = this.sqlFunExecuteTimes.get(string);
        if (l2 == null) {
            this.sqlFunExecuteTimes.put(string, l);
        } else {
            this.sqlFunExecuteTimes.put(string, l2 + l);
        }
    }

    List<ISubmitInfo> getSubmitInfoList() {
        return this.submitInfoList;
    }

    public List<IExportInfo> getExportInfoList() {
        return this.exportInfoList;
    }

    public String toString() {
        return this.toJSONString();
    }

    public String toJSONString() {
        return InfoUtils.toJSONString((PerformanceInfo)this);
    }

    private <T extends Comparable<? super T>> List<T> getSortedValues(Collection<T> collection) {
        List<T> list = this.getValueList(collection);
        Collections.sort(list);
        return list;
    }

    private <T extends Comparable<? super T>> List<T> getSortedValues(Map<?, T> map) {
        List<T> list = this.getValueList(map);
        Collections.sort(list);
        return list;
    }

    private <T> List<T> getValueList(Map<?, T> map) {
        ArrayList<T> arrayList = new ArrayList<T>(map.size());
        for (Map.Entry<?, T> entry : map.entrySet()) {
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    private <T> List<T> getValueList(Collection<T> collection) {
        ArrayList<T> arrayList = new ArrayList<T>(collection.size());
        for (T t : collection) {
            arrayList.add(t);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        DataSourceInfo dataSourceInfo = new DataSourceInfo();
        DataSourceInfo dataSourceInfo2 = new DataSourceInfo();
    }
}

