/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.dao;

import com.fr.performance.dao.InfoSaver;
import com.fr.performance.info.PerformanceInfo;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.locks.ReentrantLock;

public class QueueInfoSaver
implements InfoSaver {
    private int bufCount = 1;
    private static final int MAX = 10000;
    private BlockingQueue<PerformanceInfo> buf = new ArrayBlockingQueue<PerformanceInfo>(10000);
    InfoSaver saver = null;
    private ReentrantLock flushLock = new ReentrantLock();
    private boolean isFlush = false;

    public QueueInfoSaver() {
    }

    public QueueInfoSaver(InfoSaver infoSaver) {
        this.saver = infoSaver;
    }

    public void setInfoSaver(InfoSaver infoSaver) {
        this.saver = infoSaver;
    }

    public void save(PerformanceInfo performanceInfo) {
        try {
            this.buf.put(performanceInfo);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.tryFlushIfNeed();
    }

    public void setBufCount(int n) {
        this.bufCount = n;
    }

    private synchronized boolean shouldFlush() {
        return !this.isFlush;
    }

    public void tryFlushIfNeed() {
        if (this.shouldFlush() && this.flushLock.tryLock()) {
            try {
                if (this.shouldFlush()) {
                    this.isFlush = true;
                    this.flush();
                }
            }
            finally {
                this.flushLock.unlock();
            }
        }
    }

    public void flush() {
        new FlushThread().start();
    }

    public boolean isFlush() {
        if (this.flushLock.tryLock()) {
            boolean bl = this.isFlush;
            this.flushLock.unlock();
            return bl;
        }
        return false;
    }

    private void proxySave(PerformanceInfo performanceInfo) {
        this.saver.save(performanceInfo);
    }

    private class FlushThread
    extends Thread {
        private FlushThread() {
        }

        public void run() {
            try {
                QueueInfoSaver.this.flushLock.lock();
                while (!QueueInfoSaver.this.buf.isEmpty()) {
                    PerformanceInfo performanceInfo = (PerformanceInfo)QueueInfoSaver.this.buf.poll();
                    QueueInfoSaver.this.proxySave(performanceInfo);
                }
                QueueInfoSaver.this.saver.flush();
                QueueInfoSaver.this.isFlush = false;
            }
            finally {
                QueueInfoSaver.this.flushLock.unlock();
            }
        }
    }
}

