/*
 * Decompiled with CFR 0.152.
 */
package org.openwebflow.assign.delegation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.task.IdentityLink;
import org.openwebflow.assign.TaskAssignmentHandler;
import org.openwebflow.assign.TaskAssignmentHandlerChain;
import org.openwebflow.assign.delegation.DelegationEntity;
import org.openwebflow.assign.delegation.DelegationManager;
import org.openwebflow.identity.IdentityMembershipManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDelagationAssignmentHandler
implements TaskAssignmentHandler {
    DelegationManager _delegationManager;
    boolean _hideDelegated = false;
    IdentityMembershipManager _membershipManager;

    private void addCandidateUsers(TaskEntity task, Set<String> delegates) {
        for (String delegate : delegates) {
            task.addCandidateUser(delegate);
        }
    }

    public DelegationManager getDelegationManager() {
        return this._delegationManager;
    }

    public IdentityMembershipManager getMembershipManager() {
        return this._membershipManager;
    }

    @Override
    public void handleAssignment(TaskAssignmentHandlerChain chain, TaskEntity task, ActivityExecution execution) {
        chain.resume(task, execution);
        this.overwriteAssignee(task);
        HashMap<String, Object> userIdMap = new HashMap<String, Object>();
        HashMap<String, Object> groupIdMap = new HashMap<String, Object>();
        this.retrieveCandidateUserIdsAndGroupIds(task, userIdMap, groupIdMap);
        HashMap<String, Object> newUserIdMap = new HashMap<String, Object>();
        HashMap<String, Object> removeUserIdMap = new HashMap<String, Object>();
        List<DelegationEntity> entries = this._delegationManager.listDelegationEntities();
        this.overwriteCandicateUserIds(userIdMap, newUserIdMap, removeUserIdMap, entries);
        this.overwriteCandicateGroupIds(groupIdMap, newUserIdMap, entries);
        this.addCandidateUsers(task, newUserIdMap.keySet());
        this.removeCandidateUsers(task, removeUserIdMap.keySet());
    }

    private boolean isCandicateGroupMember(String delegated, Map<String, Object> groupIds) {
        for (String groupId : this._membershipManager.findGroupIdsByUser(delegated)) {
            if (!groupIds.containsKey(groupId)) continue;
            return true;
        }
        return false;
    }

    public boolean isHideDelegated() {
        return this._hideDelegated;
    }

    protected void overwriteAssignee(TaskEntity task) {
        String[] delegates;
        String assignee = task.getAssignee();
        if (assignee != null && (delegates = this._delegationManager.getDelegates(assignee)) != null && delegates.length > 0) {
            task.setAssignee(delegates[0]);
        }
    }

    protected void overwriteCandicateGroupIds(Map<String, Object> groupIdMap, Map<String, Object> newUserIdMap, List<DelegationEntity> entries) {
        for (DelegationEntity en : entries) {
            if (newUserIdMap.containsKey(en.getDelegate()) || !this.isCandicateGroupMember(en.getDelegated(), groupIdMap)) continue;
            newUserIdMap.put(en.getDelegate(), 0);
        }
    }

    protected void overwriteCandicateUserIds(Map<String, Object> userIdMap, Map<String, Object> newUserIdMap, Map<String, Object> removeUserIdMap, List<DelegationEntity> entries) {
        for (DelegationEntity en : entries) {
            if (newUserIdMap.containsKey(en.getDelegate()) || !userIdMap.containsKey(en.getDelegated())) continue;
            newUserIdMap.put(en.getDelegate(), 0);
            if (!this.isHideDelegated()) continue;
            removeUserIdMap.put(en.getDelegated(), 0);
        }
    }

    private void removeCandidateUsers(TaskEntity task, Set<String> delegates) {
        for (String delegate : delegates) {
            task.deleteCandidateUser(delegate);
        }
    }

    private void retrieveCandidateUserIdsAndGroupIds(TaskEntity task, Map<String, Object> userIdMap, Map<String, Object> groupIdMap) {
        for (IdentityLink link : task.getCandidates()) {
            String groupId;
            String userId = link.getUserId();
            if (userId != null) {
                userIdMap.put(userId, 0);
            }
            if ((groupId = link.getGroupId()) == null) continue;
            groupIdMap.put(groupId, 0);
        }
    }

    public void setDelegationManager(DelegationManager delegationManager) {
        this._delegationManager = delegationManager;
    }

    public void setHideDelegated(boolean hideDelegated) {
        this._hideDelegated = hideDelegated;
    }

    public void setMembershipManager(IdentityMembershipManager membershipManager) {
        this._membershipManager = membershipManager;
    }
}

