/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.export;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.freehep.util.export.ExportFileTypeRegistry;

public abstract class ExportFileType
implements Comparable {
    private static ClassLoader loader;

    public abstract String getDescription();

    public abstract String[] getExtensions();

    public abstract String[] getMIMETypes();

    public void exportToFile(OutputStream outputStream, Component component, Component component2, Properties properties, String string) throws IOException {
        this.exportToFile(outputStream, new Component[]{component}, component2, properties, string);
    }

    public void exportToFile(File file, Component component, Component component2, Properties properties, String string) throws IOException {
        this.exportToFile(file, new Component[]{component}, component2, properties, string);
    }

    public abstract void exportToFile(OutputStream var1, Component[] var2, Component var3, Properties var4, String var5) throws IOException;

    public abstract void exportToFile(File var1, Component[] var2, Component var3, Properties var4, String var5) throws IOException;

    public int compareTo(Object object) {
        ExportFileType exportFileType = (ExportFileType)object;
        return this.getDescription().compareTo(exportFileType.getDescription());
    }

    public boolean hasOptionPanel() {
        return false;
    }

    public JPanel createOptionPanel(Properties properties) {
        return null;
    }

    public boolean applyChangedOptions(JPanel jPanel, Properties properties) {
        return false;
    }

    public FileFilter getFileFilter() {
        return null;
    }

    public File adjustFilename(File file, Properties properties) {
        return this.adjustFilename(file, "", properties);
    }

    public File adjustFilename(File file, String string, Properties properties) {
        return ExportFileType.adjustExtension(file, this.getExtensions()[0], this.getExtensions(), string);
    }

    public String getFileExtension(File file) {
        return ExportFileType.getExtension(file, this.getExtensions());
    }

    public boolean fileHasValidExtension(File file) {
        return ExportFileType.checkExtension(file, this.getExtensions());
    }

    public boolean isMultipageCapable() {
        return false;
    }

    public static void setClassLoader(ClassLoader classLoader) {
        loader = classLoader;
    }

    public static List getExportFileTypes() {
        return ExportFileType.getExportFileTypes(null);
    }

    public static List getExportFileTypes(String string) {
        return ExportFileTypeRegistry.getDefaultInstance(loader).get(string);
    }

    public static String getExtension(File file, String[] stringArray) {
        String string = "";
        if (file != null && stringArray != null) {
            String string2 = file.getName();
            string2 = string2.toLowerCase();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string3 = stringArray[i2].toLowerCase();
                if (!string2.endsWith("." + string3) || string3.length() <= string.length()) continue;
                string = stringArray[i2];
            }
        }
        return string;
    }

    public static boolean checkExtension(File file, String[] stringArray) {
        return ExportFileType.getExtension(file, stringArray).length() > 0;
    }

    public static File adjustExtension(File file, String string, String[] stringArray) {
        return ExportFileType.adjustExtension(file, string, stringArray, "");
    }

    public static File adjustExtension(File file, String string, String[] stringArray, String string2) {
        File file2 = file;
        if (file != null) {
            String string3 = file.getParent();
            String string4 = file.getName();
            String string5 = "";
            if (string3 != null) {
                string5 = string3 + File.separator;
            }
            if (string2.length() > 0 && string4.endsWith(string2)) {
                string5 = string5 + string4.substring(0, string4.length() - string2.length() - 1);
            } else {
                int n2 = string4.lastIndexOf(46);
                if (n2 > 0 && n2 < string4.length() - 1) {
                    string5 = string5 + string4.substring(0, n2);
                    string2 = string4.substring(n2 + 1);
                } else {
                    string5 = string5 + string4;
                    string2 = "";
                }
            }
            file2 = new File(string5 + "." + string2);
            if (!ExportFileType.checkExtension(file2, stringArray)) {
                file2 = new File(string5 + "." + string);
            }
        }
        return file2;
    }
}

