/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Locale;
import org.freehep.util.DoubleWithError;

public class ScientificFormat
extends Format {
    private int sigDigit = 5;
    private int maxWidth = 8;
    private boolean sciNote = false;
    private DecimalFormat decimalFormat;
    private static final long serialVersionUID = -1182686857248711235L;
    private static final double k = 1.0 / Math.log(10.0);

    public ScientificFormat() {
    }

    public ScientificFormat(int n2, int n3, boolean bl) {
        this.setSigDigits(n2);
        this.setMaxWidth(n3);
        this.setScientificNotationStyle(bl);
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Number) {
            String string = this.format(((Number)object).doubleValue());
            return stringBuffer.append(string);
        }
        if (object instanceof DoubleWithError) {
            DoubleWithError doubleWithError = (DoubleWithError)object;
            stringBuffer.append(this.format(doubleWithError.getValue()));
            if (doubleWithError.hasAsymmetricError()) {
                stringBuffer.append('+');
                int n2 = this.resolveErrorSigDigit(doubleWithError.getValue(), doubleWithError.getPlusError());
                stringBuffer.append(this.format(doubleWithError.getPlusError(), n2));
                stringBuffer.append('-');
                n2 = this.resolveErrorSigDigit(doubleWithError.getValue(), doubleWithError.getMinError());
                stringBuffer.append(this.format(doubleWithError.getMinError(), n2));
            } else {
                stringBuffer.append('\u00b1');
                int n3 = this.resolveErrorSigDigit(doubleWithError.getValue(), doubleWithError.getError());
                stringBuffer.append(this.format(doubleWithError.getError(), n3));
            }
            return stringBuffer;
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        return null;
    }

    public int getSigDigits() {
        return this.sigDigit;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public boolean getScientificNotationStyle() {
        return this.sciNote;
    }

    public void setSigDigits(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("sigDigit");
        }
        this.sigDigit = n2;
        this.decimalFormat = null;
    }

    public void setMaxWidth(int n2) {
        if (n2 < 3) {
            throw new IllegalArgumentException("maxWidth");
        }
        this.maxWidth = n2;
    }

    public void setScientificNotationStyle(boolean bl) {
        this.sciNote = bl;
    }

    private double Log10(double d2) {
        if (d2 == 0.0) {
            return 0.0;
        }
        return Math.log(d2) * k;
    }

    private int resolveErrorSigDigit(double d2, double d3) {
        d3 = Math.abs(d3);
        d2 = Math.abs(d2);
        if (d3 == 0.0 || Double.isInfinite(d3) || Double.isNaN(d3) || d3 >= d2) {
            return this.sigDigit;
        }
        if (d2 == 0.0 || Double.isInfinite(d2) || Double.isNaN(d2)) {
            return this.sigDigit;
        }
        int n2 = (int)Math.round(this.Log10(d3 / d2));
        int n3 = this.sigDigit + n2;
        if (n3 < 1) {
            return 1;
        }
        return n3;
    }

    private DecimalFormat getDecimalFormat(int n2) {
        StringBuffer stringBuffer = new StringBuffer("0.");
        for (int i2 = 1; i2 < n2; ++i2) {
            stringBuffer.append('0');
        }
        stringBuffer.append("E0");
        return new DecimalFormat(stringBuffer.toString(), new DecimalFormatSymbols(Locale.US));
    }

    public String format(double d2) {
        return this.format(d2, this.sigDigit);
    }

    private String format(double d2, int n2) {
        if (Double.isInfinite(d2)) {
            return this.maxWidth < 8 ? "INF" : "Infinite";
        }
        if (Double.isNaN(d2)) {
            return "NaN";
        }
        if (this.decimalFormat == null) {
            this.decimalFormat = this.getDecimalFormat(this.sigDigit);
        }
        DecimalFormat decimalFormat = n2 == this.sigDigit ? this.decimalFormat : this.getDecimalFormat(n2);
        String string = decimalFormat.format(d2);
        if (this.sciNote) {
            return string;
        }
        int n3 = string.indexOf(69);
        int n4 = Integer.parseInt(string.substring(n3 + 1)) + 1;
        if (n4 > this.maxWidth) {
            return string;
        }
        if (n4 < -this.maxWidth + n2 + 1) {
            return string;
        }
        int n5 = string.charAt(0) == '-' ? 1 : 0;
        StringBuffer stringBuffer = new StringBuffer(string.substring(n5, n5 + 1) + string.substring(n5 + 2, n3));
        if (n4 >= n2) {
            for (int i2 = n2; i2 < n4; ++i2) {
                stringBuffer.append('0');
            }
        } else if (n4 < 0) {
            stringBuffer.insert(0, ".");
            for (int i3 = n4; i3 < 0; ++i3) {
                stringBuffer.insert(1, '0');
            }
        } else {
            stringBuffer.insert(n4, '.');
        }
        if (n5 > 0) {
            stringBuffer.insert(0, '-');
        }
        return stringBuffer.toString();
    }
}

