/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.geom.AffineTransform;
import java.io.EOFException;
import java.io.IOException;
import org.freehep.graphicsio.swf.ColorXform;
import org.freehep.graphicsio.swf.ControlTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;

public class PlaceObject
extends ControlTag {
    private int character;
    private int depth;
    private AffineTransform matrix;
    private ColorXform cxform = null;

    public PlaceObject(int n2, int n3, AffineTransform affineTransform) {
        this(n2, n3, affineTransform, null);
    }

    public PlaceObject(int n2, int n3, AffineTransform affineTransform, ColorXform colorXform) {
        this();
        this.character = n2;
        this.depth = n3;
        this.matrix = affineTransform;
        this.cxform = colorXform;
    }

    public PlaceObject() {
        super(4, 1);
    }

    public SWFTag read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
        PlaceObject placeObject = new PlaceObject();
        placeObject.character = sWFInputStream.readUnsignedShort();
        placeObject.depth = sWFInputStream.readUnsignedShort();
        placeObject.matrix = sWFInputStream.readMatrix();
        try {
            placeObject.cxform = new ColorXform(sWFInputStream, false);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return placeObject;
    }

    public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
        sWFOutputStream.writeUnsignedShort(this.character);
        sWFOutputStream.writeUnsignedShort(this.depth);
        sWFOutputStream.writeMatrix(this.matrix);
        if (this.cxform != null) {
            this.cxform.write(sWFOutputStream, false);
        }
    }

    public String toString() {
        return super.toString() + "\n" + "  depth: " + this.depth + "\n" + "  character: " + this.character + "\n" + "  matrix: " + this.matrix + "\n" + "  xform: " + this.cxform;
    }
}

