/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.io.IOException;
import org.freehep.graphicsio.swf.FillStyle;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;

public class LineStyle {
    public static final int CAP_ROUND = 0;
    public static final int CAP_NONE = 1;
    public static final int CAP_SQUARE = 2;
    public static final int JOIN_ROUND = 0;
    public static final int JOIN_BEVEL = 1;
    public static final int JOIN_MITER = 2;
    private int width;
    private int endWidth;
    private int startCapStyle;
    private int joinStyle;
    private int endCapStyle;
    private boolean hasFillFlag;
    private boolean noHScaleFlag;
    private boolean noVScaleFlag;
    private boolean pixelHintingFlag;
    private boolean noClose;
    private float miterLimitFactor;
    private FillStyle fillStyle;
    private Color color;
    private Color endColor;

    public LineStyle(int n2, Color color) {
        this.width = n2;
        this.color = color;
        this.startCapStyle = 0;
        this.joinStyle = 0;
        this.endCapStyle = 0;
        this.hasFillFlag = false;
        this.noHScaleFlag = false;
        this.noVScaleFlag = false;
        this.pixelHintingFlag = false;
        this.noClose = false;
    }

    public LineStyle(int n2, int n3, Color color, Color color2) {
        this(n2, color);
        this.endWidth = n3;
        this.endColor = color2;
    }

    public LineStyle(SWFInputStream sWFInputStream, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.width = sWFInputStream.readUnsignedShort();
        if (bl) {
            this.endWidth = sWFInputStream.readUnsignedShort();
        }
        if (bl3) {
            this.startCapStyle = (int)sWFInputStream.readUBits(2);
            this.joinStyle = (int)sWFInputStream.readUBits(2);
            this.hasFillFlag = sWFInputStream.readBitFlag();
            this.noHScaleFlag = sWFInputStream.readBitFlag();
            this.noVScaleFlag = sWFInputStream.readBitFlag();
            this.pixelHintingFlag = sWFInputStream.readBitFlag();
            sWFInputStream.readUBits(5);
            this.noClose = sWFInputStream.readBitFlag();
            this.endCapStyle = (int)sWFInputStream.readUBits(2);
            if (this.joinStyle == 2) {
                sWFInputStream.readFixed8();
            }
            if (this.hasFillFlag) {
                this.fillStyle = new FillStyle(sWFInputStream, false, true);
            } else {
                this.color = sWFInputStream.readColor(true);
            }
        } else {
            this.color = sWFInputStream.readColor(bl2);
        }
        if (bl) {
            this.endColor = sWFInputStream.readColor(true);
        }
    }

    public void write(SWFOutputStream sWFOutputStream, boolean bl, boolean bl2, boolean bl3) throws IOException {
        sWFOutputStream.writeUnsignedShort(this.width);
        if (bl) {
            sWFOutputStream.writeUnsignedShort(this.endWidth);
        }
        if (bl3) {
            sWFOutputStream.writeUBits(this.startCapStyle, 2);
            sWFOutputStream.writeUBits(this.joinStyle, 2);
            sWFOutputStream.writeBitFlag(this.hasFillFlag);
            sWFOutputStream.writeBitFlag(this.noHScaleFlag);
            sWFOutputStream.writeBitFlag(this.noVScaleFlag);
            sWFOutputStream.writeBitFlag(this.pixelHintingFlag);
            sWFOutputStream.writeUBits(0L, 5);
            sWFOutputStream.writeBitFlag(this.noClose);
            sWFOutputStream.writeUBits(this.endCapStyle, 2);
            if (this.joinStyle == 2) {
                sWFOutputStream.writeFixed8(this.miterLimitFactor);
            }
            if (this.hasFillFlag) {
                this.fillStyle.write(sWFOutputStream, bl, true);
            } else {
                sWFOutputStream.writeColor(this.color, true);
            }
        } else {
            sWFOutputStream.writeColor(this.color, bl2 || bl);
            if (bl) {
                sWFOutputStream.writeColor(this.endColor, true);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LineStyle " + this.width + ", " + this.color);
        if (this.endColor != null) {
            stringBuffer.append("; " + this.endWidth + ", " + this.endColor);
        }
        return stringBuffer.toString();
    }
}

