/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.FillStyleArray;
import org.freehep.graphicsio.swf.LineStyleArray;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFShape;
import org.freehep.graphicsio.swf.SWFTag;

public class DefineMorphShape
extends DefinitionTag {
    private int character;
    private Rectangle2D startBounds;
    private Rectangle2D endBounds;
    protected FillStyleArray fillStyles;
    protected LineStyleArray lineStyles;
    protected SWFShape startEdges;
    protected SWFShape endEdges;

    public DefineMorphShape(int n2, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, FillStyleArray fillStyleArray, LineStyleArray lineStyleArray, SWFShape sWFShape, SWFShape sWFShape2) {
        this();
        this.character = n2;
        this.startBounds = rectangle2D;
        this.endBounds = rectangle2D2;
        this.fillStyles = fillStyleArray;
        this.lineStyles = lineStyleArray;
        this.startEdges = sWFShape;
        this.endEdges = sWFShape2;
    }

    public DefineMorphShape() {
        super(46, 3);
    }

    public SWFTag read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
        DefineMorphShape defineMorphShape = new DefineMorphShape();
        defineMorphShape.character = sWFInputStream.readUnsignedShort();
        sWFInputStream.getDictionary().put(defineMorphShape.character, defineMorphShape);
        defineMorphShape.startBounds = sWFInputStream.readRect();
        defineMorphShape.endBounds = sWFInputStream.readRect();
        sWFInputStream.readUnsignedInt();
        this.fillStyles = new FillStyleArray(sWFInputStream, true, true);
        this.lineStyles = new LineStyleArray(sWFInputStream, true, true, false);
        this.startEdges = new SWFShape(sWFInputStream, this.fillStyles, this.lineStyles, true, true, false);
        this.endEdges = new SWFShape(sWFInputStream, this.fillStyles, this.lineStyles, true, true, false);
        return defineMorphShape;
    }

    public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
        sWFOutputStream.writeUnsignedShort(this.character);
        sWFOutputStream.writeRect(this.startBounds);
        sWFOutputStream.writeRect(this.endBounds);
        sWFOutputStream.pushBuffer();
        this.fillStyles.write(sWFOutputStream, true, true);
        this.lineStyles.write(sWFOutputStream, true, true, false);
        this.startEdges.write(sWFOutputStream, true, true, false);
        int n3 = sWFOutputStream.popBuffer();
        sWFOutputStream.writeUnsignedInt(n3);
        sWFOutputStream.append();
        this.endEdges.write(sWFOutputStream, true, true, false);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString() + "\n");
        stringBuffer.append("  character:   " + this.character + "\n");
        stringBuffer.append("  startBounds: " + this.startBounds + "\n");
        stringBuffer.append("  endBounds:   " + this.endBounds + "\n");
        stringBuffer.append(this.fillStyles.toString());
        stringBuffer.append(this.lineStyles.toString());
        stringBuffer.append("  startEdges: " + this.startEdges + "\n");
        stringBuffer.append("  endEdges:   " + this.endEdges + "\n");
        return stringBuffer.toString();
    }
}

