/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.freehep.graphicsio.swf.DefineFontInfo;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFShape;
import org.freehep.graphicsio.swf.SWFTag;

public class DefineFont
extends DefinitionTag {
    private int character;
    private List shapes;
    private DefineFontInfo info;

    public DefineFont(int n2) {
        this();
        this.character = n2;
        this.shapes = new ArrayList();
    }

    public void add(SWFShape sWFShape) {
        this.shapes.add(sWFShape);
    }

    public DefineFont() {
        super(10, 1);
    }

    public SWFTag read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
        int n4;
        DefineFont defineFont = new DefineFont();
        defineFont.character = sWFInputStream.readUnsignedShort();
        sWFInputStream.getDictionary().put(defineFont.character, defineFont);
        int n5 = sWFInputStream.readUnsignedShort();
        int n6 = n5 / 2;
        int[] nArray = new int[n6];
        nArray[0] = n5;
        for (n4 = 1; n4 < n6; ++n4) {
            nArray[n4] = sWFInputStream.readUnsignedShort();
        }
        defineFont.shapes = new ArrayList();
        for (n4 = 0; n4 < n6; ++n4) {
            defineFont.shapes.add(new SWFShape(sWFInputStream));
        }
        return defineFont;
    }

    public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
        int n3;
        sWFOutputStream.writeUnsignedShort(this.character);
        sWFOutputStream.pushBuffer();
        int[] nArray = new int[this.shapes.size()];
        for (n3 = 0; n3 < this.shapes.size(); ++n3) {
            nArray[n3] = sWFOutputStream.getBufferLength();
            ((SWFShape)this.shapes.get(n3)).write(sWFOutputStream);
        }
        sWFOutputStream.popBuffer();
        for (n3 = 0; n3 < this.shapes.size(); ++n3) {
            sWFOutputStream.writeUnsignedShort(this.shapes.size() * 2 + nArray[n3]);
        }
        sWFOutputStream.append();
    }

    public int getGlyphCount() {
        return this.shapes.size();
    }

    public void setFontInfo(DefineFontInfo defineFontInfo) {
        this.info = defineFontInfo;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString() + "\n");
        stringBuffer.append("  character:  " + this.character + "\n");
        stringBuffer.append("  glyphcount: " + this.shapes.size() + "\n");
        for (int i2 = 0; i2 < this.shapes.size(); ++i2) {
            stringBuffer.append(this.shapes.get(i2) + "\n");
        }
        stringBuffer.append("  fontInfo: " + this.info + "\n");
        return stringBuffer.toString();
    }
}

