/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.AttributedCharacterIterator;
import java.util.Properties;
import org.freehep.graphics2d.GenericTagHandler;
import org.freehep.graphics2d.PrintColor;
import org.freehep.graphics2d.SymbolShape;
import org.freehep.graphics2d.TagString;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphics2d.font.FontUtilities;
import org.freehep.util.UserProperties;

public abstract class AbstractVectorGraphics
extends VectorGraphics {
    private UserProperties properties;
    private String creator;
    private boolean isDeviceIndependent;
    private SymbolShape cachedShape;
    private int colorMode;
    private Color backgroundColor;
    private Color currentColor;
    private Paint currentPaint;
    private Font currentFont;
    private static final double bias = 0.5;

    public AbstractVectorGraphics() {
        this.properties = new UserProperties();
        this.creator = "FreeHEP Graphics2D Driver";
        this.isDeviceIndependent = false;
        this.cachedShape = new SymbolShape();
        this.colorMode = 0;
        this.currentFont = null;
        this.backgroundColor = null;
        this.currentColor = null;
        this.currentPaint = null;
    }

    protected AbstractVectorGraphics(AbstractVectorGraphics abstractVectorGraphics) {
        this.properties = abstractVectorGraphics.properties;
        this.creator = abstractVectorGraphics.creator;
        this.isDeviceIndependent = abstractVectorGraphics.isDeviceIndependent;
        this.cachedShape = abstractVectorGraphics.cachedShape;
        this.backgroundColor = abstractVectorGraphics.backgroundColor;
        this.currentColor = abstractVectorGraphics.currentColor;
        this.currentPaint = abstractVectorGraphics.currentPaint;
        this.colorMode = abstractVectorGraphics.colorMode;
        this.currentFont = abstractVectorGraphics.currentFont;
    }

    public void setProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        this.properties.setProperties(properties);
    }

    protected void initProperties(Properties properties) {
        this.properties = new UserProperties();
        this.properties.setProperties(properties);
    }

    protected Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public Color getPropertyColor(String string) {
        return this.properties.getPropertyColor(string);
    }

    public Rectangle getPropertyRectangle(String string) {
        return this.properties.getPropertyRectangle(string);
    }

    public Insets getPropertyInsets(String string) {
        return this.properties.getPropertyInsets(string);
    }

    public Dimension getPropertyDimension(String string) {
        return this.properties.getPropertyDimension(string);
    }

    public int getPropertyInt(String string) {
        return this.properties.getPropertyInt(string);
    }

    public double getPropertyDouble(String string) {
        return this.properties.getPropertyDouble(string);
    }

    public boolean isProperty(String string) {
        return this.properties.isProperty(string);
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String string) {
        if (string != null) {
            this.creator = string;
        }
    }

    public boolean isDeviceIndependent() {
        return this.isDeviceIndependent;
    }

    public void setDeviceIndependent(boolean bl) {
        this.isDeviceIndependent = bl;
    }

    public Font getFont() {
        return this.currentFont;
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        this.currentFont = font;
    }

    public void drawSymbol(int n2, int n3, int n4, int n5) {
        this.drawSymbol((double)n2, (double)n3, (double)n4, n5);
    }

    public void fillSymbol(int n2, int n3, int n4, int n5) {
        this.fillSymbol((double)n2, (double)n3, (double)n4, n5);
    }

    public void fillAndDrawSymbol(int n2, int n3, int n4, int n5, Color color) {
        this.fillAndDrawSymbol((double)n2, (double)n3, (double)n4, n5, color);
    }

    public void drawSymbol(double d2, double d3, double d4, int n2) {
        if (d4 <= 0.0) {
            return;
        }
        this.drawSymbol(this, d2, d3, d4, n2);
    }

    protected void drawSymbol(VectorGraphics vectorGraphics, double d2, double d3, double d4, int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.cachedShape.create(n2, d2, d3, d4);
                vectorGraphics.draw(this.cachedShape);
                break;
            }
            case 5: {
                double d5 = Math.max(1.0, d4);
                d5 += d5 % 2.0;
                vectorGraphics.drawOval(d2 - d5 / 2.0, d3 - d5 / 2.0, d5, d5);
                break;
            }
        }
    }

    public void fillSymbol(double d2, double d3, double d4, int n2) {
        if (d4 <= 0.0) {
            return;
        }
        this.fillSymbol(this, d2, d3, d4, n2);
    }

    protected void fillSymbol(VectorGraphics vectorGraphics, double d2, double d3, double d4, int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.cachedShape.create(n2, d2, d3, d4);
                vectorGraphics.draw(this.cachedShape);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.cachedShape.create(n2, d2, d3, d4);
                vectorGraphics.fill(this.cachedShape);
                break;
            }
            case 5: {
                double d5 = Math.max(1.0, d4);
                d5 += d5 % 2.0;
                vectorGraphics.fillOval(d2 - d5 / 2.0, d3 - d5 / 2.0, d5, d5);
                break;
            }
        }
    }

    public void fillAndDrawSymbol(double d2, double d3, double d4, int n2, Color color) {
        Color color2 = this.getColor();
        this.setColor(color);
        this.fillSymbol(d2, d3, d4, n2);
        this.setColor(color2);
        this.drawSymbol(d2, d3, d4, n2);
    }

    public void fillAndDraw(Shape shape, Color color) {
        Color color2 = this.getColor();
        this.setColor(color);
        this.fill(shape);
        this.setColor(color2);
        this.draw(shape);
    }

    public void clearRect(int n2, int n3, int n4, int n5) {
        this.clearRect((double)n2 + 0.5, (double)n3 + 0.5, (double)n4, (double)n5);
    }

    public void drawLine(int n2, int n3, int n4, int n5) {
        this.drawLine((double)n2 + 0.5, (double)n3 + 0.5, (double)n4 + 0.5, (double)n5 + 0.5);
    }

    public void drawRect(int n2, int n3, int n4, int n5) {
        this.drawRect((double)n2 + 0.5, (double)n3 + 0.5, (double)n4, (double)n5);
    }

    public void fillRect(int n2, int n3, int n4, int n5) {
        this.fillRect((double)n2, (double)n3, (double)n4, (double)n5);
    }

    public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.drawArc((double)n2 + 0.5, (double)n3 + 0.5, (double)n4, (double)n5, (double)n6, (double)n7);
    }

    public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.fillArc((double)n2, (double)n3, (double)n4, (double)n5, (double)n6, (double)n7);
    }

    public void drawOval(int n2, int n3, int n4, int n5) {
        this.drawOval((double)n2 + 0.5, (double)n3 + 0.5, (double)n4, (double)n5);
    }

    public void fillOval(int n2, int n3, int n4, int n5) {
        this.fillOval((double)n2, (double)n3, (double)n4, (double)n5);
    }

    public void drawRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.drawRoundRect((double)n2 + 0.5, (double)n3 + 0.5, (double)n4, (double)n5, (double)n6, (double)n7);
    }

    public void fillRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.fillRoundRect((double)n2, (double)n3, (double)n4, (double)n5, (double)n6, (double)n7);
    }

    public void translate(int n2, int n3) {
        this.translate((double)n2, (double)n3);
    }

    public void setLineWidth(int n2) {
        this.setLineWidth((double)n2);
    }

    public void setLineWidth(double d2) {
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            if ((double)basicStroke.getLineWidth() != d2) {
                stroke = new BasicStroke((float)d2, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase());
                this.setStroke(stroke);
            }
        } else {
            stroke = new BasicStroke((float)d2);
            this.setStroke(stroke);
        }
    }

    public void drawString(String string, int n2, int n3) {
        this.drawString(string, (double)n2, (double)n3);
    }

    public void drawString(String string, float f2, float f3) {
        this.drawString(string, (double)f2, (double)f3);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
        this.drawString(attributedCharacterIterator, (float)n2, (float)n3);
    }

    private Point2D drawFrameAndBanner(TextLayout textLayout, double d2, double d3, int n2, int n3, boolean bl, Color color, double d4, boolean bl2, Color color2) {
        Paint paint;
        Rectangle2D rectangle2D = textLayout.getBounds();
        rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), Math.max((double)textLayout.getAdvance(), rectangle2D.getWidth()), rectangle2D.getHeight());
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d2, d3);
        if (n2 == 3) {
            affineTransform.translate(-rectangle2D.getWidth(), 0.0);
        } else if (n2 == 2) {
            affineTransform.translate(-rectangle2D.getWidth() / 2.0, 0.0);
        }
        if (n3 != 0) {
            if (n3 == 1) {
                affineTransform.translate(0.0, -rectangle2D.getY());
            } else if (n3 == 2) {
                affineTransform.translate(0.0, textLayout.getDescent());
            } else if (n3 == 3) {
                affineTransform.translate(0.0, -rectangle2D.getHeight() - rectangle2D.getY());
            }
        }
        rectangle2D = affineTransform.createTransformedShape(rectangle2D).getBounds2D();
        Point2D point2D = affineTransform.transform(new Point2D.Double(0.0, 0.0), new Point2D.Double());
        double d5 = this.getFont().getSize2D() * 2.0f / 10.0f;
        rectangle2D.setRect(rectangle2D.getX() - d5, rectangle2D.getY() - d5, rectangle2D.getWidth() + 2.0 * d5, rectangle2D.getHeight() + 2.0 * d5);
        if (bl2) {
            paint = this.getPaint();
            this.setColor(color2);
            this.fill(rectangle2D);
            this.setPaint(paint);
        }
        if (bl) {
            paint = this.getPaint();
            Stroke stroke = this.getStroke();
            this.setColor(color);
            this.setLineWidth(d4);
            this.draw(rectangle2D);
            this.setPaint(paint);
            this.setStroke(stroke);
        }
        return point2D;
    }

    public void drawString(String string, double d2, double d3, int n2, int n3, boolean bl, Color color, double d4, boolean bl2, Color color2) {
        TextLayout textLayout = new TextLayout(string, FontUtilities.getAttributes(this.getFont()), this.getFontRenderContext());
        Point2D point2D = this.drawFrameAndBanner(textLayout, d2, d3, n2, n3, bl, color, d4, bl2, color2);
        this.drawString(string, point2D.getX(), point2D.getY());
    }

    public void drawString(TagString tagString, double d2, double d3, int n2, int n3, boolean bl, Color color, double d4, boolean bl2, Color color2) {
        GenericTagHandler genericTagHandler = new GenericTagHandler(this);
        TextLayout textLayout = genericTagHandler.createTextLayout(tagString, (double)this.getFont().getSize2D() / 7.5);
        Point2D point2D = this.drawFrameAndBanner(textLayout, d2, d3, n2, n3, bl, color, d4, bl2, color2);
        genericTagHandler.print(tagString, point2D.getX(), point2D.getY(), (double)this.getFont().getSize2D() / 7.5);
    }

    public void drawString(String string, double d2, double d3, int n2, int n3) {
        this.drawString(string, d2, d3, n2, n3, false, null, 0.0, false, null);
    }

    public void drawString(TagString tagString, double d2, double d3) {
        this.drawString(tagString, d2, d3, 1, 0);
    }

    public void drawString(TagString tagString, double d2, double d3, int n2, int n3) {
        this.drawString(tagString, d2, d3, n2, n3, false, null, 0.0, false, null);
    }

    public int getColorMode() {
        return this.colorMode;
    }

    public void setColorMode(int n2) {
        this.colorMode = n2;
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.currentColor = color;
        this.currentPaint = color;
    }

    public Color getColor() {
        return this.currentColor;
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        if (!(paint instanceof Color)) {
            this.currentColor = null;
        }
        this.currentPaint = paint;
    }

    public Paint getPaint() {
        return this.currentPaint;
    }

    protected Color getPrintColor(Color color) {
        if (this.colorMode == 0) {
            return color;
        }
        PrintColor printColor = PrintColor.createPrintColor(color);
        return printColor.getColor(this.colorMode);
    }

    public void rotate(double d2, double d3, double d4) {
        this.translate(d3, d4);
        this.rotate(d2);
        this.translate(-d3, -d4);
    }

    public void drawArc(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.draw(new Arc2D.Double(d2, d3, d4, d5, d6, d7, 0));
    }

    public void drawLine(double d2, double d3, double d4, double d5) {
        this.draw(new Line2D.Double(d2, d3, d4, d5));
    }

    public void drawOval(double d2, double d3, double d4, double d5) {
        this.draw(new Ellipse2D.Double(d2, d3, d4, d5));
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n2) {
        this.draw(this.createShape(nArray, nArray2, n2, false, true));
    }

    public void drawPolyline(double[] dArray, double[] dArray2, int n2) {
        this.draw(this.createShape(dArray, dArray2, n2, false));
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n2) {
        this.draw(this.createShape(nArray, nArray2, n2, true, true));
    }

    public void drawPolygon(double[] dArray, double[] dArray2, int n2) {
        this.draw(this.createShape(dArray, dArray2, n2, true));
    }

    public void drawRect(double d2, double d3, double d4, double d5) {
        this.draw(new Rectangle2D.Double(d2, d3, d4, d5));
    }

    public void drawRoundRect(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.draw(new RoundRectangle2D.Double(d2, d3, d4, d5, d6, d7));
    }

    public void fillArc(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.fill(new Arc2D.Double(d2, d3, d4, d5, d6, d7, 2));
    }

    public void fillOval(double d2, double d3, double d4, double d5) {
        this.fill(new Ellipse2D.Double(d2, d3, d4, d5));
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n2) {
        this.fill(this.createShape(nArray, nArray2, n2, true, false));
    }

    public void fillPolygon(double[] dArray, double[] dArray2, int n2) {
        this.fill(this.createShape(dArray, dArray2, n2, true));
    }

    public void fillRect(double d2, double d3, double d4, double d5) {
        this.fill(new Rectangle2D.Double(d2, d3, d4, d5));
    }

    public void fillRoundRect(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.fill(new RoundRectangle2D.Double(d2, d3, d4, d5, d6, d7));
    }

    protected abstract Shape createShape(double[] var1, double[] var2, int var3, boolean var4);

    protected Shape createShape(int[] nArray, int[] nArray2, int n2, boolean bl, boolean bl2) {
        float f2 = bl2 ? 0.5f : 0.0f;
        GeneralPath generalPath = new GeneralPath(0);
        if (n2 > 0) {
            generalPath.moveTo((float)nArray[0] + f2, (float)nArray2[0] + f2);
            int n3 = nArray[0];
            int n4 = nArray2[0];
            if (bl && Math.abs(nArray[n2 - 1] - n3) < 1 && Math.abs(nArray2[n2 - 1] - n4) < 1) {
                --n2;
            }
            for (int i2 = 1; i2 < n2; ++i2) {
                if (Math.abs(nArray[i2] - n3) <= 1 && Math.abs(nArray2[i2] - n4) <= 1) continue;
                generalPath.lineTo((float)nArray[i2] + f2, (float)nArray2[i2] + f2);
                n3 = nArray[i2];
                n4 = nArray2[i2];
            }
            if (bl) {
                generalPath.closePath();
            }
        }
        return generalPath;
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        if (bl && this.getStroke() != null) {
            shape = this.getStroke().createStrokedShape(shape);
        }
        if (this.getTransform() != null) {
            shape = this.getTransform().createTransformedShape(shape);
        }
        Area area = new Area(shape);
        if (this.getClip() != null) {
            area.intersect(new Area(this.getClip()));
        }
        return area.intersects(rectangle);
    }
}

